#ifndef morpheo_behavioural_core_multi_front_end_front_end_decod_unit_decod_queue_Decod_queue_h
#define morpheo_behavioural_core_multi_front_end_front_end_decod_unit_decod_queue_Decod_queue_h

/*
 * $Id: Decod_queue.h 108 2009-02-12 11:55:06Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include <iostream>
#include <list>

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {


  class Decod_queue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
  private   : counter_t                     ** _stat_nb_inst;
  private   : counter_t                      * _stat_use_queue;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "decod_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_IN_VAL            ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_IN_ACK            ;//[nb_inst_decod]
  public    : SC_IN (Tcontext_t         )  **  in_DECOD_IN_CONTEXT_ID     ;//[nb_inst_decod]
  public    : SC_IN (Tdepth_t           )  **  in_DECOD_IN_DEPTH          ;//[nb_inst_decod]
  public    : SC_IN (Ttype_t            )  **  in_DECOD_IN_TYPE           ;//[nb_inst_decod]
  public    : SC_IN (Toperation_t       )  **  in_DECOD_IN_OPERATION      ;//[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_IN_NO_EXECUTE     ;//[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_IN_IS_DELAY_SLOT  ;//[nb_inst_decod]
#ifdef DEBUG
  public    : SC_IN (Tgeneral_data_t    )  **  in_DECOD_IN_ADDRESS        ;//[nb_inst_decod]
#endif
  public    : SC_IN (Tgeneral_data_t    )  **  in_DECOD_IN_ADDRESS_NEXT   ;//[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_IN_HAS_IMMEDIAT   ;//[nb_inst_decod]
  public    : SC_IN (Tgeneral_data_t    )  **  in_DECOD_IN_IMMEDIAT       ;//[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_IN_READ_RA        ;//[nb_inst_decod]
  public    : SC_IN (Tgeneral_address_t )  **  in_DECOD_IN_NUM_REG_RA     ;//[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_IN_READ_RB        ;//[nb_inst_decod]
  public    : SC_IN (Tgeneral_address_t )  **  in_DECOD_IN_NUM_REG_RB     ;//[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_IN_READ_RC        ;//[nb_inst_decod]
  public    : SC_IN (Tspecial_address_t )  **  in_DECOD_IN_NUM_REG_RC     ;//[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_IN_WRITE_RD       ;//[nb_inst_decod]
  public    : SC_IN (Tgeneral_address_t )  **  in_DECOD_IN_NUM_REG_RD     ;//[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_IN_WRITE_RE       ;//[nb_inst_decod]
  public    : SC_IN (Tspecial_address_t )  **  in_DECOD_IN_NUM_REG_RE     ;//[nb_inst_decod]
  public    : SC_IN (Texception_t       )  **  in_DECOD_IN_EXCEPTION_USE  ;//[nb_inst_decod]
  public    : SC_IN (Texception_t       )  **  in_DECOD_IN_EXCEPTION      ;//[nb_inst_decod]

    // ~~~~~[ Interface : "decod_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_OUT_VAL           ;//[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_OUT_ACK           ;//[nb_inst_decod]
  public    : SC_OUT(Tcontext_t         )  ** out_DECOD_OUT_CONTEXT_ID    ;//[nb_inst_decod]
  public    : SC_OUT(Tdepth_t           )  ** out_DECOD_OUT_DEPTH         ;//[nb_inst_decod]
  public    : SC_OUT(Ttype_t            )  ** out_DECOD_OUT_TYPE          ;//[nb_inst_decod]
  public    : SC_OUT(Toperation_t       )  ** out_DECOD_OUT_OPERATION     ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_OUT_NO_EXECUTE    ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_OUT_IS_DELAY_SLOT ;//[nb_inst_decod]
#ifdef DEBUG
  public    : SC_OUT(Tgeneral_data_t    )  ** out_DECOD_OUT_ADDRESS       ;//[nb_inst_decod]
#endif
  public    : SC_OUT(Tgeneral_data_t    )  ** out_DECOD_OUT_ADDRESS_NEXT  ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_OUT_HAS_IMMEDIAT  ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_data_t    )  ** out_DECOD_OUT_IMMEDIAT      ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_OUT_READ_RA       ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_address_t )  ** out_DECOD_OUT_NUM_REG_RA    ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_OUT_READ_RB       ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_address_t )  ** out_DECOD_OUT_NUM_REG_RB    ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_OUT_READ_RC       ;//[nb_inst_decod]
  public    : SC_OUT(Tspecial_address_t )  ** out_DECOD_OUT_NUM_REG_RC    ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_OUT_WRITE_RD      ;//[nb_inst_decod]
  public    : SC_OUT(Tgeneral_address_t )  ** out_DECOD_OUT_NUM_REG_RD    ;//[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_OUT_WRITE_RE      ;//[nb_inst_decod]
  public    : SC_OUT(Tspecial_address_t )  ** out_DECOD_OUT_NUM_REG_RE    ;//[nb_inst_decod]
  public    : SC_OUT(Texception_t       )  ** out_DECOD_OUT_EXCEPTION_USE ;//[nb_inst_decod]
  public    : SC_OUT(Texception_t       )  ** out_DECOD_OUT_EXCEPTION     ;//[nb_inst_decod]

    // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tdepth_t           )  **  in_DEPTH_MIN               ;//[nb_context]
  public    : SC_IN (Tdepth_t           )  **  in_DEPTH_MAX               ;//[nb_context]
  public    : SC_IN (Tcontrol_t         )  **  in_DEPTH_FULL              ;//[nb_context]

    // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcounter_t         )  ** out_NB_INST_ALL             ;//[nb_context]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : std::list<decod_queue_entry_t*>* reg_QUEUE                  ;
  private   : uint32_t                       * reg_NB_INST                ;//[nb_context]
  private   : uint32_t                         reg_LAST_SLOT              ;

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : Tcontrol_t                     * internal_DECOD_IN_ACK      ;//[nb_inst_decod]
  private   : Tcontrol_t                     * internal_DECOD_OUT_VAL     ;//[nb_inst_decod]
  private   : Tcontrol_t                     * internal_DECOD_OUT_ACK     ;//[nb_inst_decod]
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Decod_queue);
#endif
  public  :          Decod_queue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Decod_queue             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
  public  : void        genMoore                  (void);
  public  : void        genMealy_decod_out        (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
