/*
 * $Id: Write_queue.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Write_queue/include/Write_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace write_queue {


#undef  FUNCTION
#define FUNCTION "Write_queue::Write_queue"
  Write_queue::Write_queue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Write_queue,FUNCTION,"Begin");

#if DEBUG_Write_queue == true
    log_printf(INFO,Write_queue,FUNCTION,_("<%s> Parameters"),_name.c_str());

    std::cout << *param << std::endl;
#endif    

    log_printf(INFO,Write_queue,FUNCTION,"Allocation");
    allocation ();

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Write_queue,FUNCTION,"Allocation of statistics");

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Write_queue,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Write_queue,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Write_queue,FUNCTION,"Method - genMoore");

	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_printf(FUNC,Write_queue,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Write_queue::~Write_queue"
  Write_queue::~Write_queue (void)
  {
    log_printf(FUNC,Write_queue,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	log_printf(INFO,Write_queue,FUNCTION,"Generate Statistics file");
	
	delete _stat;
      }
#endif

    log_printf(INFO,Write_queue,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Write_queue,FUNCTION,"End");
  };

}; // end namespace write_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
