/*
 * Test_051
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.sfne, l.sfnei
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        /*
              A     B    F
         01)  2107  1981 1
         02)  2107 -1981 1
         03) -2107  1981 1
         04) -2107 -1981 1
         05)  1981  2107 1
         06)  1981 -2107 1
         07) -1981  2107 1
         08) -1981 -2107 1
         09)  1407  1407 0
         10)  1407 -1407 1
         11) -1407  1407 1
         12) -1407 -1407 0
        */

        /* Register */
        l.xori  r1,r0,  2107
        l.xori  r2,r0,  1981
        l.sfne  r1, r2
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0,  2107
        l.xori  r2,r0, -1981
        l.sfne  r1, r2
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0, -2107
        l.xori  r2,r0,  1981
        l.sfne  r1, r2
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0, -2107
        l.xori  r2,r0, -1981
        l.sfne  r1, r2
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0,  1981
        l.xori  r2,r0,  2107
        l.sfne  r1, r2
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0,  1981
        l.xori  r2,r0, -2107
        l.sfne  r1, r2
        l.bnf   _end_ko
        l.nop
        
        l.xori  r1,r0, -1981
        l.xori  r2,r0,  2107
        l.sfne  r1, r2
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0, -1981
        l.xori  r2,r0, -2107
        l.sfne  r1, r2
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0,  1407
        l.xori  r2,r0,  1407
        l.sfne  r1, r2
        l.bf    _end_ko
        l.nop

        l.xori  r1,r0,  1407
        l.xori  r2,r0, -1407
        l.sfne  r1, r2
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0, -1407
        l.xori  r2,r0,  1407
        l.sfne  r1, r2
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0, -1407
        l.xori  r2,r0, -1407
        l.sfne  r1, r2
        l.bf    _end_ko
        l.nop

        /* immediat */
        l.xori  r1,r0,  2107
        l.sfnei r1,  1981
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0,  2107
        l.sfnei r1, -1981
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0, -2107
        l.sfnei r1,  1981
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0, -2107
        l.sfnei r1, -1981
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0,  1981
        l.sfnei r1,  2107
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0,  1981
        l.sfnei r1, -2107
        l.bnf   _end_ko
        l.nop
        
        l.xori  r1,r0, -1981
        l.sfnei r1,  2107
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0, -1981
        l.sfnei r1, -2107
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0,  1407
        l.sfnei r1,  1407
        l.bf    _end_ko
        l.nop

        l.xori  r1,r0,  1407
        l.sfnei r1, -1407
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0, -1407
        l.sfnei r1,  1407
        l.bnf   _end_ko
        l.nop

        l.xori  r1,r0, -1407
        l.sfnei r1, -1407
        l.bf    _end_ko
        l.nop
        
        /* end test */
        l.j     _end_ok
        l.nop
