/*
 * $id: Decod_allocation.cpp 86 2008-05-14 17:08:56Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/include/Decod.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {



#undef  FUNCTION
#define FUNCTION "Decod::allocation"
  void Decod::allocation (
#ifdef STATISTICS
                               morpheo::behavioural::Parameters_Statistics * param_statistics
#else
                               void
#endif
                               )
  {
    log_printf(FUNC,Decod,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
                                              ,"Decod"
#ifdef POSITION
                                              ,COMBINATORY 
#endif
                                              );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
                                                         ,IN
                                                         ,SOUTH,
                                                         "Generalist interface"
#endif
                                                         );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "ifetch" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE("ifetch", IN, WEST, "Instruction's bundle", _param->_nb_context, _param->_nb_inst_fetch[it1]);

      
      _ALLOC2_VALACK_IN ( in_IFETCH_VAL        ,VAL, _param->_nb_context, _param->_nb_inst_fetch[it1]);
      _ALLOC2_VALACK_OUT(out_IFETCH_ACK        ,ACK, _param->_nb_context, _param->_nb_inst_fetch[it1]);
      _ALLOC2_SIGNAL_IN ( in_IFETCH_INSTRUCTION,"instruction", Tinstruction_t, _param->_size_instruction,_param->_nb_context, _param->_nb_inst_fetch[it1]);
    }
    {
      ALLOC1_INTERFACE("ifetch", IN, WEST, "Instruction's bundle", _param->_nb_context);
      
      ALLOC1_SIGNAL_IN (in_IFETCH_CONTEXT_ID                 ,"context_id"                 ,Tcontext_t         ,_param->_size_context_id      );
      ALLOC1_SIGNAL_IN (in_IFETCH_ADDRESS                    ,"address"                    ,Tgeneral_address_t ,_param->_size_instruction_address    );
//    ALLOC1_SIGNAL_IN (in_IFETCH_ADDRESS_NEXT               ,"address_next"               ,Tgeneral_address_t ,_param->_size_instruction_address    );
      ALLOC1_SIGNAL_IN (in_IFETCH_INST_IFETCH_PTR            ,"inst_ifetch_ptr"            ,Tinst_ifetch_ptr_t ,_param->_size_inst_ifetch_ptr );
      ALLOC1_SIGNAL_IN (in_IFETCH_BRANCH_STATE               ,"branch_state"               ,Tbranch_state_t    ,_param->_size_branch_state    );
      ALLOC1_SIGNAL_IN (in_IFETCH_BRANCH_UPDATE_PREDICTION_ID,"branch_update_prediction_id",Tprediction_ptr_t  ,_param->_size_depth           );
      ALLOC1_SIGNAL_IN (in_IFETCH_EXCEPTION                  ,"exception"                  ,Texception_t       ,_param->_size_exception_ifetch);
    }

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~           
    {
      ALLOC1_INTERFACE("decod", OUT, EAST, "Instructiont decoded", _param->_nb_inst_decod);

      ALLOC1_VALACK_OUT(out_DECOD_VAL          ,VAL);
      ALLOC1_VALACK_IN ( in_DECOD_ACK          ,ACK);
      ALLOC1_SIGNAL_OUT(out_DECOD_CONTEXT_ID   ,"context_id"   ,Tcontext_t        ,_param->_size_context_id            );
      ALLOC1_SIGNAL_OUT(out_DECOD_DEPTH        ,"depth"        ,Tdepth_t          ,_param->_size_depth                 );
      ALLOC1_SIGNAL_OUT(out_DECOD_TYPE         ,"type"         ,Ttype_t           ,_param->_size_type                  );
      ALLOC1_SIGNAL_OUT(out_DECOD_OPERATION    ,"operation"    ,Toperation_t      ,_param->_size_operation             );
      ALLOC1_SIGNAL_OUT(out_DECOD_NO_EXECUTE   ,"no_execute"   ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_DECOD_IS_DELAY_SLOT,"is_delay_slot",Tcontrol_t        ,1                                   );
#ifdef DEBUG
      ALLOC1_SIGNAL_OUT(out_DECOD_ADDRESS      ,"address"      ,Tgeneral_data_t   ,_param->_size_instruction_address   );
#endif
      ALLOC1_SIGNAL_OUT(out_DECOD_ADDRESS_NEXT ,"address_next" ,Tgeneral_data_t   ,_param->_size_instruction_address   );
      ALLOC1_SIGNAL_OUT(out_DECOD_HAS_IMMEDIAT ,"has_immediat" ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_DECOD_IMMEDIAT     ,"immediat"     ,Tgeneral_data_t   ,_param->_size_general_data          );
      ALLOC1_SIGNAL_OUT(out_DECOD_READ_RA      ,"read_ra"      ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_DECOD_NUM_REG_RA   ,"num_reg_ra"   ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT(out_DECOD_READ_RB      ,"read_rb"      ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_DECOD_NUM_REG_RB   ,"num_reg_rb"   ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT(out_DECOD_READ_RC      ,"read_rc"      ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_DECOD_NUM_REG_RC   ,"num_reg_rc"   ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_OUT(out_DECOD_WRITE_RD     ,"write_rd"     ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_DECOD_NUM_REG_RD   ,"num_reg_rd"   ,Tgeneral_address_t,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT(out_DECOD_WRITE_RE     ,"write_re"     ,Tcontrol_t        ,1                                   );
      ALLOC1_SIGNAL_OUT(out_DECOD_NUM_REG_RE   ,"num_reg_re"   ,Tspecial_address_t,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_OUT(out_DECOD_EXCEPTION_USE,"exception_use",Texception_t      ,_param->_size_exception_use         );
      ALLOC1_SIGNAL_OUT(out_DECOD_EXCEPTION    ,"exception"    ,Texception_t      ,_param->_size_exception_decod       );
    }

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("predict",OUT,NORTH,"Decod a branch -> inform the branch predictor.",_param->_nb_inst_decod);

      ALLOC1_VALACK_OUT(out_PREDICT_VAL                        ,VAL);
      ALLOC1_VALACK_IN ( in_PREDICT_ACK                        ,ACK);
      ALLOC1_SIGNAL_OUT(out_PREDICT_CONTEXT_ID                 ,"context_id"                 ,Tcontext_t         ,_param->_size_context_id      );
      ALLOC1_SIGNAL_OUT(out_PREDICT_MATCH_INST_IFETCH_PTR      ,"match_inst_ifetch_ptr"      ,Tcontrol_t         ,1                             );
      ALLOC1_SIGNAL_OUT(out_PREDICT_BRANCH_STATE               ,"branch_state"               ,Tbranch_state_t    ,_param->_size_branch_state    );
      ALLOC1_SIGNAL_OUT(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,"branch_update_prediction_id",Tprediction_ptr_t  ,_param->_size_depth           );
      ALLOC1_SIGNAL_OUT(out_PREDICT_BRANCH_CONDITION           ,"branch_condition"           ,Tbranch_condition_t,_param->_size_branch_condition);
//    ALLOC1_SIGNAL_OUT(out_PREDICT_BRANCH_STACK_WRITE         ,"branch_stack_write"         ,Tcontrol_t         ,1                             );
      ALLOC1_SIGNAL_OUT(out_PREDICT_BRANCH_DIRECTION           ,"branch_direction"           ,Tcontrol_t         ,1                             );
      ALLOC1_SIGNAL_OUT(out_PREDICT_ADDRESS_SRC                ,"address_src"                ,Tgeneral_data_t    ,_param->_size_instruction_address    );
      ALLOC1_SIGNAL_OUT(out_PREDICT_ADDRESS_DEST               ,"address_dest"               ,Tgeneral_data_t    ,_param->_size_instruction_address    );
//    ALLOC1_SIGNAL_IN ( in_PREDICT_CAN_CONTINUE               ,"can_continue"               ,Tcontrol_t         ,1                             );
    }
    
    // ~~~~~[ Interface : "context" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("context", IN, NORTH, "context's information", _param->_nb_context);

      ALLOC1_SIGNAL_IN (in_CONTEXT_DECOD_ENABLE,"decod_enable",Tcontrol_t,1);
      ALLOC1_SIGNAL_IN (in_CONTEXT_DEPTH_VAL   ,"depth_val"   ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN (in_CONTEXT_DEPTH       ,"depth"       ,Tdepth_t  ,_param->_size_depth);
    }

    // ~~~~~[ Interface : "context_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~           
    {
      ALLOC_INTERFACE("context_event", OUT, NORTH, "context's evenement");

      ALLOC_VALACK_OUT(out_CONTEXT_EVENT_VAL          ,VAL);
      ALLOC_VALACK_IN ( in_CONTEXT_EVENT_ACK          ,ACK);
      ALLOC_SIGNAL_OUT(out_CONTEXT_EVENT_CONTEXT_ID   ,"context_id"   ,Tcontext_t     ,_param->_size_context_id  );
      ALLOC_SIGNAL_OUT(out_CONTEXT_EVENT_DEPTH        ,"depth"        ,Tdepth_t       ,_param->_size_depth       );
      ALLOC_SIGNAL_OUT(out_CONTEXT_EVENT_TYPE         ,"type"         ,Tevent_type_t  ,_param->_size_event_type  );
      ALLOC_SIGNAL_OUT(out_CONTEXT_EVENT_IS_DELAY_SLOT,"is_delay_slot",Tcontrol_t     ,1                         );
      ALLOC_SIGNAL_OUT(out_CONTEXT_EVENT_ADDRESS      ,"address"      ,Tgeneral_data_t,_param->_size_instruction_address);
      ALLOC_SIGNAL_OUT(out_CONTEXT_EVENT_ADDRESS_EPCR ,"address_epcr" ,Tgeneral_data_t,_param->_size_instruction_address);
    }


    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
    reg_CONTEXT_ADDRESS_PREVIOUS      = new Tgeneral_data_t [_param->_nb_context];
    reg_CONTEXT_IS_DELAY_SLOT         = new Tcontrol_t      [_param->_nb_context];

    internal_CONTEXT_HAVE_TRANSACTION = new Tcontrol_t      [_param->_nb_context];
    internal_CONTEXT_ADDRESS_PREVIOUS = new Tgeneral_data_t [_param->_nb_context];
    internal_CONTEXT_IS_DELAY_SLOT    = new Tcontrol_t      [_param->_nb_context];

#ifdef STATISTICS
    internal_DECOD_VAL                = new Tcontrol_t      [_param->_nb_inst_decod];
#endif
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    _priority = new generic::priority::Priority (_name+"_priority"      ,
                                                 _param->_priority      ,
                                                 _param->_load_balancing,
                                                 _param->_nb_context    ,
                                                 _param->_nb_inst_fetch ,
                                                 _param->_nb_context_select);

    const uint32_t nb_opcod_type = 14;
    const uint32_t tab_opcod_type [] = {MAX_OPCOD_0,
                                        MAX_OPCOD_1 ,
                                        MAX_OPCOD_2 ,
                                        MAX_OPCOD_3 ,
                                        MAX_OPCOD_4 ,
                                        MAX_OPCOD_5 ,
                                        MAX_OPCOD_6 ,
                                        MAX_OPCOD_7 ,
                                        MAX_OPCOD_8 ,
                                        MAX_OPCOD_9 ,
                                        MAX_OPCOD_10,
                                        MAX_OPCOD_11,
                                        MAX_OPCOD_12,
                                        MAX_OPCOD_13};
    
    _function_decod  = new function_decod_t *** [_param->_nb_context];
    _function_custom = new function_decod_t *** [_param->_nb_context];
    for (uint32_t i=0; i<_param->_nb_context; i++)
      {
        _function_decod  [i] = new function_decod_t ** [nb_opcod_type];
        _function_custom [i] = new function_decod_t ** [nb_opcod_type];
        for (uint32_t j=0; j<nb_opcod_type; j++)
          {
            _function_decod  [i][j] = new function_decod_t * [tab_opcod_type[j]];
            _function_custom [i][j] = new function_decod_t * [tab_opcod_type[j]];
            for (uint32_t k=0; k<tab_opcod_type[j]; k++)
              {
                _function_decod  [i][j][k] = &(instruction_illegal);
                _function_custom [i][j][k] = &(instruction_illegal);
              }
          }

        // Create indirection
        _function_decod[i][0][OPCOD_1 ] = &(instruction_decod_type_1 ); // Instruction ORFPX32/64                
        _function_decod[i][0][OPCOD_2 ] = &(instruction_decod_type_2 ); // Instruction ORVDX64                    
        _function_decod[i][0][OPCOD_3 ] = &(instruction_decod_type_3 ); // Instructions Register-Register         
        _function_decod[i][0][OPCOD_4 ] = &(instruction_decod_type_4 ); // Instructions "set flag" with register 
        _function_decod[i][0][OPCOD_5 ] = &(instruction_decod_type_5 ); // Instructions "set flag" with immediat 
        _function_decod[i][0][OPCOD_6 ] = &(instruction_decod_type_6 ); // Instruction Shift/Rotate with immediat
        _function_decod[i][0][OPCOD_7 ] = &(instruction_decod_type_7 ); // Instructions multiply with HI-LO       
        _function_decod[i][0][OPCOD_8 ] = &(instruction_decod_type_8 ); // Instructions acces at HI-LO      
        _function_decod[i][0][OPCOD_9 ] = &(instruction_decod_type_9 ); // Instructions special             
        _function_decod[i][0][OPCOD_10] = &(instruction_decod_type_10); // Instructions no operation              
        _function_decod[i][3][OPCOD_11] = &(instruction_decod_type_11); // Instruction Shift/Rotate with register
        _function_decod[i][3][OPCOD_12] = &(instruction_decod_type_12); // Instructions extend                    
        _function_decod[i][3][OPCOD_13] = &(instruction_decod_type_13); // Instructions extend (64b)              

        if (_param->_instruction_implemeted[i][INSTRUCTION_L_ADD      ]) _function_decod[i][ 3][OPCOD_L_ADD      ] = &(instruction_l_add            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_ADDC     ]) _function_decod[i][ 3][OPCOD_L_ADDC     ] = &(instruction_l_addc           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_ADDI     ]) _function_decod[i][ 0][OPCOD_L_ADDI     ] = &(instruction_l_addi           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_ADDIC    ]) _function_decod[i][ 0][OPCOD_L_ADDIC    ] = &(instruction_l_addic          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_AND      ]) _function_decod[i][ 3][OPCOD_L_AND      ] = &(instruction_l_and            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_ANDI     ]) _function_decod[i][ 0][OPCOD_L_ANDI     ] = &(instruction_l_andi           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_BF       ]) _function_decod[i][ 0][OPCOD_L_BF       ] = &(instruction_l_bf             );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_BNF      ]) _function_decod[i][ 0][OPCOD_L_BNF      ] = &(instruction_l_bnf            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CMOV     ]) _function_decod[i][ 3][OPCOD_L_CMOV     ] = &(instruction_l_cmov           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CSYNC    ]) _function_decod[i][ 9][OPCOD_L_CSYNC    ] = &(instruction_l_csync          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_DIV      ]) _function_decod[i][ 3][OPCOD_L_DIV      ] = &(instruction_l_div            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_DIVU     ]) _function_decod[i][ 3][OPCOD_L_DIVU     ] = &(instruction_l_divu           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_EXTBS    ]) _function_decod[i][12][OPCOD_L_EXTBS    ] = &(instruction_l_extbs          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_EXTBZ    ]) _function_decod[i][12][OPCOD_L_EXTBZ    ] = &(instruction_l_extbz          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_EXTHS    ]) _function_decod[i][12][OPCOD_L_EXTHS    ] = &(instruction_l_exths          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_EXTHZ    ]) _function_decod[i][12][OPCOD_L_EXTHZ    ] = &(instruction_l_exthz          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_EXTWS    ]) _function_decod[i][13][OPCOD_L_EXTWS    ] = &(instruction_l_extws          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_EXTWZ    ]) _function_decod[i][13][OPCOD_L_EXTWZ    ] = &(instruction_l_extwz          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_FF1      ]) _function_decod[i][ 3][OPCOD_L_FF1      ] = &(instruction_l_ff1            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_FL1      ]) _function_decod[i][ 3][OPCOD_L_FL1      ] = &(instruction_l_fl1            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_J        ]) _function_decod[i][ 0][OPCOD_L_J        ] = &(instruction_l_j              );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_JAL      ]) _function_decod[i][ 0][OPCOD_L_JAL      ] = &(instruction_l_jal            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_JALR     ]) _function_decod[i][ 0][OPCOD_L_JALR     ] = &(instruction_l_jalr           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_JR       ]) _function_decod[i][ 0][OPCOD_L_JR       ] = &(instruction_l_jr             );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_LBS      ]) _function_decod[i][ 0][OPCOD_L_LBS      ] = &(instruction_l_lbs            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_LBZ      ]) _function_decod[i][ 0][OPCOD_L_LBZ      ] = &(instruction_l_lbz            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_LD       ]) _function_decod[i][ 0][OPCOD_L_LD       ] = &(instruction_l_ld             );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_LHS      ]) _function_decod[i][ 0][OPCOD_L_LHS      ] = &(instruction_l_lhs            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_LHZ      ]) _function_decod[i][ 0][OPCOD_L_LHZ      ] = &(instruction_l_lhz            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_LWS      ]) _function_decod[i][ 0][OPCOD_L_LWS      ] = &(instruction_l_lws            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_LWZ      ]) _function_decod[i][ 0][OPCOD_L_LWZ      ] = &(instruction_l_lwz            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_MAC      ]) _function_decod[i][ 7][OPCOD_L_MAC      ] = &(instruction_l_mac            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_MACI     ]) _function_decod[i][ 0][OPCOD_L_MACI     ] = &(instruction_l_maci           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_MACRC    ]) _function_decod[i][ 8][OPCOD_L_MACRC    ] = &(instruction_l_macrc          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_MFSPR    ]) _function_decod[i][ 0][OPCOD_L_MFSPR    ] = &(instruction_l_mfspr          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_MOVHI    ]) _function_decod[i][ 8][OPCOD_L_MOVHI    ] = &(instruction_l_movhi          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_MSB      ]) _function_decod[i][ 7][OPCOD_L_MSB      ] = &(instruction_l_msb            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_MSYNC    ]) _function_decod[i][ 9][OPCOD_L_MSYNC    ] = &(instruction_l_msync          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_MTSPR    ]) _function_decod[i][ 0][OPCOD_L_MTSPR    ] = &(instruction_l_mtspr          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_MUL      ]) _function_decod[i][ 3][OPCOD_L_MUL      ] = &(instruction_l_mul            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_MULI     ]) _function_decod[i][ 0][OPCOD_L_MULI     ] = &(instruction_l_muli           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_MULU     ]) _function_decod[i][ 3][OPCOD_L_MULU     ] = &(instruction_l_mulu           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_NOP      ]) _function_decod[i][10][OPCOD_L_NOP      ] = &(instruction_l_nop            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_OR       ]) _function_decod[i][ 3][OPCOD_L_OR       ] = &(instruction_l_or             );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_ORI      ]) _function_decod[i][ 0][OPCOD_L_ORI      ] = &(instruction_l_ori            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_PSYNC    ]) _function_decod[i][ 9][OPCOD_L_PSYNC    ] = &(instruction_l_psync          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_RFE      ]) _function_decod[i][ 0][OPCOD_L_RFE      ] = &(instruction_l_rfe            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_ROR      ]) _function_decod[i][11][OPCOD_L_ROR      ] = &(instruction_l_ror            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_RORI     ]) _function_decod[i][ 6][OPCOD_L_RORI     ] = &(instruction_l_rori           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SB       ]) _function_decod[i][ 0][OPCOD_L_SB       ] = &(instruction_l_sb             );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SD       ]) _function_decod[i][ 0][OPCOD_L_SD       ] = &(instruction_l_sd             );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFEQ     ]) _function_decod[i][ 4][OPCOD_L_SFEQ     ] = &(instruction_l_sfeq           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFEQI    ]) _function_decod[i][ 5][OPCOD_L_SFEQI    ] = &(instruction_l_sfeqi          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFGES    ]) _function_decod[i][ 4][OPCOD_L_SFGES    ] = &(instruction_l_sfges          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFGESI   ]) _function_decod[i][ 5][OPCOD_L_SFGESI   ] = &(instruction_l_sfgesi         );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFGEU    ]) _function_decod[i][ 4][OPCOD_L_SFGEU    ] = &(instruction_l_sfgeu          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFGEUI   ]) _function_decod[i][ 5][OPCOD_L_SFGEUI   ] = &(instruction_l_sfgeui         );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFGTS    ]) _function_decod[i][ 4][OPCOD_L_SFGTS    ] = &(instruction_l_sfgts          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFGTSI   ]) _function_decod[i][ 5][OPCOD_L_SFGTSI   ] = &(instruction_l_sfgtsi         );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFGTU    ]) _function_decod[i][ 4][OPCOD_L_SFGTU    ] = &(instruction_l_sfgtu          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFGTUI   ]) _function_decod[i][ 5][OPCOD_L_SFGTUI   ] = &(instruction_l_sfgtui         );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFLES    ]) _function_decod[i][ 4][OPCOD_L_SFLES    ] = &(instruction_l_sfles          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFLESI   ]) _function_decod[i][ 5][OPCOD_L_SFLESI   ] = &(instruction_l_sflesi         );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFLEU    ]) _function_decod[i][ 4][OPCOD_L_SFLEU    ] = &(instruction_l_sfleu          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFLEUI   ]) _function_decod[i][ 5][OPCOD_L_SFLEUI   ] = &(instruction_l_sfleui         );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFLTS    ]) _function_decod[i][ 4][OPCOD_L_SFLTS    ] = &(instruction_l_sflts          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFLTSI   ]) _function_decod[i][ 5][OPCOD_L_SFLTSI   ] = &(instruction_l_sfltsi         );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFLTU    ]) _function_decod[i][ 4][OPCOD_L_SFLTU    ] = &(instruction_l_sfltu          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFLTUI   ]) _function_decod[i][ 5][OPCOD_L_SFLTUI   ] = &(instruction_l_sfltui         );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFNE     ]) _function_decod[i][ 4][OPCOD_L_SFNE     ] = &(instruction_l_sfne           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SFNEI    ]) _function_decod[i][ 5][OPCOD_L_SFNEI    ] = &(instruction_l_sfnei          );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SH       ]) _function_decod[i][ 0][OPCOD_L_SH       ] = &(instruction_l_sh             );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SLL      ]) _function_decod[i][11][OPCOD_L_SLL      ] = &(instruction_l_sll            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SLLI     ]) _function_decod[i][ 6][OPCOD_L_SLLI     ] = &(instruction_l_slli           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SRA      ]) _function_decod[i][11][OPCOD_L_SRA      ] = &(instruction_l_sra            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SRAI     ]) _function_decod[i][ 6][OPCOD_L_SRAI     ] = &(instruction_l_srai           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SRL      ]) _function_decod[i][11][OPCOD_L_SRL      ] = &(instruction_l_srl            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SRLI     ]) _function_decod[i][ 6][OPCOD_L_SRLI     ] = &(instruction_l_srli           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SUB      ]) _function_decod[i][ 3][OPCOD_L_SUB      ] = &(instruction_l_sub            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SW       ]) _function_decod[i][ 0][OPCOD_L_SW       ] = &(instruction_l_sw             );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_SYS      ]) _function_decod[i][ 9][OPCOD_L_SYS      ] = &(instruction_l_sys            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_TRAP     ]) _function_decod[i][ 9][OPCOD_L_TRAP     ] = &(instruction_l_trap           );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_XOR      ]) _function_decod[i][ 3][OPCOD_L_XOR      ] = &(instruction_l_xor            );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_XORI     ]) _function_decod[i][ 0][OPCOD_L_XORI     ] = &(instruction_l_xori           );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_ADD_D   ]) _function_decod[i][ 1][OPCOD_LF_ADD_D   ] = &(instruction_lf_add_d    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_ADD_S   ]) _function_decod[i][ 1][OPCOD_LF_ADD_S   ] = &(instruction_lf_add_s    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_DIV_D   ]) _function_decod[i][ 1][OPCOD_LF_DIV_D   ] = &(instruction_lf_div_d    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_DIV_S   ]) _function_decod[i][ 1][OPCOD_LF_DIV_S   ] = &(instruction_lf_div_s    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_FTOI_D  ]) _function_decod[i][ 1][OPCOD_LF_FTOI_D  ] = &(instruction_lf_ftoi_d   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_FTOI_S  ]) _function_decod[i][ 1][OPCOD_LF_FTOI_S  ] = &(instruction_lf_ftoi_s   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_ITOF_D  ]) _function_decod[i][ 1][OPCOD_LF_ITOF_D  ] = &(instruction_lf_itof_d   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_ITOF_S  ]) _function_decod[i][ 1][OPCOD_LF_ITOF_S  ] = &(instruction_lf_itof_s   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_MADD_D  ]) _function_decod[i][ 1][OPCOD_LF_MADD_D  ] = &(instruction_lf_madd_d   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_MADD_S  ]) _function_decod[i][ 1][OPCOD_LF_MADD_S  ] = &(instruction_lf_madd_s   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_MUL_D   ]) _function_decod[i][ 1][OPCOD_LF_MUL_D   ] = &(instruction_lf_mul_d    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_MUL_S   ]) _function_decod[i][ 1][OPCOD_LF_MUL_S   ] = &(instruction_lf_mul_s    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_REM_D   ]) _function_decod[i][ 1][OPCOD_LF_REM_D   ] = &(instruction_lf_rem_d    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_REM_S   ]) _function_decod[i][ 1][OPCOD_LF_REM_S   ] = &(instruction_lf_rem_s    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_SFEQ_D  ]) _function_decod[i][ 1][OPCOD_LF_SFEQ_D  ] = &(instruction_lf_sfeq_d   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_SFEQ_S  ]) _function_decod[i][ 1][OPCOD_LF_SFEQ_S  ] = &(instruction_lf_sfeq_s   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_SFGE_D  ]) _function_decod[i][ 1][OPCOD_LF_SFGE_D  ] = &(instruction_lf_sfge_d   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_SFGE_S  ]) _function_decod[i][ 1][OPCOD_LF_SFGE_S  ] = &(instruction_lf_sfge_s   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_SFGT_D  ]) _function_decod[i][ 1][OPCOD_LF_SFGT_D  ] = &(instruction_lf_sfgt_d   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_SFGT_S  ]) _function_decod[i][ 1][OPCOD_LF_SFGT_S  ] = &(instruction_lf_sfgt_s   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_SFLE_D  ]) _function_decod[i][ 1][OPCOD_LF_SFLE_D  ] = &(instruction_lf_sfle_d   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_SFLE_S  ]) _function_decod[i][ 1][OPCOD_LF_SFLE_S  ] = &(instruction_lf_sfle_s   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_SFLT_D  ]) _function_decod[i][ 1][OPCOD_LF_SFLT_D  ] = &(instruction_lf_sflt_d   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_SFLT_S  ]) _function_decod[i][ 1][OPCOD_LF_SFLT_S  ] = &(instruction_lf_sflt_s   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_SFNE_D  ]) _function_decod[i][ 1][OPCOD_LF_SFNE_D  ] = &(instruction_lf_sfne_d   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_SFNE_S  ]) _function_decod[i][ 1][OPCOD_LF_SFNE_S  ] = &(instruction_lf_sfne_s   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_SUB_D   ]) _function_decod[i][ 1][OPCOD_LF_SUB_D   ] = &(instruction_lf_sub_d    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_SUB_S   ]) _function_decod[i][ 1][OPCOD_LF_SUB_S   ] = &(instruction_lf_sub_s    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ADD_B   ]) _function_decod[i][ 2][OPCOD_LV_ADD_B   ] = &(instruction_lv_add_b    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ADD_H   ]) _function_decod[i][ 2][OPCOD_LV_ADD_H   ] = &(instruction_lv_add_h    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ADDS_B  ]) _function_decod[i][ 2][OPCOD_LV_ADDS_B  ] = &(instruction_lv_adds_b   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ADDS_H  ]) _function_decod[i][ 2][OPCOD_LV_ADDS_H  ] = &(instruction_lv_adds_h   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ADDU_B  ]) _function_decod[i][ 2][OPCOD_LV_ADDU_B  ] = &(instruction_lv_addu_b   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ADDU_H  ]) _function_decod[i][ 2][OPCOD_LV_ADDU_H  ] = &(instruction_lv_addu_h   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ADDUS_B ]) _function_decod[i][ 2][OPCOD_LV_ADDUS_B ] = &(instruction_lv_addus_b  );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ADDUS_H ]) _function_decod[i][ 2][OPCOD_LV_ADDUS_H ] = &(instruction_lv_addus_h  );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ALL_EQ_B]) _function_decod[i][ 2][OPCOD_LV_ALL_EQ_B] = &(instruction_lv_all_eq_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ALL_EQ_H]) _function_decod[i][ 2][OPCOD_LV_ALL_EQ_H] = &(instruction_lv_all_eq_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ALL_GE_B]) _function_decod[i][ 2][OPCOD_LV_ALL_GE_B] = &(instruction_lv_all_ge_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ALL_GE_H]) _function_decod[i][ 2][OPCOD_LV_ALL_GE_H] = &(instruction_lv_all_ge_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ALL_GT_B]) _function_decod[i][ 2][OPCOD_LV_ALL_GT_B] = &(instruction_lv_all_gt_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ALL_GT_H]) _function_decod[i][ 2][OPCOD_LV_ALL_GT_H] = &(instruction_lv_all_gt_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ALL_LE_B]) _function_decod[i][ 2][OPCOD_LV_ALL_LE_B] = &(instruction_lv_all_le_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ALL_LE_H]) _function_decod[i][ 2][OPCOD_LV_ALL_LE_H] = &(instruction_lv_all_le_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ALL_LT_B]) _function_decod[i][ 2][OPCOD_LV_ALL_LT_B] = &(instruction_lv_all_lt_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ALL_LT_H]) _function_decod[i][ 2][OPCOD_LV_ALL_LT_H] = &(instruction_lv_all_lt_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ALL_NE_B]) _function_decod[i][ 2][OPCOD_LV_ALL_NE_B] = &(instruction_lv_all_ne_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ALL_NE_H]) _function_decod[i][ 2][OPCOD_LV_ALL_NE_H] = &(instruction_lv_all_ne_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_AND     ]) _function_decod[i][ 2][OPCOD_LV_AND     ] = &(instruction_lv_and           );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ANY_EQ_B]) _function_decod[i][ 2][OPCOD_LV_ANY_EQ_B] = &(instruction_lv_any_eq_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ANY_EQ_H]) _function_decod[i][ 2][OPCOD_LV_ANY_EQ_H] = &(instruction_lv_any_eq_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ANY_GE_B]) _function_decod[i][ 2][OPCOD_LV_ANY_GE_B] = &(instruction_lv_any_ge_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ANY_GE_H]) _function_decod[i][ 2][OPCOD_LV_ANY_GE_H] = &(instruction_lv_any_ge_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ANY_GT_B]) _function_decod[i][ 2][OPCOD_LV_ANY_GT_B] = &(instruction_lv_any_gt_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ANY_GT_H]) _function_decod[i][ 2][OPCOD_LV_ANY_GT_H] = &(instruction_lv_any_gt_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ANY_LE_B]) _function_decod[i][ 2][OPCOD_LV_ANY_LE_B] = &(instruction_lv_any_le_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ANY_LE_H]) _function_decod[i][ 2][OPCOD_LV_ANY_LE_H] = &(instruction_lv_any_le_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ANY_LT_B]) _function_decod[i][ 2][OPCOD_LV_ANY_LT_B] = &(instruction_lv_any_lt_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ANY_LT_H]) _function_decod[i][ 2][OPCOD_LV_ANY_LT_H] = &(instruction_lv_any_lt_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ANY_NE_B]) _function_decod[i][ 2][OPCOD_LV_ANY_NE_B] = &(instruction_lv_any_ne_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_ANY_NE_H]) _function_decod[i][ 2][OPCOD_LV_ANY_NE_H] = &(instruction_lv_any_ne_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_AVG_B   ]) _function_decod[i][ 2][OPCOD_LV_AVG_B   ] = &(instruction_lv_avg_b    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_AVG_H   ]) _function_decod[i][ 2][OPCOD_LV_AVG_H   ] = &(instruction_lv_avg_h    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CMP_EQ_B]) _function_decod[i][ 2][OPCOD_LV_CMP_EQ_B] = &(instruction_lv_cmp_eq_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CMP_EQ_H]) _function_decod[i][ 2][OPCOD_LV_CMP_EQ_H] = &(instruction_lv_cmp_eq_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CMP_GE_B]) _function_decod[i][ 2][OPCOD_LV_CMP_GE_B] = &(instruction_lv_cmp_ge_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CMP_GE_H]) _function_decod[i][ 2][OPCOD_LV_CMP_GE_H] = &(instruction_lv_cmp_ge_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CMP_GT_B]) _function_decod[i][ 2][OPCOD_LV_CMP_GT_B] = &(instruction_lv_cmp_gt_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CMP_GT_H]) _function_decod[i][ 2][OPCOD_LV_CMP_GT_H] = &(instruction_lv_cmp_gt_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CMP_LE_B]) _function_decod[i][ 2][OPCOD_LV_CMP_LE_B] = &(instruction_lv_cmp_le_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CMP_LE_H]) _function_decod[i][ 2][OPCOD_LV_CMP_LE_H] = &(instruction_lv_cmp_le_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CMP_LT_B]) _function_decod[i][ 2][OPCOD_LV_CMP_LT_B] = &(instruction_lv_cmp_lt_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CMP_LT_H]) _function_decod[i][ 2][OPCOD_LV_CMP_LT_H] = &(instruction_lv_cmp_lt_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CMP_NE_B]) _function_decod[i][ 2][OPCOD_LV_CMP_NE_B] = &(instruction_lv_cmp_ne_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CMP_NE_H]) _function_decod[i][ 2][OPCOD_LV_CMP_NE_H] = &(instruction_lv_cmp_ne_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_MADDS_H ]) _function_decod[i][ 2][OPCOD_LV_MADDS_H ] = &(instruction_lv_madds_h  );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_MAX_B   ]) _function_decod[i][ 2][OPCOD_LV_MAX_B   ] = &(instruction_lv_max_b    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_MAX_H   ]) _function_decod[i][ 2][OPCOD_LV_MAX_H   ] = &(instruction_lv_max_h    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_MERGE_B ]) _function_decod[i][ 2][OPCOD_LV_MERGE_B ] = &(instruction_lv_merge_b  );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_MERGE_H ]) _function_decod[i][ 2][OPCOD_LV_MERGE_H ] = &(instruction_lv_merge_h  );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_MIN_B   ]) _function_decod[i][ 2][OPCOD_LV_MIN_B   ] = &(instruction_lv_min_b    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_MIN_H   ]) _function_decod[i][ 2][OPCOD_LV_MIN_H   ] = &(instruction_lv_min_h    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_MSUBS_H ]) _function_decod[i][ 2][OPCOD_LV_MSUBS_H ] = &(instruction_lv_msubs_h  );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_MULS_H  ]) _function_decod[i][ 2][OPCOD_LV_MULS_H  ] = &(instruction_lv_muls_h   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_NAND    ]) _function_decod[i][ 2][OPCOD_LV_NAND    ] = &(instruction_lv_nand          );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_NOR     ]) _function_decod[i][ 2][OPCOD_LV_NOR     ] = &(instruction_lv_nor           );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_OR      ]) _function_decod[i][ 2][OPCOD_LV_OR      ] = &(instruction_lv_or            );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_PACK_B  ]) _function_decod[i][ 2][OPCOD_LV_PACK_B  ] = &(instruction_lv_pack_b   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_PACK_H  ]) _function_decod[i][ 2][OPCOD_LV_PACK_H  ] = &(instruction_lv_pack_h   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_PACKS_B ]) _function_decod[i][ 2][OPCOD_LV_PACKS_B ] = &(instruction_lv_packs_b  );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_PACKS_H ]) _function_decod[i][ 2][OPCOD_LV_PACKS_H ] = &(instruction_lv_packs_h  );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_PACKUS_B]) _function_decod[i][ 2][OPCOD_LV_PACKUS_B] = &(instruction_lv_packus_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_PACKUS_H]) _function_decod[i][ 2][OPCOD_LV_PACKUS_H] = &(instruction_lv_packus_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_PERM_N  ]) _function_decod[i][ 2][OPCOD_LV_PERM_N  ] = &(instruction_lv_perm_n   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_RL_B    ]) _function_decod[i][ 2][OPCOD_LV_RL_B    ] = &(instruction_lv_rl_b          );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_RL_H    ]) _function_decod[i][ 2][OPCOD_LV_RL_H    ] = &(instruction_lv_rl_h          );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SLL     ]) _function_decod[i][ 2][OPCOD_LV_SLL     ] = &(instruction_lv_sll           );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SLL_B   ]) _function_decod[i][ 2][OPCOD_LV_SLL_B   ] = &(instruction_lv_sll_b    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SLL_H   ]) _function_decod[i][ 2][OPCOD_LV_SLL_H   ] = &(instruction_lv_sll_h    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SRA_B   ]) _function_decod[i][ 2][OPCOD_LV_SRA_B   ] = &(instruction_lv_sra_b    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SRA_H   ]) _function_decod[i][ 2][OPCOD_LV_SRA_H   ] = &(instruction_lv_sra_h    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SRL     ]) _function_decod[i][ 2][OPCOD_LV_SRL     ] = &(instruction_lv_srl           );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SRL_B   ]) _function_decod[i][ 2][OPCOD_LV_SRL_B   ] = &(instruction_lv_srl_b    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SRL_H   ]) _function_decod[i][ 2][OPCOD_LV_SRL_H   ] = &(instruction_lv_srl_h    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SUB_B   ]) _function_decod[i][ 2][OPCOD_LV_SUB_B   ] = &(instruction_lv_sub_b    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SUB_H   ]) _function_decod[i][ 2][OPCOD_LV_SUB_H   ] = &(instruction_lv_sub_h    );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SUBS_B  ]) _function_decod[i][ 2][OPCOD_LV_SUBS_B  ] = &(instruction_lv_subs_b   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SUBS_H  ]) _function_decod[i][ 2][OPCOD_LV_SUBS_H  ] = &(instruction_lv_subs_h   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SUBU_B  ]) _function_decod[i][ 2][OPCOD_LV_SUBU_B  ] = &(instruction_lv_subu_b   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SUBU_H  ]) _function_decod[i][ 2][OPCOD_LV_SUBU_H  ] = &(instruction_lv_subu_h   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SUBUS_B ]) _function_decod[i][ 2][OPCOD_LV_SUBUS_B ] = &(instruction_lv_subus_b  );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_SUBUS_H ]) _function_decod[i][ 2][OPCOD_LV_SUBUS_H ] = &(instruction_lv_subus_h  );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_UNPACK_B]) _function_decod[i][ 2][OPCOD_LV_UNPACK_B] = &(instruction_lv_unpack_b );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_UNPACK_H]) _function_decod[i][ 2][OPCOD_LV_UNPACK_H] = &(instruction_lv_unpack_h );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_XOR     ]) _function_decod[i][ 2][OPCOD_LV_XOR     ] = &(instruction_lv_xor      );

        // Custom Instruction
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST1    ]) _function_decod [i][ 0][OPCOD_L_CUST1    ] = &(instruction_l_custom );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST2    ]) _function_decod [i][ 0][OPCOD_L_CUST2    ] = &(instruction_l_custom );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST3    ]) _function_decod [i][ 0][OPCOD_L_CUST3    ] = &(instruction_l_custom );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST4    ]) _function_decod [i][ 0][OPCOD_L_CUST4    ] = &(instruction_l_custom );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST5    ]) _function_decod [i][ 0][OPCOD_L_CUST5    ] = &(instruction_l_custom );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST6    ]) _function_decod [i][ 0][OPCOD_L_CUST6    ] = &(instruction_l_custom );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST7    ]) _function_decod [i][ 0][OPCOD_L_CUST7    ] = &(instruction_l_custom );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST8    ]) _function_decod [i][ 0][OPCOD_L_CUST8    ] = &(instruction_l_custom );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_CUST1_D ]) _function_decod [i][ 1][OPCOD_LF_CUST1_D ] = &(instruction_lf_custom);
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_CUST1_S ]) _function_decod [i][ 1][OPCOD_LF_CUST1_S ] = &(instruction_lf_custom);
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CUST1   ]) _function_decod [i][ 2][OPCOD_LV_CUST1   ] = &(instruction_lv_custom);
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CUST2   ]) _function_decod [i][ 2][OPCOD_LV_CUST2   ] = &(instruction_lv_custom);
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CUST3   ]) _function_decod [i][ 2][OPCOD_LV_CUST3   ] = &(instruction_lv_custom);
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CUST4   ]) _function_decod [i][ 2][OPCOD_LV_CUST4   ] = &(instruction_lv_custom);

        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST1    ]) _function_custom[i][ 0][OPCOD_L_CUST1    ] = _param->_get_custom_information()._get_custom_decod(OPERATION_CUSTOM_L_1   );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST2    ]) _function_custom[i][ 0][OPCOD_L_CUST2    ] = _param->_get_custom_information()._get_custom_decod(OPERATION_CUSTOM_L_2   );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST3    ]) _function_custom[i][ 0][OPCOD_L_CUST3    ] = _param->_get_custom_information()._get_custom_decod(OPERATION_CUSTOM_L_3   );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST4    ]) _function_custom[i][ 0][OPCOD_L_CUST4    ] = _param->_get_custom_information()._get_custom_decod(OPERATION_CUSTOM_L_4   );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST5    ]) _function_custom[i][ 0][OPCOD_L_CUST5    ] = _param->_get_custom_information()._get_custom_decod(OPERATION_CUSTOM_L_5   );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST6    ]) _function_custom[i][ 0][OPCOD_L_CUST6    ] = _param->_get_custom_information()._get_custom_decod(OPERATION_CUSTOM_L_6   );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST7    ]) _function_custom[i][ 0][OPCOD_L_CUST7    ] = _param->_get_custom_information()._get_custom_decod(OPERATION_CUSTOM_L_7   );
        if (_param->_instruction_implemeted[i][INSTRUCTION_L_CUST8    ]) _function_custom[i][ 0][OPCOD_L_CUST8    ] = _param->_get_custom_information()._get_custom_decod(OPERATION_CUSTOM_L_8   );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_CUST1_D ]) _function_custom[i][ 1][OPCOD_LF_CUST1_D ] = _param->_get_custom_information()._get_custom_decod(OPERATION_CUSTOM_LF_1_D);
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LF_CUST1_S ]) _function_custom[i][ 1][OPCOD_LF_CUST1_S ] = _param->_get_custom_information()._get_custom_decod(OPERATION_CUSTOM_LF_1_S);
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CUST1   ]) _function_custom[i][ 2][OPCOD_LV_CUST1   ] = _param->_get_custom_information()._get_custom_decod(OPERATION_CUSTOM_LV_1  );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CUST2   ]) _function_custom[i][ 2][OPCOD_LV_CUST2   ] = _param->_get_custom_information()._get_custom_decod(OPERATION_CUSTOM_LV_2  );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CUST3   ]) _function_custom[i][ 2][OPCOD_LV_CUST3   ] = _param->_get_custom_information()._get_custom_decod(OPERATION_CUSTOM_LV_3  );
//      if (_param->_instruction_implemeted[i][INSTRUCTION_LV_CUST4   ]) _function_custom[i][ 2][OPCOD_LV_CUST4   ] = _param->_get_custom_information()._get_custom_decod(OPERATION_CUSTOM_LV_4  );
      }

    _decod_instruction = new decod_instruction_t;

    _decod_param = new decod_param_t * [_param->_nb_context];
    for (uint32_t i=0; i<_param->_nb_context; i++)
      _decod_param [i] = new decod_param_t (_param->_size_general_data,
                                            _function_decod [i],
                                            _function_custom[i]);

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_printf(FUNC,Decod,FUNCTION,"End");
  };

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
