/*
 * $Id: test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/OOO_Engine_Glue/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::ooo_engine_glue::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  OOO_Engine_Glue * _OOO_Engine_Glue = new OOO_Engine_Glue 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC2_SC_SIGNAL( in_RENAME_FRONT_END_ID                     ," in_RENAME_FRONT_END_ID                     ",Tcontext_t         ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);                               
  ALLOC2_SC_SIGNAL(out_RENAME_RENAME_UNIT_FRONT_END_ID         ,"out_RENAME_RENAME_UNIT_FRONT_END_ID         ",Tcontext_t         ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);                               

  ALLOC1_SC_SIGNAL(out_INSERT_VAL                              ,"out_INSERT_VAL                              ",Tcontrol_t         ,_param->_sum_inst_insert);                                                        
  ALLOC1_SC_SIGNAL( in_INSERT_ACK                              ," in_INSERT_ACK                              ",Tcontrol_t         ,_param->_sum_inst_insert);                                                        
  ALLOC1_SC_SIGNAL(out_INSERT_RD_USE                           ,"out_INSERT_RD_USE                           ",Tcontrol_t         ,_param->_sum_inst_insert);                                                        
  ALLOC1_SC_SIGNAL(out_INSERT_RD_NUM_REG                       ,"out_INSERT_RD_NUM_REG                       ",Tgeneral_address_t ,_param->_sum_inst_insert);                                                        
  ALLOC1_SC_SIGNAL(out_INSERT_RE_USE                           ,"out_INSERT_RE_USE                           ",Tcontrol_t         ,_param->_sum_inst_insert);                                                        
  ALLOC1_SC_SIGNAL(out_INSERT_RE_NUM_REG                       ,"out_INSERT_RE_NUM_REG                       ",Tspecial_address_t ,_param->_sum_inst_insert);                                                        

  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_VAL                  ," in_INSERT_RENAME_UNIT_VAL                  ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_RENAME_UNIT_ACK                  ,"out_INSERT_RENAME_UNIT_ACK                  ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_FRONT_END_ID         ," in_INSERT_RENAME_UNIT_FRONT_END_ID         ",Tcontext_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_CONTEXT_ID           ," in_INSERT_RENAME_UNIT_CONTEXT_ID           ",Tcontext_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_TYPE                 ," in_INSERT_RENAME_UNIT_TYPE                 ",Ttype_t            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_OPERATION            ," in_INSERT_RENAME_UNIT_OPERATION            ",Toperation_t       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NO_EXECUTE           ," in_INSERT_RENAME_UNIT_NO_EXECUTE           ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_HAS_IMMEDIAT         ," in_INSERT_RENAME_UNIT_HAS_IMMEDIAT         ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_IMMEDIAT             ," in_INSERT_RENAME_UNIT_IMMEDIAT             ",Tgeneral_data_t    ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_STORE_QUEUE_PTR_WRITE," in_INSERT_RENAME_UNIT_STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_LOAD_QUEUE_PTR_WRITE ," in_INSERT_RENAME_UNIT_LOAD_QUEUE_PTR_WRITE ",Tlsq_ptr_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_READ_RA              ," in_INSERT_RENAME_UNIT_READ_RA              ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NUM_REG_RA_PHY       ," in_INSERT_RENAME_UNIT_NUM_REG_RA_PHY       ",Tgeneral_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_READ_RB              ," in_INSERT_RENAME_UNIT_READ_RB              ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NUM_REG_RB_PHY       ," in_INSERT_RENAME_UNIT_NUM_REG_RB_PHY       ",Tgeneral_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_READ_RC              ," in_INSERT_RENAME_UNIT_READ_RC              ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NUM_REG_RC_PHY       ," in_INSERT_RENAME_UNIT_NUM_REG_RC_PHY       ",Tspecial_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_WRITE_RD             ," in_INSERT_RENAME_UNIT_WRITE_RD             ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_OLD   ," in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_OLD   ",Tgeneral_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_NEW   ," in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_NEW   ",Tgeneral_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_WRITE_RE             ," in_INSERT_RENAME_UNIT_WRITE_RE             ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_OLD   ," in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_OLD   ",Tspecial_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_NEW   ," in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_NEW   ",Tspecial_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            

  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_VAL                  ,"out_INSERT_COMMIT_UNIT_VAL                  ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_COMMIT_UNIT_ACK                  ," in_INSERT_COMMIT_UNIT_ACK                  ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_FRONT_END_ID         ,"out_INSERT_COMMIT_UNIT_FRONT_END_ID         ",Tcontext_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_CONTEXT_ID           ,"out_INSERT_COMMIT_UNIT_CONTEXT_ID           ",Tcontext_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
//ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_RENAME_UNIT_ID       ,"out_INSERT_COMMIT_UNIT_RENAME_UNIT_ID       ",Tcontext_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_TYPE                 ,"out_INSERT_COMMIT_UNIT_TYPE                 ",Ttype_t            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_OPERATION            ,"out_INSERT_COMMIT_UNIT_OPERATION            ",Toperation_t       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NO_EXECUTE           ,"out_INSERT_COMMIT_UNIT_NO_EXECUTE           ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_STORE_QUEUE_PTR_WRITE,"out_INSERT_COMMIT_UNIT_STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_LOAD_QUEUE_PTR_WRITE ,"out_INSERT_COMMIT_UNIT_LOAD_QUEUE_PTR_WRITE ",Tlsq_ptr_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_READ_RA              ,"out_INSERT_COMMIT_UNIT_READ_RA              ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NUM_REG_RA_PHY       ,"out_INSERT_COMMIT_UNIT_NUM_REG_RA_PHY       ",Tgeneral_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_READ_RB              ,"out_INSERT_COMMIT_UNIT_READ_RB              ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NUM_REG_RB_PHY       ,"out_INSERT_COMMIT_UNIT_NUM_REG_RB_PHY       ",Tgeneral_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_READ_RC              ,"out_INSERT_COMMIT_UNIT_READ_RC              ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NUM_REG_RC_PHY       ,"out_INSERT_COMMIT_UNIT_NUM_REG_RC_PHY       ",Tspecial_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_WRITE_RD             ,"out_INSERT_COMMIT_UNIT_WRITE_RD             ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_OLD   ,"out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_OLD   ",Tgeneral_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_NEW   ,"out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_NEW   ",Tgeneral_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_WRITE_RE             ,"out_INSERT_COMMIT_UNIT_WRITE_RE             ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_OLD   ,"out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_OLD   ",Tspecial_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_NEW   ,"out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_NEW   ",Tspecial_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            

  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_VAL                  ,"out_INSERT_ISSUE_QUEUE_VAL                  ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL( in_INSERT_ISSUE_QUEUE_ACK                  ," in_INSERT_ISSUE_QUEUE_ACK                  ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_CONTEXT_ID           ,"out_INSERT_ISSUE_QUEUE_CONTEXT_ID           ",Tcontext_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_FRONT_END_ID         ,"out_INSERT_ISSUE_QUEUE_FRONT_END_ID         ",Tcontext_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_OPERATION            ,"out_INSERT_ISSUE_QUEUE_OPERATION            ",Toperation_t       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_TYPE                 ,"out_INSERT_ISSUE_QUEUE_TYPE                 ",Ttype_t            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_STORE_QUEUE_PTR_WRITE,"out_INSERT_ISSUE_QUEUE_STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_LOAD_QUEUE_PTR_WRITE ,"out_INSERT_ISSUE_QUEUE_LOAD_QUEUE_PTR_WRITE ",Tlsq_ptr_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_HAS_IMMEDIAT         ,"out_INSERT_ISSUE_QUEUE_HAS_IMMEDIAT         ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_IMMEDIAT             ,"out_INSERT_ISSUE_QUEUE_IMMEDIAT             ",Tgeneral_data_t    ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_READ_RA              ,"out_INSERT_ISSUE_QUEUE_READ_RA              ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_NUM_REG_RA           ,"out_INSERT_ISSUE_QUEUE_NUM_REG_RA           ",Tgeneral_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_READ_RB              ,"out_INSERT_ISSUE_QUEUE_READ_RB              ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_NUM_REG_RB           ,"out_INSERT_ISSUE_QUEUE_NUM_REG_RB           ",Tgeneral_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_READ_RC              ,"out_INSERT_ISSUE_QUEUE_READ_RC              ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_NUM_REG_RC           ,"out_INSERT_ISSUE_QUEUE_NUM_REG_RC           ",Tspecial_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_WRITE_RD             ,"out_INSERT_ISSUE_QUEUE_WRITE_RD             ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_NUM_REG_RD           ,"out_INSERT_ISSUE_QUEUE_NUM_REG_RD           ",Tgeneral_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_WRITE_RE             ,"out_INSERT_ISSUE_QUEUE_WRITE_RE             ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            
  ALLOC2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_NUM_REG_RE           ,"out_INSERT_ISSUE_QUEUE_NUM_REG_RE           ",Tspecial_address_t ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);                            

//   ALLOC1_SC_SIGNAL(out_RETIRE_VAL                              ,"out_RETIRE_VAL                              ",Tcontrol_t         ,_param->_sum_inst_retire);                                                        
//   ALLOC1_SC_SIGNAL( in_RETIRE_ACK                              ," in_RETIRE_ACK                              ",Tcontrol_t         ,_param->_sum_inst_retire);                                                        
//   ALLOC1_SC_SIGNAL(out_RETIRE_RD_OLD_USE                       ,"out_RETIRE_RD_OLD_USE                       ",Tcontrol_t         ,_param->_sum_inst_retire);                                                        
//   ALLOC1_SC_SIGNAL(out_RETIRE_RD_OLD_NUM_REG                   ,"out_RETIRE_RD_OLD_NUM_REG                   ",Tgeneral_address_t ,_param->_sum_inst_retire);                                                        
//   ALLOC1_SC_SIGNAL(out_RETIRE_RD_NEW_USE                       ,"out_RETIRE_RD_NEW_USE                       ",Tcontrol_t         ,_param->_sum_inst_retire);                                                        
//   ALLOC1_SC_SIGNAL(out_RETIRE_RD_NEW_NUM_REG                   ,"out_RETIRE_RD_NEW_NUM_REG                   ",Tgeneral_address_t ,_param->_sum_inst_retire);                                                        
//   ALLOC1_SC_SIGNAL(out_RETIRE_RE_OLD_USE                       ,"out_RETIRE_RE_OLD_USE                       ",Tcontrol_t         ,_param->_sum_inst_retire);                                                        
//   ALLOC1_SC_SIGNAL(out_RETIRE_RE_OLD_NUM_REG                   ,"out_RETIRE_RE_OLD_NUM_REG                   ",Tspecial_address_t ,_param->_sum_inst_retire);                                                        
//   ALLOC1_SC_SIGNAL(out_RETIRE_RE_NEW_USE                       ,"out_RETIRE_RE_NEW_USE                       ",Tcontrol_t         ,_param->_sum_inst_retire);                                                        
//   ALLOC1_SC_SIGNAL(out_RETIRE_RE_NEW_NUM_REG                   ,"out_RETIRE_RE_NEW_NUM_REG                   ",Tspecial_address_t ,_param->_sum_inst_retire);                                                        

//   ALLOC2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_VAL                  ,"out_RETIRE_RENAME_UNIT_VAL                  ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL( in_RETIRE_RENAME_UNIT_ACK                  ," in_RETIRE_RENAME_UNIT_ACK                  ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_FRONT_END_ID         ,"out_RETIRE_RENAME_UNIT_FRONT_END_ID         ",Tcontext_t         ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_WRITE_RD             ,"out_RETIRE_RENAME_UNIT_WRITE_RD             ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_NUM_REG_RD_PHY_OLD   ,"out_RETIRE_RENAME_UNIT_NUM_REG_RD_PHY_OLD   ",Tgeneral_address_t ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_NUM_REG_RD_PHY_NEW   ,"out_RETIRE_RENAME_UNIT_NUM_REG_RD_PHY_NEW   ",Tgeneral_address_t ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_WRITE_RE             ,"out_RETIRE_RENAME_UNIT_WRITE_RE             ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_NUM_REG_RE_PHY_OLD   ,"out_RETIRE_RENAME_UNIT_NUM_REG_RE_PHY_OLD   ",Tspecial_address_t ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_NUM_REG_RE_PHY_NEW   ,"out_RETIRE_RENAME_UNIT_NUM_REG_RE_PHY_NEW   ",Tspecial_address_t ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_EVENT_STATE          ,"out_RETIRE_RENAME_UNIT_EVENT_STATE          ",Tevent_state_t     ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            

//   ALLOC2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_VAL                  ," in_RETIRE_COMMIT_UNIT_VAL                  ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL(out_RETIRE_COMMIT_UNIT_ACK                  ,"out_RETIRE_COMMIT_UNIT_ACK                  ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_FRONT_END_ID         ," in_RETIRE_COMMIT_UNIT_FRONT_END_ID         ",Tcontext_t         ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_WRITE_RD             ," in_RETIRE_COMMIT_UNIT_WRITE_RD             ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_NUM_REG_RD_PHY_OLD   ," in_RETIRE_COMMIT_UNIT_NUM_REG_RD_PHY_OLD   ",Tgeneral_address_t ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_NUM_REG_RD_PHY_NEW   ," in_RETIRE_COMMIT_UNIT_NUM_REG_RD_PHY_NEW   ",Tgeneral_address_t ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_WRITE_RE             ," in_RETIRE_COMMIT_UNIT_WRITE_RE             ",Tcontrol_t         ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_NUM_REG_RE_PHY_OLD   ," in_RETIRE_COMMIT_UNIT_NUM_REG_RE_PHY_OLD   ",Tspecial_address_t ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_NUM_REG_RE_PHY_NEW   ," in_RETIRE_COMMIT_UNIT_NUM_REG_RE_PHY_NEW   ",Tspecial_address_t ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            
//   ALLOC2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_EVENT_STATE          ," in_RETIRE_COMMIT_UNIT_EVENT_STATE          ",Tevent_state_t     ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);                            

  ALLOC2_SC_SIGNAL(out_SPR_SR_IEE                              ,"out_SPR_SR_IEE                              ",Tcontrol_t         ,_param->_nb_front_end,_param->_nb_context[it1]);                                  
  ALLOC2_SC_SIGNAL(out_SPR_SR_EPH                              ,"out_SPR_SR_EPH                              ",Tcontrol_t         ,_param->_nb_front_end,_param->_nb_context[it1]);                                  
  ALLOC2_SC_SIGNAL(out_SPR_RENAME_UNIT_SR                      ,"out_SPR_RENAME_UNIT_SR                      ",Tspr_t             ,_param->_nb_front_end,_param->_nb_context[it1]);                                  
  ALLOC2_SC_SIGNAL(out_SPR_COMMIT_UNIT_SR_OVE                  ,"out_SPR_COMMIT_UNIT_SR_OVE                  ",Tcontrol_t         ,_param->_nb_front_end,_param->_nb_context[it1]);                                  
  ALLOC2_SC_SIGNAL( in_SPR_SPECIAL_REGISTER_UNIT_SR            ," in_SPR_SPECIAL_REGISTER_UNIT_SR            ",Tspr_t             ,_param->_nb_front_end,_param->_nb_context[it1]);                                  

  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _OOO_Engine_Glue.\n"),name.c_str());

  (*(_OOO_Engine_Glue->in_CLOCK))        (*(in_CLOCK));
  (*(_OOO_Engine_Glue->in_NRESET))       (*(in_NRESET));

  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_RENAME_FRONT_END_ID                          ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_RENAME_RENAME_UNIT_FRONT_END_ID              ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);

  INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_VAL                                   ,_param->_sum_inst_insert);
  INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_ACK                                   ,_param->_sum_inst_insert);
  INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_RD_USE                                ,_param->_sum_inst_insert);
  INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_RD_NUM_REG                            ,_param->_sum_inst_insert);
  INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_RE_USE                                ,_param->_sum_inst_insert);
  INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_RE_NUM_REG                            ,_param->_sum_inst_insert);

  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_VAL                       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_RENAME_UNIT_ACK                       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_FRONT_END_ID              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_CONTEXT_ID                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_TYPE                      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_OPERATION                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_NO_EXECUTE                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_HAS_IMMEDIAT              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_IMMEDIAT                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_STORE_QUEUE_PTR_WRITE     ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_LOAD_QUEUE_PTR_WRITE      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_READ_RA                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_NUM_REG_RA_PHY            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_READ_RB                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_NUM_REG_RB_PHY            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_READ_RC                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_NUM_REG_RC_PHY            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_WRITE_RD                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_WRITE_RE                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);

  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_VAL                       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_COMMIT_UNIT_ACK                       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_FRONT_END_ID              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_CONTEXT_ID                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
//INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_RENAME_UNIT_ID            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_TYPE                      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_OPERATION                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_NO_EXECUTE                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_STORE_QUEUE_PTR_WRITE     ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_LOAD_QUEUE_PTR_WRITE      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_READ_RA                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_NUM_REG_RA_PHY            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_READ_RB                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_NUM_REG_RB_PHY            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_READ_RC                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_NUM_REG_RC_PHY            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_WRITE_RD                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_WRITE_RE                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);

  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_VAL                       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_INSERT_ISSUE_QUEUE_ACK                       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_FRONT_END_ID              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_CONTEXT_ID                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_OPERATION                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_TYPE                      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_STORE_QUEUE_PTR_WRITE     ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_LOAD_QUEUE_PTR_WRITE      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_HAS_IMMEDIAT              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_IMMEDIAT                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_READ_RA                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_NUM_REG_RA                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_READ_RB                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_NUM_REG_RB                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_READ_RC                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_NUM_REG_RC                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_WRITE_RD                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_NUM_REG_RD                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_WRITE_RE                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_INSERT_ISSUE_QUEUE_NUM_REG_RE                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);

//   INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_VAL                                   ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue, in_RETIRE_ACK                                   ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RD_OLD_USE                            ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RD_OLD_NUM_REG                        ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RD_NEW_USE                            ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RD_NEW_NUM_REG                        ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RE_OLD_USE                            ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RE_OLD_NUM_REG                        ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RE_NEW_USE                            ,_param->_sum_inst_retire);
//   INSTANCE1_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RE_NEW_NUM_REG                        ,_param->_sum_inst_retire);

//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RENAME_UNIT_VAL                       ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_RETIRE_RENAME_UNIT_ACK                       ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   if (_param->_have_port_front_end_id)
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RENAME_UNIT_FRONT_END_ID              ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RENAME_UNIT_WRITE_RD                  ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RENAME_UNIT_NUM_REG_RD_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RENAME_UNIT_NUM_REG_RD_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RENAME_UNIT_WRITE_RE                  ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RENAME_UNIT_NUM_REG_RE_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RENAME_UNIT_NUM_REG_RE_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_RENAME_UNIT_EVENT_STATE               ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);

//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_RETIRE_COMMIT_UNIT_VAL                       ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_RETIRE_COMMIT_UNIT_ACK                       ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   if (_param->_have_port_front_end_id)
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_RETIRE_COMMIT_UNIT_FRONT_END_ID              ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_RETIRE_COMMIT_UNIT_WRITE_RD                  ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_RETIRE_COMMIT_UNIT_NUM_REG_RD_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_RETIRE_COMMIT_UNIT_NUM_REG_RD_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_RETIRE_COMMIT_UNIT_WRITE_RE                  ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_RETIRE_COMMIT_UNIT_NUM_REG_RE_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_RETIRE_COMMIT_UNIT_NUM_REG_RE_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_RETIRE_COMMIT_UNIT_EVENT_STATE               ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);

  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_SPR_SR_IEE                                   ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_SPR_SR_EPH                                   ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_SPR_RENAME_UNIT_SR                           ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue,out_SPR_COMMIT_UNIT_SR_OVE                       ,_param->_nb_front_end,_param->_nb_context[it1]);
  INSTANCE2_SC_SIGNAL(_OOO_Engine_Glue, in_SPR_SPECIAL_REGISTER_UNIT_SR                 ,_param->_nb_front_end,_param->_nb_context[it1]);                                  

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

//       // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//       for (uint32_t i=0; i<_param->_nb_rename_unit; ++i)
//         for (uint32_t j=0; j<_param->_nb_inst_retire[i]; ++j)
//           {
            
//           }

      // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_front_end; ++i)
        for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
          {
            in_SPR_SPECIAL_REGISTER_UNIT_SR [i][j]->write(rand());
          }

      SC_START(0);

      // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_front_end; ++i)
        for (uint32_t j=0; j<_param->_nb_context[i]; ++j)
          {
            Tspr_t sr = in_SPR_SPECIAL_REGISTER_UNIT_SR [i][j]->read();

            TEST(Tspr_t    ,out_SPR_RENAME_UNIT_SR     [i][j]->read(),((sr|(1<<15))&0xf001ffff)); // with FO, and without reserved
            TEST(Tcontrol_t,out_SPR_SR_IEE             [i][j]->read(),(sr>> 2)&1);
            TEST(Tcontrol_t,out_SPR_SR_EPH             [i][j]->read(),(sr>>14)&1);
            TEST(Tcontrol_t,out_SPR_COMMIT_UNIT_SR_OVE [i][j]->read(),(sr>>12)&1);
          }
      
      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE2_SC_SIGNAL( in_RENAME_FRONT_END_ID                          ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
  DELETE2_SC_SIGNAL(out_RENAME_RENAME_UNIT_FRONT_END_ID              ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);

  DELETE1_SC_SIGNAL(out_INSERT_VAL                                   ,_param->_sum_inst_insert);
  DELETE1_SC_SIGNAL( in_INSERT_ACK                                   ,_param->_sum_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RD_USE                                ,_param->_sum_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RD_NUM_REG                            ,_param->_sum_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RE_USE                                ,_param->_sum_inst_insert);
  DELETE1_SC_SIGNAL(out_INSERT_RE_NUM_REG                            ,_param->_sum_inst_insert);

  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_VAL                       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_RENAME_UNIT_ACK                       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_FRONT_END_ID              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_CONTEXT_ID                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_TYPE                      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_OPERATION                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NO_EXECUTE                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_HAS_IMMEDIAT              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_IMMEDIAT                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_STORE_QUEUE_PTR_WRITE     ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_LOAD_QUEUE_PTR_WRITE      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_READ_RA                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NUM_REG_RA_PHY            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_READ_RB                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NUM_REG_RB_PHY            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_READ_RC                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NUM_REG_RC_PHY            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_WRITE_RD                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_WRITE_RE                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);

  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_VAL                       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_COMMIT_UNIT_ACK                       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_FRONT_END_ID              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_CONTEXT_ID                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
//DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_RENAME_UNIT_ID            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_TYPE                      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_OPERATION                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NO_EXECUTE                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_STORE_QUEUE_PTR_WRITE     ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_LOAD_QUEUE_PTR_WRITE      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_READ_RA                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NUM_REG_RA_PHY            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_READ_RB                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NUM_REG_RB_PHY            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_READ_RC                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NUM_REG_RC_PHY            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_WRITE_RD                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_WRITE_RE                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);

  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_VAL                       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL( in_INSERT_ISSUE_QUEUE_ACK                       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_FRONT_END_ID              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_CONTEXT_ID                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_OPERATION                 ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_TYPE                      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_STORE_QUEUE_PTR_WRITE     ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_LOAD_QUEUE_PTR_WRITE      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_HAS_IMMEDIAT              ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_IMMEDIAT                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_READ_RA                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_NUM_REG_RA                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_READ_RB                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_NUM_REG_RB                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_READ_RC                   ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_NUM_REG_RC                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_WRITE_RD                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_NUM_REG_RD                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_WRITE_RE                  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
  DELETE2_SC_SIGNAL(out_INSERT_ISSUE_QUEUE_NUM_REG_RE                ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);

//   DELETE1_SC_SIGNAL(out_RETIRE_VAL                                   ,_param->_sum_inst_retire);
//   DELETE1_SC_SIGNAL( in_RETIRE_ACK                                   ,_param->_sum_inst_retire);
//   DELETE1_SC_SIGNAL(out_RETIRE_RD_OLD_USE                            ,_param->_sum_inst_retire);
//   DELETE1_SC_SIGNAL(out_RETIRE_RD_OLD_NUM_REG                        ,_param->_sum_inst_retire);
//   DELETE1_SC_SIGNAL(out_RETIRE_RD_NEW_USE                            ,_param->_sum_inst_retire);
//   DELETE1_SC_SIGNAL(out_RETIRE_RD_NEW_NUM_REG                        ,_param->_sum_inst_retire);
//   DELETE1_SC_SIGNAL(out_RETIRE_RE_OLD_USE                            ,_param->_sum_inst_retire);
//   DELETE1_SC_SIGNAL(out_RETIRE_RE_OLD_NUM_REG                        ,_param->_sum_inst_retire);
//   DELETE1_SC_SIGNAL(out_RETIRE_RE_NEW_USE                            ,_param->_sum_inst_retire);
//   DELETE1_SC_SIGNAL(out_RETIRE_RE_NEW_NUM_REG                        ,_param->_sum_inst_retire);

//   DELETE2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_VAL                       ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_RENAME_UNIT_ACK                       ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_FRONT_END_ID              ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_WRITE_RD                  ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_NUM_REG_RD_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_NUM_REG_RD_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_WRITE_RE                  ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_NUM_REG_RE_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_NUM_REG_RE_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL(out_RETIRE_RENAME_UNIT_EVENT_STATE               ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);

//   DELETE2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_VAL                       ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL(out_RETIRE_COMMIT_UNIT_ACK                       ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_FRONT_END_ID              ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_WRITE_RD                  ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_NUM_REG_RD_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_NUM_REG_RD_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_WRITE_RE                  ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_NUM_REG_RE_PHY_OLD        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_NUM_REG_RE_PHY_NEW        ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//   DELETE2_SC_SIGNAL( in_RETIRE_COMMIT_UNIT_EVENT_STATE               ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);

  DELETE2_SC_SIGNAL(out_SPR_SR_IEE                                   ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_SPR_SR_EPH                                   ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_SPR_RENAME_UNIT_SR                           ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL(out_SPR_COMMIT_UNIT_SR_OVE                       ,_param->_nb_front_end,_param->_nb_context[it1]);
  DELETE2_SC_SIGNAL( in_SPR_SPECIAL_REGISTER_UNIT_SR                 ,_param->_nb_front_end,_param->_nb_context[it1]);
    }
#endif

  delete _OOO_Engine_Glue;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
