/*
 * $Id: Parameters_msg_error.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Free_List_unit/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace free_list_unit {


#undef  FUNCTION
#define FUNCTION "Free_List_unit::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_printf(FUNC,Free_List_unit,FUNCTION,"Begin");

    Parameters_test test ("Free_List_unit");

    if (_nb_general_register <= _nb_thread*_nb_general_register_logic)
      test.error(toString(_("The number of physical general register is insufficient. (Minimum : %d)\n"),_nb_thread*_nb_general_register_logic+1));
    if (_nb_special_register <= _nb_thread*_nb_special_register_logic)
      test.error(toString(_("The number of physical special register is insufficient. (Minimum : %d)\n"),_nb_thread*_nb_special_register_logic+1));
    if (not is_multiple (_nb_bank, _nb_pop))
      test.error(_("Number of pop must be a multiple of number of bank.\n"));
    if (not is_power2 (_nb_bank))
      test.error(_("Number of bank must be a power of 2.\n"));
    if (_nb_general_register < _nb_bank)
      test.error(_("The number of physical general register must be >= nb_bank.\n"));
    if (_nb_special_register < _nb_bank)
      test.error(_("The number of physical special register must be >= nb_bank.\n"));

    if ((_priority != PRIORITY_STATIC) and
	(_priority != PRIORITY_ROUND_ROBIN))
      test.error(toString(_("Unsupported priority scheme. Supported scheme are %s and %s.\n"),toString(PRIORITY_STATIC).c_str(),toString(PRIORITY_ROUND_ROBIN).c_str()));

    return test;

    log_printf(FUNC,Free_List_unit,FUNCTION,"End");
  };

}; // end namespace free_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
