#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile_Multi_Banked/include/RegisterFile_Multi_Banked.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile_multi_banked {

#ifdef VHDL_TESTBENCH
# define VHDL_SET_PORT(name,direction,size) vhdl.set_port (name,direction,size); _vhdl_testbench->set_port (name,direction,size);
#else
# define VHDL_SET_PORT(name,direction,size) vhdl.set_port (name,direction,size);
#endif

  void RegisterFile_Multi_Banked::vhdl_port (Vhdl & vhdl)
  {
    log_printf(FUNC,RegisterFile_Multi_Banked,"vhdl_port","Begin");

    vhdl.set_port (" in_CLOCK" , IN, 1);
    VHDL_SET_PORT (" in_NRESET", IN, 1);

    // ----- Interface Read
    for (uint32_t i=0; i<_param._nb_port_read; i++)
      {
	VHDL_SET_PORT(" in_READ_VAL_"+toString(i)+"     ", IN, 1);
	VHDL_SET_PORT("out_READ_ACK_"+toString(i)+"     ",OUT, 1);
	VHDL_SET_PORT(" in_READ_ADDRESS_"+toString(i)+" ", IN, static_cast<uint32_t>(log2(_param._nb_word)));
	VHDL_SET_PORT("out_READ_DATA_"+toString(i)+"    ",OUT, _param._size_word);
      }

    // ----- Interface Write
    for (uint32_t i=0; i<_param._nb_port_write; i++)
      {
	VHDL_SET_PORT(" in_WRITE_VAL_"+toString(i)+"    ", IN, 1);
	VHDL_SET_PORT("out_WRITE_ACK_"+toString(i)+"    ",OUT, 1);
	VHDL_SET_PORT(" in_WRITE_ADDRESS_"+toString(i)+"", IN, static_cast<uint32_t>(log2(_param._nb_word)));
	VHDL_SET_PORT(" in_WRITE_DATA_"+toString(i)+"   ", IN, _param._size_word);			     
      }
    
    log_printf(FUNC,RegisterFile_Multi_Banked,"vhdl_port","End");
  };

}; // end namespace registerfile_multi_banked
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
