/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Pattern_History_Table/include/Pattern_History_Table.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {
namespace pattern_history_table {


#ifdef SYSTEMC
  Pattern_History_Table::Pattern_History_Table (sc_module_name name,
#else
  Pattern_History_Table::Pattern_History_Table (string name,
#endif
#ifdef STATISTICS
			      morpheo::behavioural::Parameters_Statistics             param_statistics,
#endif
			      morpheo::behavioural::stage_1_ifetch::predictor::meta_predictor::two_level_branch_predictor::pattern_history_table::Parameters param ):
			      _name              (name)
			      ,_param            (param)
#ifdef STATISTICS
			      ,_param_statistics (param_statistics)
#endif
  {
    log_printf(FUNC,Pattern_History_Table,"Pattern_History_Table","Begin");
    
#ifdef STATISTICS
    // Allocation of statistics
    _stat = new Statistics (static_cast<string>(_name),
			    param_statistics          ,
			    param);
#endif

#ifdef VHDL_TESTBENCH
    // Creation of a testbench
    //  -> port
    //  -> clock's signals
    _vhdl_testbench = new Vhdl_Testbench (_name);
    vhdl_testbench_port           ();
    _vhdl_testbench->set_clock    ("in_CLOCK",true);
#endif

#ifdef VHDL
    // generate the vhdl
    vhdl();
#endif

#ifdef SYSTEMC
    allocation ();

    // Constant
    for (uint32_t i=0; i<_param._nb_prediction     ; i++)
      PORT_WRITE(out_PREDICT_ACK         [i],1);
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      PORT_WRITE(out_BRANCH_COMPLETE_ACK [i],1);

#if (defined(STATISTICS) || defined (VHDL_TESTBENCH))
    SC_METHOD (transition);
    dont_initialize ();
    sensitive_pos << *(in_CLOCK);
#endif

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
#endif    

#endif
    log_printf(FUNC,Pattern_History_Table,"Pattern_History_Table","End");
  };
  
  Pattern_History_Table::~Pattern_History_Table (void)
  {
    log_printf(FUNC,Pattern_History_Table,"~Pattern_History_Table","Begin");

#ifdef VHDL_TESTBENCH
    // generate the test bench
    _vhdl_testbench->generate_file();
    delete _vhdl_testbench;
#endif

#ifdef STATISTICS
    _stat->generate_file(statistics(0));
    
    delete _stat;
#endif

#ifdef SYSTEMC
    deallocation ();
#endif

    log_printf(FUNC,Pattern_History_Table,"~Pattern_History_Table","End");
  };

}; // end namespace pattern_history_table
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
