#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Pattern_History_Table/include/Pattern_History_Table.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {
namespace pattern_history_table {


  void Pattern_History_Table::vhdl_testbench_transition ()
  {
    log_printf(FUNC,Pattern_History_Table,"vhdl_testbench_transition","Begin");

#ifndef SYSTEMCASS_SPECIFIC
    sc_cycle(0);
#endif    

    // In order with file Pattern_History_Table_vhdl_testbench_port.cpp
    // Warning : if a output depend of a subcomponent, take directly the port of subcomponent
    // (because we have no control on the ordonnancer's policy)

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	_vhdl_testbench->add_input  (PORT_READ( in_PREDICT_VAL     [i]));
	_vhdl_testbench->add_output (PORT_READ(out_PREDICT_ACK     [i]));
	_vhdl_testbench->add_input  (PORT_READ( in_PREDICT_ADDRESS [i]));
	_vhdl_testbench->add_output (PORT_READ(component_RegisterFile->out_READ_DATA [i]));
      //_vhdl_testbench->add_output (PORT_READ(out_PREDICT_HISTORY [i]));
      }

     for (uint32_t i=0; i<_param._nb_branch_complete; i++)
       {
	 _vhdl_testbench->add_input  (PORT_READ( in_BRANCH_COMPLETE_VAL      [i]));
	 _vhdl_testbench->add_output (PORT_READ(out_BRANCH_COMPLETE_ACK      [i]));
	 _vhdl_testbench->add_input  (PORT_READ( in_BRANCH_COMPLETE_ADDRESS  [i]));
	 _vhdl_testbench->add_input  (PORT_READ( in_BRANCH_COMPLETE_HISTORY  [i]));
	 _vhdl_testbench->add_input  (PORT_READ( in_BRANCH_COMPLETE_DIRECTION[i]));
       }
        
    // add_test :
    //  - True  : the cycle must be compare with the output of systemC
    //  - False : no test
    _vhdl_testbench->add_test(true);

    _vhdl_testbench->new_cycle (); // always at the end

    log_printf(FUNC,Pattern_History_Table,"vhdl_testbench_transition","End");
  };

}; // end namespace pattern_history_table
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
