#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/include/Meta_Predictor.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {


  void Meta_Predictor::vhdl_body (Vhdl & vhdl)
  {
    log_printf(FUNC,Meta_Predictor,"vhdl_body","Begin");
    vhdl.set_body ("");

    list<string> list_port_map;

    // =====[component_Meta_Predictor_Glue ]=============================
    
    list_port_map.clear();
    log_printf(INFO,Meta_Predictor,"vhdl_body","Instanciation : component_Meta_Predictor_Glue");
    
    // Instantiation

    // Interface Predict
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._have_meta_predictor)
	  {
	vhdl.set_body_component_port_map (list_port_map," in_PREDICT_PREDICTOR_0_ACK_"+toString(i)+"               ", "signal_PREDICT_PREDICTOR_0_ACK_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map," in_PREDICT_PREDICTOR_1_ACK_"+toString(i)+"               ", "signal_PREDICT_PREDICTOR_1_ACK_"+toString(i));
	  }									      					      
	vhdl.set_body_component_port_map (list_port_map," in_PREDICT_PREDICTOR_2_ACK_"+toString(i)+"               ", "signal_PREDICT_PREDICTOR_2_ACK_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map,"out_PREDICT_ACK_"+toString(i)+"                           ", "   out_PREDICT_ACK_"+toString(i));
	if (_param._have_meta_predictor)
	  {									      					      
	if (_param._predictor_0_have_bht)
	vhdl.set_body_component_port_map (list_port_map," in_PREDICT_PREDICTOR_0_BHT_HISTORY_"+toString(i)+"       ", "signal_PREDICT_PREDICTOR_0_BHT_HISTORY_"+toString(i));
	if (_param._predictor_0_have_pht)
	vhdl.set_body_component_port_map (list_port_map," in_PREDICT_PREDICTOR_0_PHT_HISTORY_"+toString(i)+"       ", "signal_PREDICT_PREDICTOR_0_PHT_HISTORY_"+toString(i));
	if (_param._predictor_1_have_bht)
	vhdl.set_body_component_port_map (list_port_map," in_PREDICT_PREDICTOR_1_BHT_HISTORY_"+toString(i)+"       ", "signal_PREDICT_PREDICTOR_1_BHT_HISTORY_"+toString(i));
	if (_param._predictor_1_have_pht)
	vhdl.set_body_component_port_map (list_port_map," in_PREDICT_PREDICTOR_1_PHT_HISTORY_"+toString(i)+"       ", "signal_PREDICT_PREDICTOR_1_PHT_HISTORY_"+toString(i));
	  }									      					      
	if (_param._predictor_2_have_bht)
	vhdl.set_body_component_port_map (list_port_map," in_PREDICT_PREDICTOR_2_BHT_HISTORY_"+toString(i)+"       ", "signal_PREDICT_PREDICTOR_2_BHT_HISTORY_"+toString(i));
	if (_param._predictor_2_have_pht)
	vhdl.set_body_component_port_map (list_port_map," in_PREDICT_PREDICTOR_2_PHT_HISTORY_"+toString(i)+"       ", "signal_PREDICT_PREDICTOR_2_PHT_HISTORY_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map,"out_PREDICT_HISTORY_"+toString(i)+"                       ", "   out_PREDICT_HISTORY_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map,"out_PREDICT_DIRECTION_"+toString(i)+"                     ", "   out_PREDICT_DIRECTION_"+toString(i));
      }

    // Interface Branch_complete
    
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	if (_param._have_meta_predictor)
	  {
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_VAL_"+toString(i)+"                    ", "    in_BRANCH_COMPLETE_VAL_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map,"out_BRANCH_COMPLETE_PREDICTOR_2_VAL_"+toString(i)+"        ", "signal_BRANCH_COMPLETE_PREDICTOR_2_VAL_"+toString(i));

	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_PREDICTOR_0_ACK_"+toString(i)+"        ", "signal_BRANCH_COMPLETE_PREDICTOR_0_ACK_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_PREDICTOR_1_ACK_"+toString(i)+"        ", "signal_BRANCH_COMPLETE_PREDICTOR_1_ACK_"+toString(i));
	  }					
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_PREDICTOR_2_ACK_"+toString(i)+"        ", "signal_BRANCH_COMPLETE_PREDICTOR_2_ACK_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map,"out_BRANCH_COMPLETE_ACK_"+toString(i)+"                    ", "   out_BRANCH_COMPLETE_ACK_"+toString(i));
						
	if (_param._have_meta_predictor)	
	  {					
	if (_param._predictor_0_have_bht)
	vhdl.set_body_component_port_map (list_port_map,"out_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY_"+toString(i)+"", "signal_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY_"+toString(i));
	if (_param._predictor_0_have_pht)
	vhdl.set_body_component_port_map (list_port_map,"out_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY_"+toString(i)+"", "signal_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY_"+toString(i));
	if (_param._predictor_1_have_bht)
	vhdl.set_body_component_port_map (list_port_map,"out_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY_"+toString(i)+"", "signal_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY_"+toString(i));
	if (_param._predictor_1_have_pht)
	vhdl.set_body_component_port_map (list_port_map,"out_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY_"+toString(i)+"", "signal_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY_"+toString(i));
	  }					
	if (_param._predictor_2_have_bht)
	vhdl.set_body_component_port_map (list_port_map,"out_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY_"+toString(i)+"", "signal_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY_"+toString(i));
	if (_param._predictor_2_have_pht)
	vhdl.set_body_component_port_map (list_port_map,"out_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY_"+toString(i)+"", "signal_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_HISTORY_"+toString(i)+"                ", "    in_BRANCH_COMPLETE_HISTORY_"+toString(i));
	if (_param._have_meta_predictor)	
	  {
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_DIRECTION_"+toString(i)+"              ", "    in_BRANCH_COMPLETE_DIRECTION_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map,"out_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION_"+toString(i)+"  ", "signal_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION_"+toString(i));
	  }
      }

    vhdl.set_body_component ("component_Meta_Predictor_Glue",_name+"_Meta_Predictor_Glue",list_port_map);

    // =====[component_Two_Level_Branch_Predictor_2 ]====================    

    list_port_map.clear();
    log_printf(INFO,Meta_Predictor,"vhdl_body","Instanciation : component_Two_Level_Branch_Predictor_2");
    
    // Instantiation
    vhdl.set_body_component_port_map (list_port_map,"in_CLOCK","in_CLOCK");
    
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	vhdl.set_body_component_port_map (list_port_map," in_PREDICT_VAL_"+toString(i)+"                ", "    in_PREDICT_VAL_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map,"out_PREDICT_ACK_"+toString(i)+"                ", "signal_PREDICT_PREDICTOR_2_ACK_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map," in_PREDICT_ADDRESS_"+toString(i)+"            ", "    in_PREDICT_ADDRESS_"+toString(i));
	if (_param._predictor_2_have_bht)						       				       
	vhdl.set_body_component_port_map (list_port_map,"out_PREDICT_BHT_HISTORY_"+toString(i)+"        ", "signal_PREDICT_PREDICTOR_2_BHT_HISTORY_"+toString(i));
	if (_param._predictor_2_have_pht)
	vhdl.set_body_component_port_map (list_port_map,"out_PREDICT_PHT_HISTORY_"+toString(i)+"        ", "signal_PREDICT_PREDICTOR_2_PHT_HISTORY_"+toString(i));
      }
    
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	if (_param._have_meta_predictor)
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_VAL_"+toString(i)+"        ", "signal_BRANCH_COMPLETE_PREDICTOR_2_VAL_"+toString(i));
	else
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_VAL_"+toString(i)+"        ", "    in_BRANCH_COMPLETE_VAL_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map,"out_BRANCH_COMPLETE_ACK_"+toString(i)+"        ", "signal_BRANCH_COMPLETE_PREDICTOR_2_ACK_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_ADDRESS_"+toString(i)+"    ", "    in_BRANCH_COMPLETE_ADDRESS_"+toString(i));
	if (_param._predictor_2_have_bht)						       					
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_BHT_HISTORY_"+toString(i)+"", "signal_BRANCH_COMPLETE_PREDICTOR_2_BHT_HISTORY_"+toString(i));
	if (_param._predictor_2_have_pht)						       					
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_PHT_HISTORY_"+toString(i)+"", "signal_BRANCH_COMPLETE_PREDICTOR_2_PHT_HISTORY_"+toString(i));
	if (_param._have_meta_predictor)
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_DIRECTION_"+toString(i)+"  ", "signal_BRANCH_COMPLETE_PREDICTOR_2_DIRECTION_"+toString(i));
	else
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_DIRECTION_"+toString(i)+"  ", "    in_BRANCH_COMPLETE_DIRECTION_"+toString(i));	 
      }

    vhdl.set_body_component ("component_Two_Level_Branch_Predictor_2",_name+"_Two_Level_Branch_Predictor_2",list_port_map);

    if (_param._have_meta_predictor)
      {
    // =====[component_Two_Level_Branch_Predictor_1 ]====================    

    list_port_map.clear();
    log_printf(INFO,Meta_Predictor,"vhdl_body","Instanciation : component_Two_Level_Branch_Predictor_1");
    
    // Instantiation
    vhdl.set_body_component_port_map (list_port_map,"in_CLOCK","in_CLOCK");
    
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	vhdl.set_body_component_port_map (list_port_map," in_PREDICT_VAL_"+toString(i)+"                ", "    in_PREDICT_VAL_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map,"out_PREDICT_ACK_"+toString(i)+"                ", "signal_PREDICT_PREDICTOR_1_ACK_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map," in_PREDICT_ADDRESS_"+toString(i)+"            ", "    in_PREDICT_ADDRESS_"+toString(i));
	if (_param._predictor_1_have_bht)						       				       
	vhdl.set_body_component_port_map (list_port_map,"out_PREDICT_BHT_HISTORY_"+toString(i)+"        ", "signal_PREDICT_PREDICTOR_1_BHT_HISTORY_"+toString(i));
	if (_param._predictor_1_have_pht)
	vhdl.set_body_component_port_map (list_port_map,"out_PREDICT_PHT_HISTORY_"+toString(i)+"        ", "signal_PREDICT_PREDICTOR_1_PHT_HISTORY_"+toString(i));
      }
    
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_VAL_"+toString(i)+"        ", "    in_BRANCH_COMPLETE_VAL_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map,"out_BRANCH_COMPLETE_ACK_"+toString(i)+"        ", "signal_BRANCH_COMPLETE_PREDICTOR_1_ACK_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_ADDRESS_"+toString(i)+"    ", "    in_BRANCH_COMPLETE_ADDRESS_"+toString(i));
	if (_param._predictor_1_have_bht)						       					
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_BHT_HISTORY_"+toString(i)+"", "signal_BRANCH_COMPLETE_PREDICTOR_1_BHT_HISTORY_"+toString(i));
	if (_param._predictor_1_have_pht)						       					
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_PHT_HISTORY_"+toString(i)+"", "signal_BRANCH_COMPLETE_PREDICTOR_1_PHT_HISTORY_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_DIRECTION_"+toString(i)+"  ", "    in_BRANCH_COMPLETE_DIRECTION_"+toString(i));	 
      }

    vhdl.set_body_component ("component_Two_Level_Branch_Predictor_1",_name+"_Two_Level_Branch_Predictor_1",list_port_map);

    // =====[component_Two_Level_Branch_Predictor_0 ]====================    

    list_port_map.clear();
    log_printf(INFO,Meta_Predictor,"vhdl_body","Instanciation : component_Two_Level_Branch_Predictor_0");
    
    // Instantiation
    vhdl.set_body_component_port_map (list_port_map,"in_CLOCK","in_CLOCK");
    
    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	vhdl.set_body_component_port_map (list_port_map," in_PREDICT_VAL_"+toString(i)+"                ", "    in_PREDICT_VAL_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map,"out_PREDICT_ACK_"+toString(i)+"                ", "signal_PREDICT_PREDICTOR_0_ACK_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map," in_PREDICT_ADDRESS_"+toString(i)+"            ", "    in_PREDICT_ADDRESS_"+toString(i));
	if (_param._predictor_0_have_bht)						       				       
	vhdl.set_body_component_port_map (list_port_map,"out_PREDICT_BHT_HISTORY_"+toString(i)+"        ", "signal_PREDICT_PREDICTOR_0_BHT_HISTORY_"+toString(i));
	if (_param._predictor_0_have_pht)
	vhdl.set_body_component_port_map (list_port_map,"out_PREDICT_PHT_HISTORY_"+toString(i)+"        ", "signal_PREDICT_PREDICTOR_0_PHT_HISTORY_"+toString(i));
      }
    
    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_VAL_"+toString(i)+"        ", "    in_BRANCH_COMPLETE_VAL_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map,"out_BRANCH_COMPLETE_ACK_"+toString(i)+"        ", "signal_BRANCH_COMPLETE_PREDICTOR_0_ACK_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_ADDRESS_"+toString(i)+"    ", "    in_BRANCH_COMPLETE_ADDRESS_"+toString(i));
	if (_param._predictor_0_have_bht)						       					
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_BHT_HISTORY_"+toString(i)+"", "signal_BRANCH_COMPLETE_PREDICTOR_0_BHT_HISTORY_"+toString(i));
	if (_param._predictor_0_have_pht)						       					
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_PHT_HISTORY_"+toString(i)+"", "signal_BRANCH_COMPLETE_PREDICTOR_0_PHT_HISTORY_"+toString(i));
	vhdl.set_body_component_port_map (list_port_map," in_BRANCH_COMPLETE_DIRECTION_"+toString(i)+"  ", "    in_BRANCH_COMPLETE_DIRECTION_"+toString(i));	 
      }

    vhdl.set_body_component ("component_Two_Level_Branch_Predictor_0",_name+"_Two_Level_Branch_Predictor_0",list_port_map);
      }

    log_printf(FUNC,Meta_Predictor,"vhdl_body","End");
  };

}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
