#ifdef VHDL
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Counter/include/Counter.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace counter {


  void Counter::vhdl_body (Vhdl & vhdl)
  {
    log_printf(FUNC,Counter,"vhdl_body","Begin");
    vhdl.set_body ("");
    
    for (uint32_t i=0; i<_param._nb_port; i++)
      {
	string counter_inc, counter_dec;

	if (_param._size_data > 1)
	  {
	    counter_inc = "in_COUNTER_DATA_"+toString(i)+"+1";
	    counter_dec = "in_COUNTER_DATA_"+toString(i)+"-1";
	  }
	else
	  {
	    counter_inc = "in_COUNTER_DATA_"+toString(i)+"+1";
	    counter_dec = "in_COUNTER_DATA_"+toString(i)+"-1";
	  }

	vhdl.set_body ("out_COUNTER_DATA_"+toString(i)+" <=");
	if (_param._size_data > 1)
	  {
	    vhdl.set_body ("\tin_COUNTER_DATA_"+toString(i)+"+1 when in_COUNTER_ADDSUB_"+toString(i)+" = '1' and in_COUNTER_DATA_"+toString(i)+" < cst_max else");
	    vhdl.set_body ("\tin_COUNTER_DATA_"+toString(i)+"-1 when in_COUNTER_ADDSUB_"+toString(i)+" = '0' and in_COUNTER_DATA_"+toString(i)+" > cst_min else");
	    vhdl.set_body ("\tin_COUNTER_DATA_"+toString(i)+";");
	  }
	else
	  {
	    vhdl.set_body ("\tin_COUNTER_ADDSUB_"+toString(i)+";");
	  }
      }

    log_printf(FUNC,Counter,"vhdl_body","End");
  };

}; // end namespace counter
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
