#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile_Multi_Banked/RegisterFile_Multi_Banked_Glue/include/RegisterFile_Multi_Banked_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile_multi_banked {
namespace registerfile_multi_banked_glue {


  void RegisterFile_Multi_Banked_Glue::allocation (void)
  {
    string rename;

    log_printf(FUNC,RegisterFile_Multi_Banked_Glue,"allocation","Begin");

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    in_CLOCK  = new SC_CLOCK           ("in_CLOCK");
#endif

    in_READ_IN_VAL       = new SC_IN (Tcontrol_t)           * [_param._nb_port_read];
   out_READ_IN_ACK       = new SC_OUT(Tcontrol_t)           * [_param._nb_port_read];
    in_READ_IN_ADDRESS   = new SC_IN (Taddress_t)           * [_param._nb_port_read];
   out_READ_IN_DATA      = new SC_OUT(Tdata_t   )           * [_param._nb_port_read];
    in_READ_SELECT_VAL   = new SC_IN (Tcontrol_t)           * [_param._nb_port_read];
   out_READ_SELECT_ACK   = new SC_OUT(Tcontrol_t)           * [_param._nb_port_read];

   for (uint32_t i=0; i<_param._nb_port_read; i++)
     {
       rename = " in_READ_IN_VAL_"+toString(i)+"      ";
        in_READ_IN_VAL       [i] = new SC_IN (Tcontrol_t) (rename.c_str());

       rename = "out_READ_IN_ACK_"+toString(i)+"      ";
       out_READ_IN_ACK       [i] = new SC_OUT(Tcontrol_t) (rename.c_str());

       rename = " in_READ_IN_ADDRESS_"+toString(i)+"  ";
        in_READ_IN_ADDRESS   [i] = new SC_IN (Taddress_t) (rename.c_str());

       rename = "out_READ_IN_DATA_"+toString(i)+"     ";
       out_READ_IN_DATA      [i] = new SC_OUT(Tdata_t   ) (rename.c_str());

       rename = " in_READ_SELECT_VAL_"+toString(i)+"  ";
        in_READ_SELECT_VAL   [i] = new SC_IN (Tcontrol_t) (rename.c_str());

       rename = "out_READ_SELECT_ACK_"+toString(i)+"  ";
       out_READ_SELECT_ACK   [i] = new SC_OUT(Tcontrol_t) (rename.c_str());
     }
   						      
   out_READ_OUT_VAL      = new SC_OUT(Tcontrol_t)          ** [_param._nb_bank];
    in_READ_OUT_ACK      = new SC_IN (Tcontrol_t)          ** [_param._nb_bank];
   out_READ_OUT_ADDRESS  = new SC_OUT(Taddress_t)          ** [_param._nb_bank];
    in_READ_OUT_DATA     = new SC_IN (Tdata_t   )          ** [_param._nb_bank];

    for (uint32_t i=0; i<_param._nb_bank; i++)
      {
	out_READ_OUT_VAL      [i] = new SC_OUT(Tcontrol_t)          * [_param._nb_port_read_by_bank];
	 in_READ_OUT_ACK      [i] = new SC_IN (Tcontrol_t)          * [_param._nb_port_read_by_bank];
	out_READ_OUT_ADDRESS  [i] = new SC_OUT(Taddress_t)          * [_param._nb_port_read_by_bank];
	 in_READ_OUT_DATA     [i] = new SC_IN (Tdata_t   )          * [_param._nb_port_read_by_bank];

	for (uint32_t j=0; j<_param._nb_port_read_by_bank; j++)
	  {

	    rename="out_READ_OUT_VAL_"+toString(i)+"_"+toString(j)+"      ";
	    out_READ_OUT_VAL      [i][j] = new SC_OUT(Tcontrol_t) (rename.c_str());

	    rename=" in_READ_OUT_ACK_"+toString(i)+"_"+toString(j)+"      ";
	     in_READ_OUT_ACK      [i][j] = new SC_IN (Tcontrol_t) (rename.c_str());

	    rename="out_READ_OUT_ADDRESS_"+toString(i)+"_"+toString(j)+"  ";
	    out_READ_OUT_ADDRESS  [i][j] = new SC_OUT(Taddress_t) (rename.c_str());

	    rename=" in_READ_OUT_DATA_"+toString(i)+"_"+toString(j)+"     ";
	     in_READ_OUT_DATA     [i][j] = new SC_IN (Tdata_t   ) (rename.c_str());
	  }
      }

    in_WRITE_IN_VAL      = new SC_IN (Tcontrol_t)           * [_param._nb_port_write];
   out_WRITE_IN_ACK      = new SC_OUT(Tcontrol_t)           * [_param._nb_port_write];
    in_WRITE_IN_ADDRESS  = new SC_IN (Taddress_t)           * [_param._nb_port_write];
    in_WRITE_IN_DATA     = new SC_IN (Tdata_t   )           * [_param._nb_port_write];
    in_WRITE_SELECT_VAL  = new SC_IN (Tcontrol_t)           * [_param._nb_port_write];
   out_WRITE_SELECT_ACK  = new SC_OUT(Tcontrol_t)           * [_param._nb_port_write];

   for (uint32_t i=0; i<_param._nb_port_write; i++)
     {
       rename = " in_WRITE_IN_VAL_"+toString(i)+"     ";
        in_WRITE_IN_VAL      [i] = new SC_IN (Tcontrol_t) (rename.c_str());

       rename = "out_WRITE_IN_ACK_"+toString(i)+"     ";
       out_WRITE_IN_ACK      [i] = new SC_OUT(Tcontrol_t) (rename.c_str());

       rename = " in_WRITE_IN_ADDRESS_"+toString(i)+" ";
        in_WRITE_IN_ADDRESS  [i] = new SC_IN (Taddress_t) (rename.c_str());

       rename = " in_WRITE_IN_DATA_"+toString(i)+"    ";
        in_WRITE_IN_DATA     [i] = new SC_IN (Tdata_t   ) (rename.c_str());

       rename = " in_WRITE_SELECT_VAL_"+toString(i)+" ";
        in_WRITE_SELECT_VAL   [i] = new SC_IN (Tcontrol_t) (rename.c_str());

       rename = "out_WRITE_SELECT_ACK_"+toString(i)+" ";
       out_WRITE_SELECT_ACK   [i] = new SC_OUT(Tcontrol_t) (rename.c_str());
     }
   
   
   out_WRITE_OUT_VAL     = new SC_OUT(Tcontrol_t)          ** [_param._nb_bank];
    in_WRITE_OUT_ACK     = new SC_IN (Tcontrol_t)          ** [_param._nb_bank];
   out_WRITE_OUT_ADDRESS = new SC_OUT(Taddress_t)          ** [_param._nb_bank];
   out_WRITE_OUT_DATA    = new SC_OUT(Tdata_t   )          ** [_param._nb_bank];

    for (uint32_t i=0; i<_param._nb_bank; i++)
      {
	out_WRITE_OUT_VAL     [i] = new SC_OUT(Tcontrol_t)          * [_param._nb_port_write_by_bank];
	 in_WRITE_OUT_ACK     [i] = new SC_IN (Tcontrol_t)          * [_param._nb_port_write_by_bank];
	out_WRITE_OUT_ADDRESS [i] = new SC_OUT(Taddress_t)          * [_param._nb_port_write_by_bank];
	out_WRITE_OUT_DATA    [i] = new SC_OUT(Tdata_t   )          * [_param._nb_port_write_by_bank];

	for (uint32_t j=0; j<_param._nb_port_write_by_bank; j++)
	  {
	    rename = "out_WRITE_OUT_VAL_"+toString(i)+"_"+toString(j)+"     ";
	    out_WRITE_OUT_VAL     [i][j] = new SC_OUT(Tcontrol_t) (rename.c_str());

	    rename = " in_WRITE_OUT_ACK_"+toString(i)+"_"+toString(j)+"     ";
	     in_WRITE_OUT_ACK     [i][j] = new SC_IN (Tcontrol_t) (rename.c_str());

	    rename = "out_WRITE_OUT_ADDRESS_"+toString(i)+"_"+toString(j)+" ";
	    out_WRITE_OUT_ADDRESS [i][j] = new SC_OUT(Taddress_t) (rename.c_str());

	    rename = "out_WRITE_OUT_DATA_"+toString(i)+"_"+toString(j)+"    ";
	    out_WRITE_OUT_DATA    [i][j] = new SC_OUT(Tdata_t   ) (rename.c_str());
	  }
      }

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    log_printf(FUNC,RegisterFile_Multi_Banked_Glue,"allocation","End");
  };

}; // end namespace registerfile_multi_banked_glue
}; // end namespace registerfile_multi_banked
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
