#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Shifter/include/Shifter.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace shifter {


  void Shifter::allocation (void)
  {
    string rename;

#if (defined(STATISTICS) || defined (VHDL_TESTBENCH))
     in_CLOCK           = new SC_CLOCK ("SC_CLOCK");
#endif
    // Interface "shifter"
     in_SHIFTER_DATA      = new SC_IN (Tdata_t)      * [_param._nb_port];
    if (_param._shift_value == 0)
     in_SHIFTER_SHIFT     = new SC_IN (Tshift_t)     * [_param._nb_port];
    if (_param._direction   == external_direction)
     in_SHIFTER_DIRECTION = new SC_IN (Tdirection_t) * [_param._nb_port];
    if (_param._rotate      == external_rotate)
     in_SHIFTER_TYPE      = new SC_IN (Ttype_t)      * [_param._nb_port];
    if (_param._carry       == external_carry)
     in_SHIFTER_CARRY     = new SC_IN (Tcarry_t)     * [_param._nb_port];
    if (_param._carry       == external_completion)
    if (_param._type_completion_bool == true)
     in_SHIFTER_CARRY_IN  = new SC_IN (Tcontrol_t)   * [_param._nb_port];
    else
     in_SHIFTER_COMPLETION= new SC_IN (Tdata_t)      * [_param._nb_port];
    out_SHIFTER_DATA      = new SC_OUT(Tdata_t)      * [_param._nb_port];
    
    for (uint32_t i=0; i<_param._nb_port; i++)
      {
	rename = "in_SHIFTER_DATA["      + toString(i) + "]";
	 in_SHIFTER_DATA      [i] = new SC_IN (Tdata_t)      (rename.c_str());

	if (_param._shift_value == 0)
	  {
	rename = "in_SHIFTER_SHIFT["     + toString(i) + "]";
	 in_SHIFTER_SHIFT     [i] = new SC_IN (Tshift_t)     (rename.c_str());
	  }
	if (_param._direction == external_direction)
	  {
	rename = "in_SHIFTER_DIRECTION[" + toString(i) + "]";
	 in_SHIFTER_DIRECTION [i] = new SC_IN (Tdirection_t) (rename.c_str());
	  }
	if (_param._rotate  == external_rotate)
	  {
	rename = "in_SHIFTER_TYPE["      + toString(i) + "]";
	 in_SHIFTER_TYPE     [i]      = new SC_IN (Ttype_t)  (rename.c_str());
	  }
	if (_param._carry == external_carry)
	  {
	rename = "in_SHIFTER_CARRY["    + toString(i) + "]";
	 in_SHIFTER_CARRY    [i] = new SC_IN (Tcarry_t)      (rename.c_str());
	  }

	if (_param._carry       == external_completion)
	if (_param._type_completion_bool == true)
	  {
	 rename = "in_SHIFTER_CARRY_IN["      + toString(i) + "]";
	 in_SHIFTER_CARRY_IN   [i] = new SC_IN (Tcontrol_t)  (rename.c_str());	  
	  }
	else
	  {
	 rename = "in_SHIFTER_COMPLETION["    + toString(i) + "]";
	 in_SHIFTER_COMPLETION [i] = new SC_IN (Tdata_t)     (rename.c_str());
	  }
	
	rename = "out_SHIFTER_DATA["    + toString(i) + "]";
	out_SHIFTER_DATA     [i] = new SC_OUT(Tdata_t)       (rename.c_str());
      }
  };

}; // end namespace shifter
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
