#ifdef VHDL_TESTBENCH
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Shifter/include/Shifter.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace shifter {


  void Shifter::vhdl_testbench_transition (Vhdl_Testbench & vhdl_testbench)
  {
#ifndef SYSTEMCASS_SPECIFIC
    sc_cycle(0);
#endif

    // In order with file Shifter_vhdl_testbench_port.cpp

    for (uint32_t i=0; i<_param._nb_port; i++)
      {
	vhdl_testbench.add_input  (PORT_READ( in_SHIFTER_DATA      [i]));
	if (_param._shift_value == 0)
	vhdl_testbench.add_input  (PORT_READ( in_SHIFTER_SHIFT     [i]));
	if (_param._direction   == external_direction)
	vhdl_testbench.add_input  (PORT_READ( in_SHIFTER_DIRECTION [i]));
	if (_param._rotate      == external_rotate)
	vhdl_testbench.add_input  (PORT_READ( in_SHIFTER_TYPE      [i]));
	if (_param._carry       == external_carry)
	vhdl_testbench.add_input  (PORT_READ( in_SHIFTER_CARRY     [i]));
	if (_param._carry       == external_completion)
	if (_param._type_completion_bool == true)
	vhdl_testbench.add_input  (PORT_READ( in_SHIFTER_CARRY_IN  [i]));
	else
	vhdl_testbench.add_input  (PORT_READ( in_SHIFTER_COMPLETION[i]));
	vhdl_testbench.add_output (PORT_READ(out_SHIFTER_DATA      [i]));
      }
    
    // add_test :
    //  - True  : the cycle must be compare with the output of systemC
    //  - False : no test
    vhdl_testbench.add_test(true);

    vhdl_testbench.new_cycle (); // always at the end
  };

}; // end namespace shifter
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
