/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/@DIRECTORY/include/@COMPONENT.h"

namespace morpheo                    {
namespace behavioural {
@NAMESPACE_BEGIN

#ifdef SYSTEMC
  @COMPONENT::@COMPONENT (sc_module_name name,
#else
  @COMPONENT::@COMPONENT (string name,
#endif
#ifdef STATISTICS
			      morpheo::behavioural::Parameters_Statistics             param_statistics,
#endif
			      morpheo::behavioural::@NAMESPACE_USE::Parameters param ):
			      _name              (name)
			      ,_param            (param)
// #ifdef STATISTICS
// 			      ,_param_statistics (param_statistics)
// #endif
  {
    log_printf(FUNC,@COMPONENT,"@COMPONENT","Begin");

#ifdef STATISTICS
    // Allocation of statistics
    _stat = new Statistics (static_cast<string>(_name),
			    param_statistics          ,
			    param);
#endif

#ifdef VHDL_TESTBENCH
    // Creation of a testbench
    //  -> port
    //  -> clock's signals
    _vhdl_testbench = new Vhdl_Testbench (_name);
    vhdl_testbench_port           ();
    _vhdl_testbench->set_clock    ("in_CLOCK",true);
#endif

#ifdef VHDL
    // generate the vhdl
    vhdl();
#endif

#ifdef SYSTEMC
    allocation ();

    SC_METHOD (transition);
    dont_initialize ();
    sensitive_pos << *(in_CLOCK);

//     SC_METHOD (genMoore);
//     dont_initialize ();
//     sensitive_neg << *(in_CLOCK);

#ifdef SYSTEMCASS_SPECIFIC
    // List dependency information
#endif    

#endif
    log_printf(FUNC,@COMPONENT,"@COMPONENT","End");
  };
  
  @COMPONENT::~@COMPONENT (void)
  {
    log_printf(FUNC,@COMPONENT,"~@COMPONENT","Begin");

#ifdef VHDL_TESTBENCH
    // generate the test bench
    _vhdl_testbench->generate_file();
    delete _vhdl_testbench;
#endif

#ifdef STATISTICS
    _stat->generate_file(statistics(0));
    
    delete _stat;
#endif

#ifdef SYSTEMC
    deallocation ();
#endif

    log_printf(FUNC,@COMPONENT,"~@COMPONENT","End");
  };

@NAMESPACE_END
}; // end namespace behavioural
}; // end namespace morpheo              
