/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Branch_History_Table/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {
namespace branch_history_table {


  Parameters::Parameters (uint32_t size_shifter      ,
 			  uint32_t nb_shifter        ,
			  uint32_t nb_prediction     ,
			  uint32_t nb_branch_complete) :
    _size_shifter       (size_shifter      ),
    _nb_shifter         (nb_shifter        ),
    _nb_prediction      (nb_prediction     ),
    _nb_branch_complete (nb_branch_complete)
  {
    _param_shifter = new morpheo::behavioural::generic::shifter::Parameters (size_shifter       ,
									     nb_branch_complete ,
									     1                  ,
									     morpheo::behavioural::generic::shifter::without_rotate     ,
									     morpheo::behavioural::generic::shifter::internal_left_shift,
									     morpheo::behavioural::generic::shifter::external_completion),
    _param_registerfile = new morpheo::behavioural::generic::registerfile::Parameters (nb_prediction      ,
										       nb_branch_complete ,
										       nb_shifter         ,
										       size_shifter       );
    
    test();
  };
  
  Parameters::Parameters (Parameters & param) :
    _size_shifter       (param._size_shifter      ),
    _nb_shifter         (param._nb_shifter        ),
    _nb_prediction      (param._nb_prediction     ),
    _nb_branch_complete (param._nb_branch_complete)
  {
    _param_shifter = new morpheo::behavioural::generic::shifter::Parameters (param._size_shifter       ,
									     param._nb_branch_complete ,
									     1                         ,
									     morpheo::behavioural::generic::shifter::without_rotate     ,
									     morpheo::behavioural::generic::shifter::internal_left_shift,
									     morpheo::behavioural::generic::shifter::external_completion,
									     true),

    _param_registerfile = new morpheo::behavioural::generic::registerfile::Parameters (param._nb_prediction      ,
										       param._nb_branch_complete ,
										       param._nb_shifter         ,
										       param._size_shifter       );
      


    test();
  };

  Parameters::~Parameters () 
  {
    delete _param_shifter;
    delete _param_registerfile;
  };

}; // end namespace branch_history_table
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch
}; // end namespace behavioural
}; // end namespace morpheo              
