#ifndef morpheo_behavioural_stage_1_ifetch_predictor_meta_predictor_two_level_branch_predictor_pattern_history_table_Pattern_History_Table_h
#define morpheo_behavioural_stage_1_ifetch_predictor_meta_predictor_two_level_branch_predictor_pattern_history_table_Pattern_History_Table_h

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Include/ToString.h"
#include "Include/Debug.h"

// Internal structure
#include "Behavioural/Generic/Counter/include/Counter.h"
#include "Behavioural/Generic/RegisterFile/include/RegisterFile.h"

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Pattern_History_Table/include/Parameters.h"
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Pattern_History_Table/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Pattern_History_Table/include/Statistics.h"
#endif
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#ifdef VHDL_TESTBENCH
#include "Behavioural/include/Vhdl_Testbench.h"
#endif

using namespace std;

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {
namespace pattern_history_table {


  class Pattern_History_Table 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[fields ]----------------------------------------------------
    // Parameters
  protected : const string     _name;

  protected : const Parameters _param;
#ifdef STATISTICS
 protected : const morpheo::behavioural::Parameters_Statistics _param_statistics;
#endif

#ifdef STATISTICS
  private   : Statistics                     * _stat;
#endif

#ifdef VHDL_TESTBENCH
  private   : Vhdl_Testbench                 * _vhdl_testbench;
#endif

#ifdef SYSTEMC
    // ~~~~~[Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;

  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_VAL            ;
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_ACK            ;
  public    : SC_IN (Taddress_t)           **  in_PREDICT_ADDRESS        ;
  public    : SC_OUT(Thistory_t)           ** out_PREDICT_HISTORY        ;

  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_VAL    ;
  public    : SC_OUT(Tcontrol_t)           ** out_BRANCH_COMPLETE_ACK    ;
  public    : SC_IN (Taddress_t)           **  in_BRANCH_COMPLETE_ADDRESS;
  public    : SC_IN (Thistory_t)           **  in_BRANCH_COMPLETE_HISTORY;
  public    : SC_IN (Tcontrol_t)           **  in_BRANCH_COMPLETE_DIRECTION;

    // ~~~~~[Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_SIGNAL(Thistory_t)        ** signal_BRANCH_COMPLETE_HISTORY;
#endif

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  public    : morpheo::behavioural::generic::counter::Counter           * component_Counter     ;
  public    : morpheo::behavioural::generic::registerfile::RegisterFile * component_RegisterFile;

    // -----[methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Pattern_History_Table);
#endif					       

  public  :          Pattern_History_Table              (
#ifdef SYSTEMC
							 sc_module_name                              name,
#else					       
							 string                                      name,
#endif					       
#ifdef STATISTICS
							 morpheo::behavioural::Parameters_Statistics param_statistics,
#endif
							 Parameters                                  param );
    
  public  :          Pattern_History_Table              (Parameters param );
  public  :          ~Pattern_History_Table             (void);
					       
#ifdef SYSTEMC				       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
#if (defined(STATISTICS) || defined (VHDL_TESTBENCH))
  public  : void     transition                (void);
#endif
#endif					       

#ifdef STATISTICS
  public  : string   statistics                (uint32_t depth);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_port                 (Vhdl & vhdl);
  private : void     vhdl_declaration          (Vhdl & vhdl);
  private : void     vhdl_body                 (Vhdl & vhdl);
#endif					       
					       
#ifdef VHDL_TESTBENCH			       
  private : void     vhdl_testbench_port       (void);
  private : void     vhdl_testbench_transition (void);
#endif
  public  : void     vhdl_testbench_label      (string label);
  };

}; // end namespace pattern_history_table
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
