#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/include/Two_Level_Branch_Predictor_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {
namespace two_level_branch_predictor_glue {


  void Two_Level_Branch_Predictor_Glue::allocation (void)
  {
    string rename;

    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"allocation","Begin");

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    in_CLOCK  = new SC_CLOCK           ("in_CLOCK");
#endif
    
    if (_param._have_bht)
      {
     in_PREDICT_BHT_ACK              = new SC_IN (Tcontrol_t)           * [_param._nb_prediction];
    out_PREDICT_BHT_ADDRESS          = new SC_OUT(Taddress_t)           * [_param._nb_prediction];
      }
    if (_param._have_pht)
      {
     in_PREDICT_PHT_ACK              = new SC_IN (Tcontrol_t)           * [_param._nb_prediction];
    out_PREDICT_PHT_ADDRESS          = new SC_OUT(Taddress_t)           * [_param._nb_prediction];
      }
    if (_param._have_bht and _param._have_pht)
     in_PREDICT_BHT_HISTORY          = new SC_IN (Tbht_history_t)       * [_param._nb_prediction];
    out_PREDICT_ACK                  = new SC_OUT(Tcontrol_t)           * [_param._nb_prediction];
     in_PREDICT_ADDRESS              = new SC_IN (Taddress_t)           * [_param._nb_prediction];

    for (uint32_t i=0; i<_param._nb_prediction; i++)
      {
	if (_param._have_bht)
	  {
	rename = " in_PREDICT_BHT_ACK_"    +toString(i);
         in_PREDICT_BHT_ACK             [i] = new SC_IN (Tcontrol_t)     (rename.c_str());

	rename = "out_PREDICT_BHT_ADDRESS_"+toString(i);
        out_PREDICT_BHT_ADDRESS         [i] = new SC_OUT(Taddress_t)     (rename.c_str());
	  }
	if (_param._have_pht)
	  {
        rename = " in_PREDICT_PHT_ACK_"    +toString(i);
         in_PREDICT_PHT_ACK             [i] = new SC_IN (Tcontrol_t)     (rename.c_str());
        
	rename = "out_PREDICT_PHT_ADDRESS_"+toString(i);
        out_PREDICT_PHT_ADDRESS         [i] = new SC_OUT(Taddress_t)     (rename.c_str());
	  }
	if (_param._have_bht and _param._have_pht)
	  {
	rename = " in_PREDICT_BHT_HISTORY_"+toString(i);
         in_PREDICT_BHT_HISTORY         [i] = new SC_IN (Tbht_history_t) (rename.c_str());
	  }
        rename = "out_PREDICT_ACK_"        +toString(i);
        out_PREDICT_ACK                 [i] = new SC_OUT(Tcontrol_t)     (rename.c_str());
        
        rename = " in_PREDICT_ADDRESS_"    +toString(i);
         in_PREDICT_ADDRESS             [i] = new SC_IN (Taddress_t)     (rename.c_str());
      }

    if (_param._have_bht)
      {
     in_BRANCH_COMPLETE_BHT_ACK              = new SC_IN (Tcontrol_t)           * [_param._nb_branch_complete];
    out_BRANCH_COMPLETE_BHT_ADDRESS          = new SC_OUT(Taddress_t)           * [_param._nb_branch_complete];
      }
    if (_param._have_pht)
      {
     in_BRANCH_COMPLETE_PHT_ACK              = new SC_IN (Tcontrol_t)           * [_param._nb_branch_complete];
    out_BRANCH_COMPLETE_PHT_ADDRESS          = new SC_OUT(Taddress_t)           * [_param._nb_branch_complete];
      }
    if (_param._have_bht and _param._have_pht)
     in_BRANCH_COMPLETE_BHT_HISTORY          = new SC_IN (Tbht_history_t)       * [_param._nb_branch_complete];
    
    out_BRANCH_COMPLETE_ACK                  = new SC_OUT(Tcontrol_t)           * [_param._nb_branch_complete];
     in_BRANCH_COMPLETE_ADDRESS              = new SC_IN (Taddress_t)           * [_param._nb_branch_complete];

    for (uint32_t i=0; i<_param._nb_branch_complete; i++)
      {
	if (_param._have_bht)
	  {
	rename = " in_BRANCH_COMPLETE_BHT_ACK_"    +toString(i);
         in_BRANCH_COMPLETE_BHT_ACK             [i] = new SC_IN (Tcontrol_t)     (rename.c_str());
        
        rename = "out_BRANCH_COMPLETE_BHT_ADDRESS_"+toString(i);
        out_BRANCH_COMPLETE_BHT_ADDRESS         [i] = new SC_OUT(Taddress_t)     (rename.c_str());
	  }
	if (_param._have_pht)
	  {
        rename = " in_BRANCH_COMPLETE_PHT_ACK_"    +toString(i);
         in_BRANCH_COMPLETE_PHT_ACK             [i] = new SC_IN (Tcontrol_t)     (rename.c_str());

        rename = "out_BRANCH_COMPLETE_PHT_ADDRESS_"+toString(i);
        out_BRANCH_COMPLETE_PHT_ADDRESS         [i] = new SC_OUT(Taddress_t)     (rename.c_str());
	  }
	if (_param._have_bht and _param._have_pht)
	  {
        rename = " in_BRANCH_COMPLETE_BHT_HISTORY_"+toString(i);
         in_BRANCH_COMPLETE_BHT_HISTORY         [i] = new SC_IN (Tbht_history_t) (rename.c_str());
	  }
        rename = "out_BRANCH_COMPLETE_ACK_"        +toString(i);
        out_BRANCH_COMPLETE_ACK                 [i] = new SC_OUT(Tcontrol_t)     (rename.c_str());
        
        rename = " in_BRANCH_COMPLETE_ADDRESS_"    +toString(i);
         in_BRANCH_COMPLETE_ADDRESS             [i] = new SC_IN (Taddress_t)     (rename.c_str());
      }

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"allocation","End");
  };

}; // end namespace two_level_branch_predictor_glue
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
