#ifdef SYSTEMC
/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/Stage_1_Ifetch/Predictor/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/include/Two_Level_Branch_Predictor_Glue.h"
#include "Include/BitManipulation.h"

namespace morpheo {
namespace behavioural {
namespace stage_1_ifetch {
namespace predictor {
namespace meta_predictor {
namespace two_level_branch_predictor {
namespace two_level_branch_predictor_glue {

  void Two_Level_Branch_Predictor_Glue::genMealy_branch_complete_bht_address (void)
  {
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"genMealy_branch_complete_address","Begin");

    if (_param._have_bht)
      for (uint32_t i=0; i<_param._nb_branch_complete; i++)
	{
	  // Address
	  Taddress_t address = PORT_READ(in_BRANCH_COMPLETE_ADDRESS [i]);
	  
	  PORT_WRITE (out_BRANCH_COMPLETE_BHT_ADDRESS [i], range<Taddress_t>(_param._size_address, address, _param._bht_size_address));
	}
    
    log_printf(FUNC,Two_Level_Branch_Predictor_Glue,"genMealy_branch_complete_address","End");
  };

}; // end namespace two_level_branch_predictor_glue
}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace predictor
}; // end namespace stage_1_ifetch
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
