#ifdef VHDL_TESTBENCH

/*
 * $Id$
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl_Testbench.h"
#include "Include/ErrorMorpheo.h"

namespace morpheo              {
namespace behavioural          {

  void Vhdl_Testbench::generate_file (void)
  {
    _vhdl->set_library_work (_name + "_Pack");

    if (_size_input == 0)
      throw (ErrorMorpheo ("No input for the test bench."));
    if (_size_output == 0)
      throw (ErrorMorpheo ("No output for the test bench."));

    // Only 2 signals and a variable
    _vhdl->set_signal   ("testbench_input"       ,std_logic(_size_input ));
    _vhdl->set_signal   ("testbench_output"      ,std_logic(_size_output));
    _vhdl->set_signal   ("testbench_test"        ,std_logic(_size_output));
    _vhdl->set_signal   ("testbench_must_test"   ,std_logic(1));
    _vhdl->set_signal   ("testbench_counter"     ,"natural","0");

    uint32_t counter = get_input  ();
    get_output ();
    get_test   ();
    get_label  ();

//     if (counter == get_output ())
//       throw (ErrorMorpheo ("The number of input is different of number of output."));

    generate_instance      ();
    generate_process_clock (counter);
    
    _vhdl->generate_file(false, true);
  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
