/*
 * $Id$
 *
 * [Description ]
 * 
 * Parse a Configuration's file and generate the Tree of configuration
 */

#include <stdio.h>
#include <iostream>
#include "message.h"
#include "include/Configuration_files_parser.h"

using namespace std;

// Dclaration de variables globales
extern FILE * yyin;
extern int    yyparse(void);

namespace morpheo       {
namespace configuration {

  class Configuration
  {

    // -----[fields ]----------------------------------------------------
  private : FILE * file;
    
    // -----[methods ]---------------------------------------------------
  public  :      Configuration   (string filename)
  {
    // Open the file in read only
    file = fopen(filename.c_str(), "r");

    // Test if the file is open 
    if (file == NULL)
      {
	cerr_msg << "The file \"" << filename << "\" can't be open" << endl;
	exit (EXIT_FAILURE);
      }
    
    // Parse the file
    yyin = file;
    yyparse();
  }

  public  :      ~Configuration  (void)
  {
    // Close the file
    fclose(file);
  }


  }; // end class Configuration
  
}; // end namespace configuration
}; // end namespace morpheo
