#!/bin/sh

OS_FOUND=`uname -s`-`uname -m | sed -e 's/i[0-9]/iX/' -e 's/sun4./sun4X/'`
case $OS_FOUND in
    "SunOS-sun4X")
	export TARGET_ARCH=gccsparcOS5
	export EXE_SUFFIX=
	;;
    "Linux-iX86")
	export TARGET_ARCH=linux
	export EXE_SUFFIX=
	;;
    "FreeBSD-iX86")
	export TARGET_ARCH=freebsd
	export EXE_SUFFIX=
	;;
    "CYGWIN_NT-5.1-iX86")
	export TARGET_ARCH=cygwin
	export EXE_SUFFIX=.exe
    	;;	
    *) 
     echo "Unknown OS found"
esac

export SOC=$PWD
export PLATFORMS=$SOC/Platforms
export SOFT=$SOC/Softwares
export TOOLS=$SOC/Tools
export IPS=$SOC/IPs/systemC

export PATH=$PATH:$IPS/processor/M_CPU/Script:$TOOLS/or1k/bin:$TOOLS/soclib/tools/bin-$TARGET_ARCH

echo
echo "OS found : $OS_FOUND"
echo ""
echo "SOC         is set to $SOC"
echo "PLATFORMS   is set to $PLATFORMS"
echo "SOFT        is set to $SOFT"
echo "TOOLS       is set to $TOOLS"
echo "IPS         is set to $IPS"
echo
