#ifndef morpheo_behavioural_configuration_Configuration_h
#define morpheo_behavioural_configuration_Configuration_h

/*
 * $Id: Configuration.h 97 2008-12-19 15:34:00Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Simulator.h"
#include "Behavioural/Configuration/include/Generator.h"
#include "Behavioural/Configuration/include/Instance.h"
#include "Behavioural/Custom/include/Custom.h"

#include "Behavioural/include/Usage.h"
#include "Behavioural/include/Parameters_Statistics.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include <iostream>

namespace morpheo {
namespace behavioural {
namespace configuration {

  class Configuration 
  {
    // -----[ fields ]----------------------------------------------------
  private : std::string _name;
  private : Simulator * _simulator;
  private : Generator * _generator;
  private : Instance  * _instance ;

  private : Parameters * _param;
  private : morpheo::behavioural::Parameters_Statistics * _param_statistics;

  private : Tusage_t                                      _usage;
    
    // -----[ methods ]---------------------------------------------------
  public   :                      Configuration  (std::string filename_simulator, 
                                                  std::string filename_generator, 
                                                  std::string filename_instance ,
                                                  behavioural::custom::custom_information_t (*get_custom_information) (void));
  public   :                     ~Configuration  ();

  public   : std::string                                   header             (void);
  public   : std::string                                   getName            (void);
  public   : Tusage_t                                      getUsage           (void);
  public   : Parameters                                  * getParam           (void);
  public   : morpheo::behavioural::Parameters_Statistics * getParamStatistics (void);

  public   : void                 toFile         (std::string dirname=".");
  public   : friend std::ostream& operator<<     (std::ostream& output,
                                                  morpheo::behavioural::configuration::Configuration & x);
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
