#ifdef SYSTEMC
/*
 * $Id: Stat_List_unit_genMoore.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Stat_List_unit/include/Stat_List_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace stat_list_unit {


#undef  FUNCTION
#define FUNCTION "Stat_List_unit::genMoore"
  void Stat_List_unit::genMoore (void)
  {
    log_begin(Stat_List_unit,FUNCTION);
    log_function(Stat_List_unit,FUNCTION,_name.c_str());

    uint32_t gpr_ptr = internal_GPR_PTR_FREE;
    uint32_t spr_ptr = internal_SPR_PTR_FREE;

    for (uint32_t i=0; i<_param->_nb_reg_free; i++)
      {
	uint32_t offset  = i*_param->_nb_bank_by_port_free;

	// PUSH_GPR
	{
	  uint32_t bank_gpr;
	  
	  for (bank_gpr=offset; bank_gpr<offset+_param->_nb_bank_by_port_free; bank_gpr++)
	    if (gpr_stat_list[bank_gpr][gpr_ptr].can_free())
	      break;
	  
	  bool val = (bank_gpr != offset+_param->_nb_bank_by_port_free);
	  
	  internal_PUSH_GPR_VAL      [i] = val;
	  internal_PUSH_GPR_NUM_BANK [i] = bank_gpr;

	  PORT_WRITE(out_PUSH_GPR_VAL [i], val);
	  if (val)
	    PORT_WRITE(out_PUSH_GPR_NUM_REG[i], ((bank_gpr<<_param->_shift_gpr) | gpr_ptr));
	}

	// PUSH_SPR
	{
	  uint32_t bank_spr;
	  
	  for (bank_spr=offset; bank_spr<offset+_param->_nb_bank_by_port_free; bank_spr++)
	    if (spr_stat_list[bank_spr][spr_ptr].can_free())
	      break;

	  bool val = (bank_spr != (offset+_param->_nb_bank_by_port_free));
	  
	  internal_PUSH_SPR_VAL      [i] = val;
	  internal_PUSH_SPR_NUM_BANK [i] = bank_spr;

	  PORT_WRITE(out_PUSH_SPR_VAL [i], val);
	  if (val)
	    PORT_WRITE(out_PUSH_SPR_NUM_REG[i], ((bank_spr<<_param->_shift_spr) | spr_ptr));
	}
      }
    
    log_end(Stat_List_unit,FUNCTION);
  };

}; // end namespace stat_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
