#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_Direction_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_Direction_h

/*
 * $Id: Direction.h 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Direction_Glue/include/Direction_Glue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

  class Direction 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_VAL        ;
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_ACK        ;
  public    : SC_IN (Taddress_t)           **  in_PREDICT_ADDRESS_SRC;
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_STATIC     ;
  public    : SC_IN (Tcontrol_t)           **  in_PREDICT_LAST_TAKE  ;
  public    : SC_OUT(Thistory_t)           ** out_PREDICT_HISTORY    ;
  public    : SC_OUT(Tcontrol_t)           ** out_PREDICT_DIRECTION  ;

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_UPDATE_VAL        ;
  public    : SC_OUT(Tcontrol_t)           ** out_UPDATE_ACK        ;
  public    : SC_IN (Taddress_t)           **  in_UPDATE_ADDRESS    ;
  public    : SC_IN (Thistory_t)           **  in_UPDATE_HISTORY    ;
  public    : SC_IN (Tcontrol_t)           **  in_UPDATE_DIRECTION  ;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  public    : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::direction_glue::Direction_Glue * _component_glue;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Direction);
#endif
  public  :          Direction              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Direction             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void        transition                (void);
# endif					       
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
