/*
 * $Id: Dcache_Access_deallocation.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Dcache_Access/include/Dcache_Access.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace dcache_access {


#undef  FUNCTION
#define FUNCTION "Dcache_Access::deallocation"
  void Dcache_Access::deallocation (void)
  {
    log_begin(Dcache_Access,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;
	
        DELETE1_SIGNAL(out_DCACHE_REQ_VAL         ,_param->_nb_dcache_port,1);
        DELETE1_SIGNAL( in_DCACHE_REQ_ACK         ,_param->_nb_dcache_port,1);
        DELETE1_SIGNAL(out_DCACHE_REQ_THREAD_ID   ,_param->_nb_dcache_port,_param->_size_dcache_thread_id);
        DELETE1_SIGNAL(out_DCACHE_REQ_PACKET_ID   ,_param->_nb_dcache_port,_param->_size_dcache_packet_id);
        DELETE1_SIGNAL(out_DCACHE_REQ_ADDRESS     ,_param->_nb_dcache_port,_param->_size_address);
        DELETE1_SIGNAL(out_DCACHE_REQ_WDATA       ,_param->_nb_dcache_port,_param->_size_data);
        DELETE1_SIGNAL(out_DCACHE_REQ_TYPE        ,_param->_nb_dcache_port,_param->_size_dcache_type);

        DELETE1_SIGNAL( in_DCACHE_RSP_VAL         ,_param->_nb_dcache_port,1);
        DELETE1_SIGNAL(out_DCACHE_RSP_ACK         ,_param->_nb_dcache_port,1);
        DELETE1_SIGNAL( in_DCACHE_RSP_THREAD_ID   ,_param->_nb_dcache_port,_param->_size_dcache_thread_id);
        DELETE1_SIGNAL( in_DCACHE_RSP_PACKET_ID   ,_param->_nb_dcache_port,_param->_size_dcache_packet_id);
        DELETE1_SIGNAL( in_DCACHE_RSP_RDATA       ,_param->_nb_dcache_port,_param->_size_data);
        DELETE1_SIGNAL( in_DCACHE_RSP_ERROR       ,_param->_nb_dcache_port,_param->_size_dcache_error);

        DELETE3_SIGNAL( in_LSQ_REQ_VAL            ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2],1);
        DELETE3_SIGNAL(out_LSQ_REQ_ACK            ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2],1);
        DELETE3_SIGNAL( in_LSQ_REQ_THREAD_ID      ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2],_param->_size_thread_id [it1][it2]);
        DELETE3_SIGNAL( in_LSQ_REQ_PACKET_ID      ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2],_param->_size_packet_id [it1][it2]);
        DELETE3_SIGNAL( in_LSQ_REQ_ADDRESS        ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2],_param->_size_address             );
        DELETE3_SIGNAL( in_LSQ_REQ_WDATA          ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2],_param->_size_data                );
        DELETE3_SIGNAL( in_LSQ_REQ_TYPE           ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2],_param->_size_dcache_type         );

        DELETE3_SIGNAL(out_LSQ_RSP_VAL            ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2],1);
        DELETE3_SIGNAL( in_LSQ_RSP_ACK            ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2],1);
        DELETE3_SIGNAL(out_LSQ_RSP_THREAD_ID      ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2],_param->_size_thread_id [it1][it2]);
        DELETE3_SIGNAL(out_LSQ_RSP_PACKET_ID      ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2],_param->_size_packet_id [it1][it2]);
        DELETE3_SIGNAL(out_LSQ_RSP_RDATA          ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2],_param->_size_data                );
        DELETE3_SIGNAL(out_LSQ_RSP_ERROR          ,_param->_nb_execute_loop, _param->_nb_load_store_unit[it1], _param->_nb_cache_access[it1][it2],_param->_size_dcache_error        );

        // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#ifdef STATISTICS
        delete [] _internal_DCACHE_REQ_NB_ACCESS        ;
        delete [] _internal_DCACHE_REQ_NB_ACCESS_CONFLIT;
#endif
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete _priority;

    delete _component;

    log_end(Dcache_Access,FUNCTION);
  };

}; // end namespace dcache_access
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
