/*
 * $Id: Parameters_msg_error.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Icache_Access/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace icache_access {


#undef  FUNCTION
#define FUNCTION "Icache_Access::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_begin(Icache_Access,FUNCTION);

    Parameters_test test ("Icache_Access");

    bool have_link [_nb_icache_port];
    for (uint32_t i=0; i<_nb_icache_port; i++)
      have_link [i] = 0;

    for (uint32_t i=0; i<_nb_front_end; i++)
      for (uint32_t j=0; j<_nb_context [i]; j++)
	if (_table_routing [i][j] >= _nb_icache_port)
	  test.error(toString(_("table_routing [%d][%d] : invalid value, must be < nb_icache_port.\n"),i,j));
	else
	  have_link [_table_routing [i][j]] = true;

    for (uint32_t i=0; i<_nb_icache_port; i++)
      if (not have_link [i])
	test.error(toString(_("Port[%d] is not linked.\n"),i));

    bool thread_link [_nb_thread];
    for (uint32_t i=0; i<_nb_thread; ++i)
      thread_link [i] = false;
    
    for (uint32_t i=0; i<_nb_front_end; i++)
      for (uint32_t j=0; j<_nb_context [i]; j++)
        {
          uint32_t num_thread = _translate_context_to_thread [i][j];
          if (num_thread >= _nb_thread)
            test.error(toString(_("Context [%d][%d] is linked with an invalid thread id.\n"),i,j));
          else
            if (thread_link [num_thread] == true)
              test.error(toString(_("Context [%d][%d] is linked with an already used thread id.\n"),i,j));
            else
              thread_link [num_thread] = true;
        }

    for (uint32_t i=0; i<_nb_thread; ++i)
      if (not thread_link [i])
        test.error(toString(_("Thread [%d] is not linked.\n"),i));

    log_end(Icache_Access,FUNCTION);

    return test;
  };

}; // end namespace icache_access
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
