 #ifdef VHDL
/*
 * $Id: Write_queue_vhdl_declaration.cpp 103 2009-01-16 16:55:32Z moulu $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Write_queue/include/Write_queue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace write_queue {


#undef  FUNCTION
#define FUNCTION "Write_queue::vhdl_declaration"
  void Write_queue::vhdl_declaration (Vhdl * & vhdl)
  {
    log_printf(FUNC,Write_queue,FUNCTION,"Begin");

    vhdl->set_alias  ("sig_QUEUE_INSERT_VAL     ",1," in_WRITE_QUEUE_IN_VAL",std_logic_range(1));
    vhdl->set_alias  ("sig_QUEUE_INSERT_ACK     ",1,"out_WRITE_QUEUE_IN_ACK",std_logic_range(1));
    vhdl->set_signal ("sig_QUEUE_INSERT_DATA    ",_param->_size_internal_queue);
    vhdl->set_signal ("sig_QUEUE_RETIRE_DATA    ",_param->_size_internal_queue);
    vhdl->set_signal ("sig_QUEUE_RETIRE_VAL     ",1);
    vhdl->set_signal ("sig_QUEUE_RETIRE_ACK     ",1);
    for (uint32_t i=0; i<_param->_nb_bypass_write; i++)
      {
        vhdl->set_signal ("sig_QUEUE_SLOT_"+toString(i)+"_VAL",1);
        vhdl->set_signal ("sig_QUEUE_SLOT_"+toString(i)+"_DATA",_param->_size_internal_queue);
      }
    for (uint32_t i=0; i<_param->_nb_bypass_write; i++)
      {
        vhdl->set_signal ("sig_BYPASS_WRITE_"+toString(i)+"_GPR_VAL",1);
        vhdl->set_signal ("sig_BYPASS_WRITE_"+toString(i)+"_SPR_VAL",1);
      }

    vhdl->set_signal ("sig_GPR_WRITE_0_VAL",1);
    vhdl->set_signal ("sig_SPR_WRITE_0_VAL",1);
    vhdl->set_signal ("sig_DELETE_QUEUE_FRONT",1);
    vhdl->set_signal ("sig_WRITE_QUEUE_OUT_VAL",1);
    vhdl->set_signal ("reg_GPR_WRITE",1);
    vhdl->set_signal ("reg_SPR_WRITE",1);
    vhdl->set_signal ("sig_GPR_WRITE",1);
    vhdl->set_signal ("sig_SPR_WRITE",1);
    vhdl->set_signal ("reg_UPDATE",1);

    uint32_t min = 0;
    uint32_t max, size;
    uint32_t min_ooo, max_ooo;
    uint32_t pos_write_rd, min_gpr_num_reg, max_gpr_num_reg, min_gpr_data, max_gpr_data;
    uint32_t pos_write_re, min_spr_num_reg, max_spr_num_reg, min_spr_data, max_spr_data;

    if(_param->_have_port_context_id   )
      {
        size = _param->_size_context_id;
        max = min-1+size;
        vhdl->set_alias ("sig_WRITE_QUEUE_OUT_CONTEXT_ID           ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
        min = max+1;
      }
    if(_param->_have_port_front_end_id   )
      {
        size = _param->_size_front_end_id;
        max = min-1+size;
        vhdl->set_alias ("sig_WRITE_QUEUE_OUT_FRONT_END_ID         ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
        min = max+1;
      }
    if(_param->_have_port_ooo_engine_id   )
      {
        size = _param->_size_ooo_engine_id;
        max = min-1+size;
        vhdl->set_alias ("sig_WRITE_QUEUE_OUT_OOO_ENGINE_ID        ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
        vhdl->set_alias ("sig_GPR_WRITE_0_OOO_ENGINE_ID        ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
        vhdl->set_alias ("sig_SPR_WRITE_0_OOO_ENGINE_ID        ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
        min_ooo = min;
        max_ooo = max;
        min = max+1;
      }
    if(_param->_have_port_rob_ptr)
      {
        size = _param->_size_rob_ptr;
        max = min-1+size;
        vhdl->set_alias ("sig_WRITE_QUEUE_OUT_PACKET_ID            ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
        min = max+1;
      }

    size = 1;
    max = min-1+size;
    vhdl->set_alias ("sig_WRITE_RD                         ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    pos_write_rd = max;
    min = max+1;

    size = _param->_size_general_register;
    max = min-1+size;
    vhdl->set_alias ("sig_GPR_WRITE_0_NUM_REG                 ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min_gpr_num_reg = min;
    max_gpr_num_reg = max;
    min = max+1;

    size = _param->_size_general_data;
    max = min-1+size;
    vhdl->set_alias ("sig_GPR_WRITE_0_DATA                 ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    vhdl->set_alias ("sig_WRITE_QUEUE_OUT_DATA                 ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min_gpr_data = min;
    max_gpr_data = max;
    min = max+1;

    size = 1;
    max = min-1+size;
    vhdl->set_alias ("sig_WRITE_RE                 ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    pos_write_re = max;
    min = max+1;

    size = _param->_size_special_register;
    max = min-1+size;
    vhdl->set_alias ("sig_SPR_WRITE_0_NUM_REG                 ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min_spr_num_reg = min;
    max_spr_num_reg = max;
    min = max+1;

    size = _param->_size_special_data;
    max = min-1+size;
    vhdl->set_alias ("sig_SPR_WRITE_0_DATA                 ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    vhdl->set_alias ("sig_WRITE_QUEUE_OUT_FLAGS                 ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min_spr_data = min;
    max_spr_data = max;
    min = max+1;

    size = _param->_size_exception;    
    max = min-1+size;
    vhdl->set_alias ("sig_WRITE_QUEUE_OUT_EXCEPTION            ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = 1;
    max = min-1+size;
    vhdl->set_alias ("sig_WRITE_QUEUE_OUT_NO_SEQUENCE          ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    size = _param->_size_instruction_address;
    max = min-1+size;
    vhdl->set_alias ("sig_WRITE_QUEUE_OUT_ADDRESS              ",std_logic(size),"sig_QUEUE_RETIRE_DATA",std_logic_range(_param->_size_internal_queue,max,min));
    min = max+1;

    for (uint32_t i=0; i<_param->_nb_bypass_write; i++)
      {
        if(_param->_have_port_ooo_engine_id)
        vhdl->set_alias ("sig_BYPASS_WRITE_"+toString(i)+"_OOO_ENGINE_ID",std_logic(_param->_size_ooo_engine_id),"sig_QUEUE_SLOT_"+toString(i)+"_DATA",std_logic_range(_param->_size_internal_queue,max_ooo,min_ooo));
        vhdl->set_alias ("sig_BYPASS_WRITE_"+toString(i)+"_GPR_NUM_REG",std_logic(_param->_size_general_register),"sig_QUEUE_SLOT_"+toString(i)+"_DATA",std_logic_range(_param->_size_internal_queue,max_gpr_num_reg,min_gpr_num_reg));
        vhdl->set_alias ("sig_BYPASS_WRITE_"+toString(i)+"_GPR_DATA",std_logic(_param->_size_general_data),"sig_QUEUE_SLOT_"+toString(i)+"_DATA",std_logic_range(_param->_size_internal_queue,max_gpr_data,min_gpr_data));
        vhdl->set_alias ("sig_BYPASS_WRITE_"+toString(i)+"_SPR_NUM_REG",std_logic(_param->_size_special_register),"sig_QUEUE_SLOT_"+toString(i)+"_DATA",std_logic_range(_param->_size_internal_queue,max_spr_num_reg,min_spr_num_reg));
        vhdl->set_alias ("sig_BYPASS_WRITE_"+toString(i)+"_SPR_DATA",std_logic(_param->_size_special_data),"sig_QUEUE_SLOT_"+toString(i)+"_DATA",std_logic_range(_param->_size_internal_queue,max_spr_data,min_spr_data));

        vhdl->set_alias ("sig_BYPASS_WRITE_"+toString(i)+"_WRITE_RD",std_logic(1),"sig_QUEUE_SLOT_"+toString(i)+"_DATA",std_logic_range(_param->_size_internal_queue,pos_write_rd,pos_write_rd));
        vhdl->set_alias ("sig_BYPASS_WRITE_"+toString(i)+"_WRITE_RE",std_logic(1),"sig_QUEUE_SLOT_"+toString(i)+"_DATA",std_logic_range(_param->_size_internal_queue,pos_write_re,pos_write_re));
      }

    log_printf(FUNC,Write_queue,FUNCTION,"End");
  };

}; // end namespace write_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
