/*
 * $Id: Meta_Predictor_Glue_allocation.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Meta_Predictor_Glue.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {
namespace meta_predictor_glue {



#undef  FUNCTION
#define FUNCTION "Meta_Predictor_Glue::allocation"
  void Meta_Predictor_Glue::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_begin(Meta_Predictor_Glue,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Meta_Predictor_Glue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("predict",IN,NORTH,_("Predict next address"),_param->_nb_inst_predict);

      ALLOC1_SIGNAL_IN ( in_PREDICT_VAL                    ,"VAL"          ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_PREDICT_ACK                    ,"ACK"          ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_PREDICT_HISTORY                ,"HISTORY"      ,Thistory_t,_param->_size_history);
      ALLOC1_SIGNAL_OUT(out_PREDICT_DIRECTION              ,"DIRECTION"    ,Tcontrol_t,1);
    }

    {
      ALLOC2_INTERFACE("predict_predictor",IN,NORTH,_("Predict next address"),_param->_nb_predictor,_param->_nb_inst_predict);
      
      ALLOC2_SIGNAL_OUT(out_PREDICT_PREDICTOR_VAL          ,"VAL"          ,Tcontrol_t,1);
      ALLOC2_SIGNAL_IN ( in_PREDICT_PREDICTOR_ACK          ,"ACK"          ,Tcontrol_t,1);
      ALLOC2_SIGNAL_IN ( in_PREDICT_PREDICTOR_HISTORY      ,"HISTORY"      ,Thistory_t,_param->_predictor_size_history[it1]);
      ALLOC2_SIGNAL_IN ( in_PREDICT_PREDICTOR_DIRECTION    ,"DIRECTION"    ,Tcontrol_t,1);
      ALLOC2_SIGNAL_OUT(out_PREDICT_PREDICTOR_DIRECTION_VAL,"DIRECTION_VAL",Tcontrol_t,(_param->_predictor_update_on_prediction [it1])?1:0);
      ALLOC2_SIGNAL_OUT(out_PREDICT_PREDICTOR_DIRECTION    ,"DIRECTION"    ,Tcontrol_t,(_param->_predictor_update_on_prediction [it1])?1:0);
    }

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("update",IN,NORTH,_("Update predictor"),_param->_nb_inst_update);
      
      ALLOC1_SIGNAL_IN ( in_UPDATE_VAL                     ,"VAL"          ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_UPDATE_ACK                     ,"ACK"          ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_UPDATE_HISTORY                 ,"HISTORY"      ,Thistory_t,_param->_size_history);
      ALLOC1_SIGNAL_IN ( in_UPDATE_DIRECTION               ,"DIRECTION"    ,Tcontrol_t,1);
    }
    {
      ALLOC2_INTERFACE("update_predictor",IN,NORTH,_("Update predictor"),_param->_nb_predictor,_param->_nb_inst_update);
      
      ALLOC2_SIGNAL_OUT(out_UPDATE_PREDICTOR_VAL           ,"VAL"          ,Tcontrol_t,1);
      ALLOC2_SIGNAL_IN ( in_UPDATE_PREDICTOR_ACK           ,"ACK"          ,Tcontrol_t,1);
      ALLOC2_SIGNAL_OUT(out_UPDATE_PREDICTOR_HISTORY       ,"HISTORY"      ,Thistory_t,_param->_predictor_size_history[it1]);
      ALLOC2_SIGNAL_OUT(out_UPDATE_PREDICTOR_DIRECTION     ,"DIRECTION"    ,Tcontrol_t,1);
      ALLOC2_SIGNAL_OUT(out_UPDATE_PREDICTOR_MISS          ,"MISS"         ,Tcontrol_t,(_param->_predictor_update_on_prediction [it1])?1:0);
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
	_component->generate_file();
#endif

    log_end(Meta_Predictor_Glue,FUNCTION);
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
