/******************************************************/
/*                                                    */
/*  this class creates the application windows :      */
/*  - the main window where composants are drawn,     */
/*  - the parameters window,                          */
/*  - and the informations window.                    */
/*                                                    */
/******************************************************/


#ifndef WINDOW_H
#define WINDOW_H


#include <iostream>
#include <cmath>
#include <sstream>
#include <qstring.h>
#include <qapplication.h>
#include <qmetaobject.h>
#include <qmenu.h>
#include <qmenubar.h>
#include <qmainwindow.h>
#include <qwidget.h>
#include <qboxlayout.h> 
#include <qpainter.h>
#include <qcolor.h>
#include <qlabel.h>
#include <qstatusbar.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qlineedit.h>
#include <qwindowsstyle.h>
#include <qplastiquestyle.h>
#include <qlist.h>
#include <qrect.h>
#include <string.h>
#include <qtreeview.h>
#include <qdirmodel.h>
#include <qevent.h>
#include <qfiledialog.h>
#include <qscrollarea.h>
#include <qcombobox.h>
#include <qspinbox.h>

#include "Tools/Viewer/Parser/include/parser.h"


#define NORTH 0
#define SOUTH 1
#define EAST 2
#define WEST 3

#define MARGEX 50
#define MARGEY 70

using namespace morpheo::tools::viewer::parser;
using namespace morpheo::tools::viewer::bdd;
using namespace std;

namespace morpheo{
  namespace tools{
    namespace viewer{
      namespace graphics{

class Window : public QMainWindow
{
  
  Q_OBJECT

 public:

  Window(QString name);
  void _setParse(Parse *p);  //parse the base
  void _init_file();    //search component and port before drawing

 private slots:
    
  void _open(); //open a file
  void _open_error();

  void _save(); //save a file
  void _saveAs();
  void _saveAsOk();

  void _close(); //close a file

  void _quit(); //quit a file
  void _quit2();

  void _zoomIn(); //zoom for the architecture view
  void _zoomOut();
  void _defautZoom();

  void _level();
  void _informations(); //show or hide informations window
  void _parameters(); //show or hide parameters window
  void _about(); //about the programm
  void _component_name(); //show or hide the components name
  void _signal_name(); //show or hide the signals name

  void _back();//return to the previous view
  void _cancel_selection();//cancel the selection of a component
  void _apply();//apply the parameters changes 
  void currentIndexChanged(QString s);
  void valueChanged(int i);

 protected :
   void mousePressEvent (QMouseEvent *); //mouse handler when mouse pressed
   void mouseMoveEvent (QMouseEvent *); //mouse handler in other case
 private :
  void wparameters(); // parameters window builder
  void winformations(); //informations window builder
  void paintEvent( QPaintEvent * ); //drawing panel
  void repaint(); //repaint the panel with current parameters
  void drawPort(int x,int y,int pos,string dir); //draw the components ports
  void write_name(string type,string name); //write the name of the component clicked name in the informations window
  void write_comment(string comment);
  void write_type(string t);
  void erase_line(QLabel *l1, QLabel *l2);//erase a line in the informations window
  void erase_comment();//erase and hide the comment line in the informations window
  void display_param();//display the parameters

  QList <Port> port_east; //ports lists
  QList <Port> port_west;
  QList <Port> port_north;
  QList <Port> port_south;
  QList <Component> *compo;//component list
  QList <Param> param;//parameters list
  QList <Group> *group;//groups list

  QWidget *wscroll;
  QMainWindow *wparam;//windows widget (informations, parameters, quit, open)
  QWidget *winfo;
  QWidget *wq;
  QWidget *wa;

  QWidget *mess_charg;
  QWidget *mess;
  QBoxLayout *informations; //informations box
  QBoxLayout *parameters; //parameters box
  QBoxLayout *pbox;

  Parse *parse; //the parser
  BaseV *base; //the current BaseV
  BaseP p; //the current BaseP
  Entity *entity; //entity of current base
  Coord *c; 
 
  QPainter painter;

  QStatusBar *status;//status bar 

  QLineEdit *file_name; //retrieve the name user wants to open from the open window
  QString current_name; //name of the current file opened

  /*items of the informations window*/
  QLabel *lname;//name of the component clicked
  QLabel *ln;
  QLineEdit *comment;//comment associated with the component clicked
  QLabel *lt;
  QLabel *ltype;//type of the component
  
  int level; //level of architecture
  int mouseX; //mouse position
  int mouseY;

  int window_height; //main window size
  int window_width;
  int portX;//port size, position and size of components, used when drawing the architecture
  int portY;
  int posX;//used to retrieve the position and the size of a component
  int posY;
  int tailleX;
  int tailleY;

  int cpt_level;//level in the architecture
  QString tab[20];//save the father when user change the level

  QString father;//father name
  QString current;//name of the current architecture visible

  QScrollArea *sc;

  bool save_as; 
  bool info_open; //know if the informations window opened or not
  bool param_open; //know if the parameters window opened or not
  bool is_save; //know if the file has been saved
  bool paint; //(re)paint or not
  bool wq_open; //know if Quit/Open ( 2 windows possible)/Save window is open
  bool wa_open;
  bool quit_demand;//know if user clicked on "quit" (used for saving file before quit)
  bool file_open;//know if a file is still open (used if user wants to open another file)
  bool signalName;//show or hide signals name
  bool componentName;//show or hide components name
  bool charg_open;//back chargement message box opened or not
  bool mess_open;//chargment message box opened or not
  bool component_clicked;//if user clicked on a component to modify its parameters
  bool apply_display;//if the apply button is displayed
  bool scroll_hide;
  bool parameter_modify;
};
      };
    };
  };
};

#endif
