/*
 * $Id: Decod_deallocation.cpp 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/include/Decod.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {


#undef  FUNCTION
#define FUNCTION "Decod::deallocation"
  void Decod::deallocation (void)
  {
    log_printf(FUNC,Decod,FUNCTION,"Begin");

    if (_usage & USE_SYSTEMC)
      {
	delete    in_CLOCK ;
	delete    in_NRESET;
      
        DELETE2_SIGNAL( in_IFETCH_VAL        , _param->_nb_context, _param->_nb_inst_fetch[it1],1);
        DELETE2_SIGNAL(out_IFETCH_ACK        , _param->_nb_context, _param->_nb_inst_fetch[it1],1);
        DELETE2_SIGNAL( in_IFETCH_INSTRUCTION, _param->_nb_context, _param->_nb_inst_fetch[it1],_param->_size_instruction);
      
        DELETE1_SIGNAL(in_IFETCH_CONTEXT_ID                 , _param->_nb_context,_param->_size_context_id      );
        DELETE1_SIGNAL(in_IFETCH_ADDRESS                    , _param->_nb_context,_param->_size_instruction_address    );
//      DELETE1_SIGNAL(in_IFETCH_ADDRESS_NEXT               , _param->_nb_context,_param->_size_instruction_address    );
        DELETE1_SIGNAL(in_IFETCH_INST_IFETCH_PTR            , _param->_nb_context,_param->_size_inst_ifetch_ptr );
        DELETE1_SIGNAL(in_IFETCH_BRANCH_STATE               , _param->_nb_context,_param->_size_branch_state    );
        DELETE1_SIGNAL(in_IFETCH_BRANCH_UPDATE_PREDICTION_ID, _param->_nb_context,_param->_size_depth           );
        DELETE1_SIGNAL(in_IFETCH_EXCEPTION                  , _param->_nb_context,_param->_size_exception_ifetch);

        DELETE1_SIGNAL(out_DECOD_VAL          ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL( in_DECOD_ACK          ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL(out_DECOD_CONTEXT_ID   ,_param->_nb_inst_decod,_param->_size_context_id            );
        DELETE1_SIGNAL(out_DECOD_DEPTH        ,_param->_nb_inst_decod,_param->_size_depth                 );
        DELETE1_SIGNAL(out_DECOD_TYPE         ,_param->_nb_inst_decod,_param->_size_type                  );
        DELETE1_SIGNAL(out_DECOD_OPERATION    ,_param->_nb_inst_decod,_param->_size_operation             );
        DELETE1_SIGNAL(out_DECOD_NO_EXECUTE   ,_param->_nb_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_IS_DELAY_SLOT,_param->_nb_inst_decod,1                                   );
#ifdef DEBUG
        DELETE1_SIGNAL(out_DECOD_ADDRESS      ,_param->_nb_inst_decod,_param->_size_instruction_address   );
#endif
        DELETE1_SIGNAL(out_DECOD_ADDRESS_NEXT ,_param->_nb_inst_decod,_param->_size_instruction_address   );
        DELETE1_SIGNAL(out_DECOD_HAS_IMMEDIAT ,_param->_nb_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_IMMEDIAT     ,_param->_nb_inst_decod,_param->_size_general_data          );
        DELETE1_SIGNAL(out_DECOD_READ_RA      ,_param->_nb_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_NUM_REG_RA   ,_param->_nb_inst_decod,_param->_size_general_register_logic);
        DELETE1_SIGNAL(out_DECOD_READ_RB      ,_param->_nb_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_NUM_REG_RB   ,_param->_nb_inst_decod,_param->_size_general_register_logic);
        DELETE1_SIGNAL(out_DECOD_READ_RC      ,_param->_nb_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_NUM_REG_RC   ,_param->_nb_inst_decod,_param->_size_special_register_logic);
        DELETE1_SIGNAL(out_DECOD_WRITE_RD     ,_param->_nb_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_NUM_REG_RD   ,_param->_nb_inst_decod,_param->_size_general_register_logic);
        DELETE1_SIGNAL(out_DECOD_WRITE_RE     ,_param->_nb_inst_decod,1                                   );
        DELETE1_SIGNAL(out_DECOD_NUM_REG_RE   ,_param->_nb_inst_decod,_param->_size_special_register_logic);
        DELETE1_SIGNAL(out_DECOD_EXCEPTION_USE,_param->_nb_inst_decod,_param->_size_exception_use         );
        DELETE1_SIGNAL(out_DECOD_EXCEPTION    ,_param->_nb_inst_decod,_param->_size_exception_decod       );

        DELETE1_SIGNAL(out_PREDICT_VAL                        ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL( in_PREDICT_ACK                        ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL(out_PREDICT_CONTEXT_ID                 ,_param->_nb_inst_decod,_param->_size_context_id      );
        DELETE1_SIGNAL(out_PREDICT_MATCH_INST_IFETCH_PTR      ,_param->_nb_inst_decod,1                             );
        DELETE1_SIGNAL(out_PREDICT_BRANCH_STATE               ,_param->_nb_inst_decod,_param->_size_branch_state    );
        DELETE1_SIGNAL(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID,_param->_nb_inst_decod,_param->_size_depth           );
        DELETE1_SIGNAL(out_PREDICT_BRANCH_CONDITION           ,_param->_nb_inst_decod,_param->_size_branch_condition);
//      DELETE1_SIGNAL(out_PREDICT_BRANCH_STACK_WRITE         ,_param->_nb_inst_decod,1                             );
        DELETE1_SIGNAL(out_PREDICT_BRANCH_DIRECTION           ,_param->_nb_inst_decod,1                             );
        DELETE1_SIGNAL(out_PREDICT_ADDRESS_SRC                ,_param->_nb_inst_decod,_param->_size_instruction_address    );
        DELETE1_SIGNAL(out_PREDICT_ADDRESS_DEST               ,_param->_nb_inst_decod,_param->_size_instruction_address    );
        DELETE1_SIGNAL( in_PREDICT_CAN_CONTINUE               ,_param->_nb_inst_decod,1                             );

        DELETE1_SIGNAL(in_CONTEXT_DECOD_ENABLE, _param->_nb_context,1);
        DELETE1_SIGNAL(in_CONTEXT_DEPTH_VAL   , _param->_nb_context,1);
        DELETE1_SIGNAL(in_CONTEXT_DEPTH       , _param->_nb_context,_param->_size_depth);

        DELETE_SIGNAL (out_CONTEXT_EVENT_VAL          ,1);
        DELETE_SIGNAL ( in_CONTEXT_EVENT_ACK          ,1);
        DELETE_SIGNAL (out_CONTEXT_EVENT_CONTEXT_ID   ,_param->_size_context_id  );
        DELETE_SIGNAL (out_CONTEXT_EVENT_DEPTH        ,_param->_size_depth       );
        DELETE_SIGNAL (out_CONTEXT_EVENT_TYPE         ,_param->_size_event_type  );
        DELETE_SIGNAL (out_CONTEXT_EVENT_IS_DELAY_SLOT,1                         );
        DELETE_SIGNAL (out_CONTEXT_EVENT_ADDRESS      ,_param->_size_instruction_address);
        DELETE_SIGNAL (out_CONTEXT_EVENT_ADDRESS_EPCR ,_param->_size_instruction_address);


    
        delete    reg_CONTEXT_ADDRESS_PREVIOUS      ;
        delete [] reg_CONTEXT_IS_DELAY_SLOT         ;
        
        delete [] internal_CONTEXT_HAVE_TRANSACTION ;
        delete [] internal_CONTEXT_ADDRESS_PREVIOUS ;
        delete [] internal_CONTEXT_IS_DELAY_SLOT    ;
        
#ifdef STATISTICS
        delete [] internal_DECOD_VAL;
#endif
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete    _priority;


    const uint32_t nb_opcod_type = 14;

    for (uint32_t i=0; i<_param->_nb_context; i++)
      {
	for (uint32_t j=0; j<nb_opcod_type; j++)
	  {
	    delete [] _function_decod  [i][j];
	    delete [] _function_custom [i][j];
	  }
	delete [] _function_decod  [i];
	delete [] _function_custom [i];
      }
    delete [] _function_decod ;
    delete [] _function_custom;
    delete    _decod_instruction;
    delete    _decod_param      ;
    delete    _component;

    log_printf(FUNC,Decod,FUNCTION,"End");
  };

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
