#ifndef morpheo_behavioural_core_multi_front_end_front_end_decod_unit_decod_queue_Types_h
#define morpheo_behavioural_core_multi_front_end_front_end_decod_unit_decod_queue_Types_h

/*
 * $Id: Types.h 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {

  typedef enum 
    {
       DECOD_QUEUE_SCHEME_ONE_FIFO   // One fifo with a instruction bundle per slot (   internal fragmentation)
      ,DECOD_QUEUE_SCHEME_MULTI_FIFO // One fifo per instruction. Rename in order   (no internal fragmentation)
    } Tdecod_queue_scheme_t;

  class decod_queue_entry_t
  {
  private: const uint32_t       _nb_inst        ;

  public : Tcontrol_t         * _val            ;
  public : Tcontext_t         * _context_id     ;
  public : Tdepth_t           * _depth          ;
  public : Ttype_t            * _type           ;
  public : Toperation_t       * _operation      ;
  public : Tcontrol_t         * _no_execute     ;
  public : Tcontrol_t         * _is_delay_slot  ;
#ifdef DEBUG
  public : Tgeneral_data_t    * _address        ;
#endif
  public : Tgeneral_data_t    * _address_next   ;
  public : Tcontrol_t         * _has_immediat   ;
  public : Tgeneral_data_t    * _immediat       ;
  public : Tcontrol_t         * _read_ra        ;
  public : Tgeneral_address_t * _num_reg_ra     ;
  public : Tcontrol_t         * _read_rb        ;
  public : Tgeneral_address_t * _num_reg_rb     ;
  public : Tcontrol_t         * _read_rc        ;
  public : Tspecial_address_t * _num_reg_rc     ;
  public : Tcontrol_t         * _write_rd       ;
  public : Tgeneral_address_t * _num_reg_rd     ;
  public : Tcontrol_t         * _write_re       ;
  public : Tspecial_address_t * _num_reg_re     ;
  public : Texception_t       * _exception_use  ;
  public : Texception_t       * _exception      ;

  public :  decod_queue_entry_t (uint32_t nb_inst):
    _nb_inst (nb_inst)
    {
      _val            = new Tcontrol_t         [_nb_inst];
      _context_id     = new Tcontext_t         [_nb_inst];
      _depth          = new Tdepth_t           [_nb_inst];
      _type           = new Ttype_t            [_nb_inst];
      _operation      = new Toperation_t       [_nb_inst];
      _no_execute     = new Tcontrol_t         [_nb_inst];
      _is_delay_slot  = new Tcontrol_t         [_nb_inst];
#ifdef DEBUG
      _address        = new Tgeneral_data_t    [_nb_inst];
#endif
      _address_next   = new Tgeneral_data_t    [_nb_inst];
      _has_immediat   = new Tcontrol_t         [_nb_inst];
      _immediat       = new Tgeneral_data_t    [_nb_inst];
      _read_ra        = new Tcontrol_t         [_nb_inst];
      _num_reg_ra     = new Tgeneral_address_t [_nb_inst];
      _read_rb        = new Tcontrol_t         [_nb_inst];
      _num_reg_rb     = new Tgeneral_address_t [_nb_inst];
      _read_rc        = new Tcontrol_t         [_nb_inst];
      _num_reg_rc     = new Tspecial_address_t [_nb_inst];
      _write_rd       = new Tcontrol_t         [_nb_inst];
      _num_reg_rd     = new Tgeneral_address_t [_nb_inst];
      _write_re       = new Tcontrol_t         [_nb_inst];
      _num_reg_re     = new Tspecial_address_t [_nb_inst];
      _exception_use  = new Texception_t       [_nb_inst];
      _exception      = new Texception_t       [_nb_inst];

      for (uint32_t i=0; i<_nb_inst; i++)
	_val [i]=0; // default : not valid
    }

  public : ~decod_queue_entry_t (void)
    {
      delete [] _val            ;
      delete [] _context_id     ;
      delete [] _depth          ;
      delete [] _type           ;
      delete [] _operation      ;
      delete [] _no_execute     ;
      delete [] _is_delay_slot  ;
#ifdef DEBUG
      delete [] _address        ;
#endif
      delete [] _address_next   ;
      delete [] _has_immediat   ;
      delete [] _immediat       ;
      delete [] _read_ra        ;
      delete [] _num_reg_ra     ;
      delete [] _read_rb        ;
      delete [] _num_reg_rb     ;
      delete [] _read_rc        ;
      delete [] _num_reg_rc     ;
      delete [] _write_rd       ;
      delete [] _num_reg_rd     ;
      delete [] _write_re       ;
      delete [] _num_reg_re     ;
      delete [] _exception_use  ;
      delete [] _exception      ;
    }
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural

  template<> inline std::string toString<morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Tdecod_queue_scheme_t>(const morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Tdecod_queue_scheme_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::DECOD_QUEUE_SCHEME_ONE_FIFO   : return "one_fifo"  ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::DECOD_QUEUE_SCHEME_MULTI_FIFO : return "multi_fifo"; break;
      default : return ""; break;
      }
  };

  template<> inline morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Tdecod_queue_scheme_t fromString<morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Tdecod_queue_scheme_t>(const std::string& x)
  {
    if ( (x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::DECOD_QUEUE_SCHEME_ONE_FIFO  ))) == 0) or
         (x.compare("one_fifo")   == 0))
      return morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::DECOD_QUEUE_SCHEME_ONE_FIFO;
    if ( (x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::DECOD_QUEUE_SCHEME_MULTI_FIFO))) == 0) or
         (x.compare("multi_fifo") == 0))
      return morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::DECOD_QUEUE_SCHEME_MULTI_FIFO;
    
    throw (ErrorMorpheo ("<fromString> : Unknow string : \""+x+"\""));
  };


}; // end namespace morpheo              

#endif
