#ifdef SYSTEMC
/*
 * $Id: Issue_queue_transition.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Issue_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace issue_queue {


#undef  FUNCTION
#define FUNCTION "Issue_queue::transition"
  void Issue_queue::transition (void)
  {
    log_begin(Issue_queue,FUNCTION);
    log_function(Issue_queue,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET) == 0)
      {
	_priority_in ->reset();
        _reexecute_queue.clear();
      }
    else
      {
	_priority_in ->transition();

	// ===================================================================
	// =====[ REEXECUTE_UNIT ]============================================
	// ===================================================================

        for (uint32_t i=0; i<_param->_nb_inst_reexecute; ++i)
          if (PORT_READ(in_REEXECUTE_VAL [i]) and internal_REEXECUTE_ACK [i])
            {
              log_printf(TRACE,Issue_queue,FUNCTION,"  * REEXECUTE [%d]",i);
#ifdef STATISTICS
              if (usage_is_set(_usage,USE_STATISTICS))
                (*_stat_nb_inst_reexecute) ++;
#endif
              entry_t * entry = new entry_t
                (
                 (_param->_have_port_context_id    )?PORT_READ(in_REEXECUTE_CONTEXT_ID            [i]):0,
                 (_param->_have_port_front_end_id  )?PORT_READ(in_REEXECUTE_FRONT_END_ID          [i]):0,
                 (_param->_have_port_rob_ptr       )?PORT_READ(in_REEXECUTE_PACKET_ID             [i]):0,
			                             PORT_READ(in_REEXECUTE_OPERATION             [i]),
			                             PORT_READ(in_REEXECUTE_TYPE                  [i]),
			                             PORT_READ(in_REEXECUTE_STORE_QUEUE_PTR_WRITE [i]),
                 (_param->_have_port_load_queue_ptr)?PORT_READ(in_REEXECUTE_LOAD_QUEUE_PTR_WRITE  [i]):0,
			                             PORT_READ(in_REEXECUTE_HAS_IMMEDIAT          [i]),
			                             PORT_READ(in_REEXECUTE_IMMEDIAT              [i]),
			                             PORT_READ(in_REEXECUTE_READ_RA               [i]),
			                             PORT_READ(in_REEXECUTE_NUM_REG_RA            [i]),
			                             PORT_READ(in_REEXECUTE_READ_RB               [i]),
			                             PORT_READ(in_REEXECUTE_NUM_REG_RB            [i]),
			                             PORT_READ(in_REEXECUTE_READ_RC               [i]),
			                             PORT_READ(in_REEXECUTE_NUM_REG_RC            [i]),
			                             PORT_READ(in_REEXECUTE_WRITE_RD              [i]),
			                             PORT_READ(in_REEXECUTE_NUM_REG_RD            [i]),
			                             PORT_READ(in_REEXECUTE_WRITE_RE              [i]),
			                             PORT_READ(in_REEXECUTE_NUM_REG_RE            [i])
                 );

              _reexecute_queue.push_back(entry);
            }

	// ===================================================================
	// =====[ ISSUE_OUT ]=================================================
	// ===================================================================

        for (uint32_t i=0; i<_param->_nb_inst_issue; ++i)
          if (internal_ISSUE_OUT_VAL [i] and PORT_READ(in_ISSUE_OUT_ACK [i]))
            {
#ifdef STATISTICS
              if (usage_is_set(_usage,USE_STATISTICS))
                (*_stat_nb_inst_issue_out ) ++;
#endif
              if (internal_ISSUE_OUT_FROM_REEXECUTE [i])
                {
                  entry_t * entry = internal_ISSUE_OUT_ENTRY    [i];
                  
                  log_printf(TRACE,Issue_queue,FUNCTION,"  * ISSUE_OUT [%d] - From Reexecute_queue",i);
                  
                  _reexecute_queue.remove(entry);
                  
                  delete entry;
                }
                // else ... in function specific
            }
      }

    // specific implementation
    (this->*function_transition) ();

    // ===================================================================
    // =====[ PRINT ]====================================================
    // ===================================================================

#if defined(DEBUG) and DEBUG_Issue_queue and (DEBUG >= DEBUG_TRACE)
    log_printf(TRACE,Issue_queue,FUNCTION,"  * Dump Issue_queue");

    for (uint32_t i=0; i<_param->_nb_bank; i++)
      {
	log_printf(TRACE,Issue_queue,FUNCTION,"    * Bank [%d] size : %d",i,(int)_issue_queue[i].size());

        uint32_t j = 0;
        for (std::list<entry_t*>::iterator it=_issue_queue[i].begin();it!=_issue_queue[i].end(); ++it)
          {
            log_printf(TRACE,Issue_queue,FUNCTION,"      [%.4d] %.2d %.2d %.4d, %.2d %.3d, %.2d %.2d, %.1d %.8x, %.1d %.4d, %.1d %.4d, %.1d %.4d, %.1d %.4d, %.1d %.4d",
                       j,
                       
                       (*it)->_context_id           ,
                       (*it)->_front_end_id         ,
                       (*it)->_packet_id            ,
                       
                       (*it)->_type                 ,
                       (*it)->_operation            ,
                       
                       (*it)->_store_queue_ptr_write,
                       (*it)->_load_queue_ptr_write ,
                       
                       (*it)->_has_immediat         ,
                       (*it)->_immediat             ,
                       
                       (*it)->_read_ra              ,
                       (*it)->_num_reg_ra           ,
                       
                       (*it)->_read_rb              ,
                       (*it)->_num_reg_rb           ,
                       
                       (*it)->_read_rc              ,
                       (*it)->_num_reg_rc           ,
                       
                       (*it)->_write_rd             ,
                       (*it)->_num_reg_rd           ,
                       
                       (*it)->_write_re             ,
                       (*it)->_num_reg_re           );
            
                ++j;
              }
      }

    {
      log_printf(TRACE,Issue_queue,FUNCTION,"    * Reexecute_queue - size : %d",(int)_reexecute_queue.size());
      
      uint32_t i = 0;

      for (std::list<entry_t*>::iterator it=_reexecute_queue.begin();it!=_reexecute_queue.end(); ++it)
        {
          log_printf(TRACE,Issue_queue,FUNCTION,"      [%.4d] %.2d %.2d %.4d, %.2d %.3d, %.2d %.2d, %.1d %.8x, %.1d %.4d, %.1d %.4d, %.1d %.4d, %.1d %.4d, %.1d %.4d",
                     i,
                     
                     (*it)->_context_id           ,
                     (*it)->_front_end_id         ,
                     (*it)->_packet_id            ,
                     
                     (*it)->_type                 ,
                     (*it)->_operation            ,
                     
                     (*it)->_store_queue_ptr_write,
                     (*it)->_load_queue_ptr_write ,
                     
                     (*it)->_has_immediat         ,
                     (*it)->_immediat             ,
                     
                     (*it)->_read_ra              ,
                     (*it)->_num_reg_ra           ,
                     
                     (*it)->_read_rb              ,
                     (*it)->_num_reg_rb           ,
                     
                     (*it)->_read_rc              ,
                     (*it)->_num_reg_rc           ,
                     
                     (*it)->_write_rd             ,
                     (*it)->_num_reg_rd           ,
                     
                     (*it)->_write_re             ,
                     (*it)->_num_reg_re           );
          ++i;
        }
    }
#endif

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      for (uint32_t i=0; i<_param->_nb_bank; i++)
        *(_stat_bank_nb_inst [i]) += _issue_queue[i].size();
#endif



#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_end(Issue_queue,FUNCTION);
  };

}; // end namespace issue_queue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
