/*
 * $Id: Generator_test.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Generator.h"

namespace morpheo {
namespace behavioural {
namespace configuration {

#undef  FUNCTION
#define FUNCTION "Generator::test"
  void Generator::test (std::string param, std::string x)
  {
    log_begin(Configuration,FUNCTION);

    std::map<std::string, Parameter_definition *>::iterator it_param = _array_param->find(param);
    
    if (it_param == _array_param->end())
      {
        throw (ERRORMORPHEO(FUNCTION,toString(_("Parameter \"%s\" is unknow.\n"),param.c_str())));
      }
    else
      {
        it_param->second->test(x);    
      }

    log_end(Configuration,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Generator::test"
  void Generator::test (std::string link,
                        std::string father_name,
                        bool        father_is_src,
                        bool        father_is_dest)
  {
    log_begin(Configuration,FUNCTION);

    // Link ?
    std::map<std::string, Link_definition *>::iterator it_link = _array_link->find(link);
    
    if (it_link == _array_link->end())
      {
        throw (ERRORMORPHEO(FUNCTION,toString(_("Link \"%s\" is unknow.\n"),link.c_str())));
      }

    if ((father_is_src ) and
        (father_name != it_link->second->_src ))
      {
        throw (ERRORMORPHEO(FUNCTION,toString(_("Link \"%s\", must be instance as source in component \"%s\", but find in component \"%s\".\n"),link.c_str(),it_link->second->_src.c_str(),father_name.c_str())));
      }

    if ((father_is_dest ) and
        (father_name != it_link->second->_dest ))
      {
        throw (ERRORMORPHEO(FUNCTION,toString(_("Link \"%s\", must be instance as destination in component \"%s\", but find in component \"%s\".\n"),link.c_str(),it_link->second->_dest.c_str(),father_name.c_str())));
      }

    log_end(Configuration,FUNCTION);
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              
