/*
 * $Id: Simulator.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Simulator.h"
#include "Behavioural/include/Stat_binary_tree.h"

namespace morpheo {
namespace behavioural {
namespace configuration {

#undef  FUNCTION
#define FUNCTION "Simulator::Simulator"
  Simulator::Simulator (std::string filename)
  {
    log_begin(Configuration,FUNCTION);

    _filename = filename;
    _array = new std::map<std::string, Parameter_affectation *>;

    fromFile (filename);

    log_end(Configuration,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Simulator::~Simulator"
  Simulator::~Simulator () 
  {
    log_begin(Configuration,FUNCTION);

    for (std::map<std::string, Parameter_affectation *>::iterator it = _array->begin();
         it != _array->end();
         ++it)
      {
        delete it->second;
      }

    delete _array;
    
    log_end(Configuration,FUNCTION);
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              
