#undef  FUNCTION
#define FUNCTION "Reservation_station::"

#ifdef SYSTEMC
/*
 * $Id: Reservation_station_deallocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Reservation_station/include/Reservation_station.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace reservation_station {


#undef  FUNCTION
#define FUNCTION "Reservation_station::deallocation"
  void Reservation_station::deallocation (void)
  {
    log_printf(FUNC,Reservation_station,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
        delete     in_CLOCK ;
        delete     in_NRESET;

        DELETE0_SIGNAL( in_INSERT_VAL                  ,1);
        DELETE0_SIGNAL(out_INSERT_ACK                  ,1);
        DELETE0_SIGNAL( in_INSERT_CONTEXT_ID           ,_param->_size_context_id      );
        DELETE0_SIGNAL( in_INSERT_FRONT_END_ID         ,_param->_size_front_end_id    );
        DELETE0_SIGNAL( in_INSERT_OOO_ENGINE_ID        ,_param->_size_ooo_engine_id   );
        DELETE0_SIGNAL( in_INSERT_ROB_ID               ,_param->_size_rob_ptr         );
        DELETE0_SIGNAL( in_INSERT_OPERATION            ,_param->_size_operation       );
        DELETE0_SIGNAL( in_INSERT_TYPE                 ,_param->_size_type            );
        DELETE0_SIGNAL( in_INSERT_STORE_QUEUE_PTR_WRITE,_param->_size_store_queue_ptr );
        DELETE0_SIGNAL( in_INSERT_LOAD_QUEUE_PTR_WRITE ,_param->_size_load_queue_ptr  );
        DELETE0_SIGNAL( in_INSERT_HAS_IMMEDIAT         ,1                             );
        DELETE0_SIGNAL( in_INSERT_IMMEDIAT             ,_param->_size_general_data    );
//      DELETE0_SIGNAL( in_INSERT_READ_RA              ,1                             );
        DELETE0_SIGNAL( in_INSERT_NUM_REG_RA           ,_param->_size_general_register);
        DELETE0_SIGNAL( in_INSERT_DATA_RA_VAL          ,1                             );
        DELETE0_SIGNAL( in_INSERT_DATA_RA              ,_param->_size_general_data    );
//      DELETE0_SIGNAL( in_INSERT_READ_RB              ,1                             );
        DELETE0_SIGNAL( in_INSERT_NUM_REG_RB           ,_param->_size_general_register);
        DELETE0_SIGNAL( in_INSERT_DATA_RB_VAL          ,1                             );
        DELETE0_SIGNAL( in_INSERT_DATA_RB              ,_param->_size_general_data    );
//      DELETE0_SIGNAL( in_INSERT_READ_RC              ,1                             );
        DELETE0_SIGNAL( in_INSERT_NUM_REG_RC           ,_param->_size_special_register);
        DELETE0_SIGNAL( in_INSERT_DATA_RC_VAL          ,1                             );
        DELETE0_SIGNAL( in_INSERT_DATA_RC              ,_param->_size_special_data    );
        DELETE0_SIGNAL( in_INSERT_WRITE_RD             ,1                             );
        DELETE0_SIGNAL( in_INSERT_NUM_REG_RD           ,_param->_size_general_register);
        DELETE0_SIGNAL( in_INSERT_WRITE_RE             ,1                             );
        DELETE0_SIGNAL( in_INSERT_NUM_REG_RE           ,_param->_size_special_register);
        
        DELETE1_SIGNAL(out_RETIRE_VAL                  ,_param->_nb_inst_retire,1);
        DELETE1_SIGNAL( in_RETIRE_ACK                  ,_param->_nb_inst_retire,1);
        DELETE1_SIGNAL(out_RETIRE_CONTEXT_ID           ,_param->_nb_inst_retire,_param->_size_context_id);
        DELETE1_SIGNAL(out_RETIRE_FRONT_END_ID         ,_param->_nb_inst_retire,_param->_size_front_end_id);
        DELETE1_SIGNAL(out_RETIRE_OOO_ENGINE_ID        ,_param->_nb_inst_retire,_param->_size_ooo_engine_id);
        DELETE1_SIGNAL(out_RETIRE_ROB_ID               ,_param->_nb_inst_retire,_param->_size_rob_ptr);
        DELETE1_SIGNAL(out_RETIRE_OPERATION            ,_param->_nb_inst_retire,_param->_size_operation);
        DELETE1_SIGNAL(out_RETIRE_TYPE                 ,_param->_nb_inst_retire,_param->_size_type);
        DELETE1_SIGNAL(out_RETIRE_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_retire,_param->_size_store_queue_ptr);
        DELETE1_SIGNAL(out_RETIRE_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_retire,_param->_size_load_queue_ptr );
        DELETE1_SIGNAL(out_RETIRE_HAS_IMMEDIAT         ,_param->_nb_inst_retire,1);
        DELETE1_SIGNAL(out_RETIRE_IMMEDIAT             ,_param->_nb_inst_retire,_param->_size_general_data);
        DELETE1_SIGNAL(out_RETIRE_DATA_RA              ,_param->_nb_inst_retire,_param->_size_general_data);
        DELETE1_SIGNAL(out_RETIRE_DATA_RB              ,_param->_nb_inst_retire,_param->_size_general_data);
        DELETE1_SIGNAL(out_RETIRE_DATA_RC              ,_param->_nb_inst_retire,_param->_size_special_data);
        DELETE1_SIGNAL(out_RETIRE_WRITE_RD             ,_param->_nb_inst_retire,1);
        DELETE1_SIGNAL(out_RETIRE_NUM_REG_RD           ,_param->_nb_inst_retire,_param->_size_general_register);
        DELETE1_SIGNAL(out_RETIRE_WRITE_RE             ,_param->_nb_inst_retire,1);
        DELETE1_SIGNAL(out_RETIRE_NUM_REG_RE           ,_param->_nb_inst_retire,_param->_size_special_register);
        
        DELETE1_SIGNAL( in_GPR_WRITE_VAL          ,_param->_nb_gpr_write,1);
        DELETE1_SIGNAL( in_GPR_WRITE_OOO_ENGINE_ID,_param->_nb_gpr_write,_param->_size_ooo_engine_id);
        DELETE1_SIGNAL( in_GPR_WRITE_NUM_REG      ,_param->_nb_gpr_write,_param->_size_general_register);
        DELETE1_SIGNAL( in_GPR_WRITE_DATA         ,_param->_nb_gpr_write,_param->_size_general_data);
        
        DELETE1_SIGNAL( in_SPR_WRITE_VAL          ,_param->_nb_spr_write,1);
        DELETE1_SIGNAL( in_SPR_WRITE_OOO_ENGINE_ID,_param->_nb_spr_write,_param->_size_ooo_engine_id);
        DELETE1_SIGNAL( in_SPR_WRITE_NUM_REG      ,_param->_nb_spr_write,_param->_size_general_register);
        DELETE1_SIGNAL( in_SPR_WRITE_DATA         ,_param->_nb_spr_write,_param->_size_general_data);
        
        DELETE1_SIGNAL( in_BYPASS_WRITE_OOO_ENGINE_ID,_param->_nb_bypass_write,_param->_size_ooo_engine_id);
        DELETE1_SIGNAL( in_BYPASS_WRITE_GPR_VAL      ,_param->_nb_bypass_write,1);
        DELETE1_SIGNAL( in_BYPASS_WRITE_GPR_NUM_REG  ,_param->_nb_bypass_write,_param->_size_general_register);
        DELETE1_SIGNAL( in_BYPASS_WRITE_GPR_DATA     ,_param->_nb_bypass_write,_param->_size_general_data);
        DELETE1_SIGNAL( in_BYPASS_WRITE_SPR_VAL      ,_param->_nb_bypass_write,1);
        DELETE1_SIGNAL( in_BYPASS_WRITE_SPR_NUM_REG  ,_param->_nb_bypass_write,_param->_size_special_register);
        DELETE1_SIGNAL( in_BYPASS_WRITE_SPR_DATA     ,_param->_nb_bypass_write,_param->_size_special_data);
        
        DELETE1_SIGNAL( in_BYPASS_MEMORY_VAL          ,_param->_nb_bypass_memory,1);
        DELETE1_SIGNAL( in_BYPASS_MEMORY_OOO_ENGINE_ID,_param->_nb_bypass_memory,_param->_size_ooo_engine_id);
        DELETE1_SIGNAL( in_BYPASS_MEMORY_NUM_REG      ,_param->_nb_bypass_memory,_param->_size_general_register);
        DELETE1_SIGNAL( in_BYPASS_MEMORY_DATA         ,_param->_nb_bypass_memory,_param->_size_general_data);
        
        DELETE1(internal_RETIRE_VAL ,_param->_nb_inst_retire);
        DELETE1(internal_RETIRE_SLOT,_param->_nb_inst_retire);
      }

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete    _component;
#ifdef  SYSTEMC_VHDL_COMPATIBILITY
    delete [] _queue_valid  ;
#else
    delete    _queue_control;
#endif
    delete [] _queue        ;

    log_printf(FUNC,Reservation_station,FUNCTION,"End");
  };

}; // end namespace reservation_station
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
