/*
 * $Id: main.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/SelfTest/include/test.h"

#define NB_PARAMS 13

void usage (int argc, char * argv[])
{
  cerr << "<Usage> " << argv[0] << " name_instance list_params" << endl
       << "list_params is :" << endl
       << " - nb_ooo_engine                             (uint32_t)" << endl
       << " - size_general_data                         (uint32_t)" << endl
       << " - size_special_data                         (uint32_t)" << endl
       << " - nb_gpr_read                               (uint32_t)" << endl
       << " - nb_gpr_write                              (uint32_t)" << endl
       << " - nb_gpr_bank                               (uint32_t)" << endl
       << " - nb_gpr_port_read_by_bank                  (uint32_t)" << endl
       << " - nb_gpr_port_write_by_bank                 (uint32_t)" << endl
       << " - nb_spr_read                               (uint32_t)" << endl
       << " - nb_spr_write                              (uint32_t)" << endl
       << " - nb_spr_bank                               (uint32_t)" << endl
       << " - nb_spr_port_read_by_bank                  (uint32_t)" << endl
       << " - nb_spr_port_write_by_bank                 (uint32_t)" << endl
       << " - nb_general_register       [nb_ooo_engine] (uint32_t)" << endl 
       << " - nb_special_register       [nb_ooo_engine] (uint32_t)" << endl 
       << " - nb_inst_insert_rob        [nb_ooo_engine] (uint32_t)" << endl 
       << " - nb_inst_retire_rob        [nb_ooo_engine] (uint32_t)" << endl 
       << "" << endl;

  for (int i=0; i<argc; i++)
    cerr << argv[i] << " ";
  cerr << endl;

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc < 2+NB_PARAMS)
    usage (argc, argv);

  const string   name      = argv[1];
//const uint32_t size_data = atoi(argv[2]);
//const uint32_t nb_port   = atoi(argv[3]);
  uint32_t    _nb_ooo_engine             = atoi(argv[ 2]);
  uint32_t    _size_general_data         = atoi(argv[ 3]);
  uint32_t    _size_special_data         = atoi(argv[ 4]);
  uint32_t    _nb_gpr_read               = atoi(argv[ 5]);
  uint32_t    _nb_gpr_write              = atoi(argv[ 6]);
  uint32_t    _nb_gpr_bank               = atoi(argv[ 7]);
  uint32_t    _nb_gpr_port_read_by_bank  = atoi(argv[ 8]);
  uint32_t    _nb_gpr_port_write_by_bank = atoi(argv[ 9]);
  uint32_t    _nb_spr_read               = atoi(argv[10]);
  uint32_t    _nb_spr_write              = atoi(argv[11]);
  uint32_t    _nb_spr_bank               = atoi(argv[12]);
  uint32_t    _nb_spr_port_read_by_bank  = atoi(argv[13]);
  uint32_t    _nb_spr_port_write_by_bank = atoi(argv[14]);
  
  if (argc != 2+NB_PARAMS+static_cast<int>(4*_nb_ooo_engine))
    usage (argc, argv);
  
  uint32_t  * _nb_general_register       = new uint32_t [_nb_ooo_engine];
  uint32_t  * _nb_special_register       = new uint32_t [_nb_ooo_engine];
  uint32_t  * _nb_inst_insert_rob        = new uint32_t [_nb_ooo_engine];
  uint32_t  * _nb_inst_retire_rob        = new uint32_t [_nb_ooo_engine];

  uint32_t    x = 15;

  for (uint32_t i=0; i<_nb_ooo_engine; i++)
    _nb_general_register [i] = atoi(argv[x++]);
  for (uint32_t i=0; i<_nb_ooo_engine; i++)
    _nb_special_register [i] = atoi(argv[x++]);
  for (uint32_t i=0; i<_nb_ooo_engine; i++)
    _nb_inst_insert_rob  [i] = atoi(argv[x++]);
  for (uint32_t i=0; i<_nb_ooo_engine; i++)
    _nb_inst_retire_rob  [i] = atoi(argv[x++]);
  
  try 
    {
      morpheo::behavioural::core::multi_execute_loop::execute_loop::register_unit::Parameters * param = new morpheo::behavioural::core::multi_execute_loop::execute_loop::register_unit::Parameters
	(_nb_ooo_engine             ,
	 _size_general_data         ,
	 _size_special_data         ,
	 _nb_gpr_read               ,
	 _nb_gpr_write              ,
	 _nb_gpr_bank               ,
	 _nb_gpr_port_read_by_bank  ,
	 _nb_gpr_port_write_by_bank ,
	 _nb_spr_read               ,
	 _nb_spr_write              ,
	 _nb_spr_bank               ,
	 _nb_spr_port_read_by_bank  ,
	 _nb_spr_port_write_by_bank ,
	 _nb_general_register       ,
	 _nb_special_register       ,
	 _nb_inst_insert_rob        ,
	 _nb_inst_retire_rob        ,
         true //is_toplevel
         );
      
      cout << param->print(1);
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      cout << "<" << name << "> : " <<  error.what ();
      exit (EXIT_FAILURE);
    }
  catch (...)
    {
      cerr << "<" << name << "> : This test must generate a error" << endl;
      exit (EXIT_FAILURE);
    }

  return (EXIT_SUCCESS);
}

