/*
 * $Id: main.cpp 106 2009-02-09 22:55:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/SelfTest/include/test.h"

#define NB_PARAMS 5

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_context                                    (uint32_t)\n"));
  err (_(" * nb_decod_unit                                 (uint32_t)\n"));
  err (_(" * nb_inst_branch_complete                       (uint32_t)\n"));
  err (_(" * nb_inst_branch_speculated     [nb_context]	   (uint32_t)\n"));
  err (_(" * size_general_data                             (uint32_t)\n"));
  err (_(" * size_inst_decod               [nb_decod_unit] (uint32_t)\n"));
  err (_(" * size_inst_commit                              (uint32_t)\n"));
  err (_(" * link_context_to_decod_unit    [nb_context]	   (uint32_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc <= static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];
//const uint32_t size_data = atoi(argv[x++]);
//const uint32_t nb_port   = atoi(argv[x++]);

  uint32_t   _nb_context              = fromString<uint32_t>(argv[x++]);
  uint32_t   _nb_decod_unit           = fromString<uint32_t>(argv[x++]);
  uint32_t   _nb_inst_branch_complete = fromString<uint32_t>(argv[x++]);

  if (argc != static_cast<int>(2+NB_PARAMS+2*_nb_context+1*_nb_decod_unit))
    usage (argc, argv);

  uint32_t * _nb_inst_branch_speculated     = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; i++)
    _nb_inst_branch_speculated [i] = fromString<uint32_t>(argv[x++]);

  uint32_t   _size_general_data = fromString<uint32_t>(argv[x++]);

  uint32_t * _size_inst_decod               = new uint32_t [_nb_decod_unit];
  for (uint32_t i=0; i<_nb_decod_unit; i++)
    _size_inst_decod [i] = fromString<uint32_t>(argv[x++]);
  uint32_t   _size_inst_commit              = fromString<uint32_t>(argv[x++]);
  uint32_t * _link_context_to_decod_unit    = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; i++)
    _link_context_to_decod_unit [i] = fromString<uint32_t>(argv[x++]);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_front_end::front_end::context_state::Parameters * param = new morpheo::behavioural::core::multi_front_end::front_end::context_state::Parameters
	(_nb_context                   ,
	 _nb_decod_unit                ,
	 _nb_inst_branch_complete      ,
	 _nb_inst_branch_speculated    ,
	 _size_general_data            ,
	 _size_inst_decod              ,
	 _size_inst_commit             ,
	 _link_context_to_decod_unit   ,
         true
	 );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  delete [] _nb_inst_branch_speculated;                   
  delete [] _size_inst_decod;              
  delete [] _link_context_to_decod_unit;   

  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("Context_State : no error");
      else
	TEST_KO("Context_State : a lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s\n"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  return (_return);
}
