/*
 * $Id: Parameters_print.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace context_state {


#undef  FUNCTION
#define FUNCTION "Context_State::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_begin(Context_State,FUNCTION);

    XML xml ("context_state");

    xml.balise_open("context_state");
    xml.singleton_begin("nb_context                   "); xml.attribut("value",toString(_nb_context                   )); xml.singleton_end();
//  xml.singleton_begin("nb_decod_unit                "); xml.attribut("value",toString(_nb_decod_unit                )); xml.singleton_end();
    xml.singleton_begin("nb_inst_branch_complete      "); xml.attribut("value",toString(_nb_inst_branch_complete      )); xml.singleton_end();
//  xml.singleton_begin("size_address                 "); xml.attribut("value",toString(_size_address                 )); xml.singleton_end();
//  xml.singleton_begin("size_inst_commit             "); xml.attribut("value",toString(_size_inst_commit             )); xml.singleton_end();

    for (uint32_t i=0;i<_nb_context; i++)
      {
        xml. balise_open_begin("component");
        xml.  attribut("type","context");
        xml.  attribut("id"  ,toString(i));
        xml. balise_open_end();
//         xml.  singleton_begin("size_depth                   "); xml.attribut("value",toString(_size_depth                    [i])); xml.singleton_end();
        xml.  singleton_begin("link_context_to_decod_unit   "); xml.attribut("value",toString(_link_context_to_decod_unit    [i])); xml.singleton_end();
        xml. balise_close();
      }

    for (uint32_t i=0;i<_nb_decod_unit; i++)
      {
        xml. balise_open_begin("component");
        xml.  attribut("type","decod_unit");
        xml.  attribut("id"  ,toString(i));
        xml. balise_open_end();
//      xml.  singleton_begin("size_inst_decod              "); xml.attribut("value",toString(_size_inst_decod              [i])); xml.singleton_end();
        xml. balise_close();
      }
    
    xml.balise_close();

    log_end(Context_State,FUNCTION);
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Context_State::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_front_end::front_end::context_state::Parameters & x)
  {
    log_begin(Context_State,FUNCTION);

    output_stream << x.print(0);
    
    log_end(Context_State,FUNCTION);

    return output_stream;
  };

}; // end namespace context_state
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
