/*
 * $Id: test.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  1024
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/SelfTest/include/test.h"
#include "../../../../../../../../Environment/Queue/include/Sort_Queue.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

//using namespace environment;
using namespace environment::queue;

class cache_req_t
{
public : Tpacket_t  packet;
public : Taddress_t address;

public : cache_req_t (Tpacket_t  packet,
		      Taddress_t address)
  {
    this->packet  = packet ;
    this->address = address;
  }
};

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,1024);
#endif

  Tusage_t _usage = USE_ALL;
//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
  _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Ifetch_unit * _Ifetch_unit = new Ifetch_unit 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC0_SC_SIGNAL(out_ICACHE_REQ_VAL                     ,"out_ICACHE_REQ_VAL                     ",Tcontrol_t           );
  ALLOC0_SC_SIGNAL( in_ICACHE_REQ_ACK                     ," in_ICACHE_REQ_ACK                     ",Tcontrol_t           );
//ALLOC0_SC_SIGNAL(out_ICACHE_REQ_THREAD_ID               ,"out_ICACHE_REQ_THREAD_ID               ",Tcontext_t           );
  ALLOC0_SC_SIGNAL(out_ICACHE_REQ_PACKET_ID               ,"out_ICACHE_REQ_PACKET_ID               ",Tpacket_t            );
  ALLOC0_SC_SIGNAL(out_ICACHE_REQ_ADDRESS                 ,"out_ICACHE_REQ_ADDRESS                 ",Ticache_instruction_t);
  ALLOC0_SC_SIGNAL(out_ICACHE_REQ_TYPE                    ,"out_ICACHE_REQ_TYPE                    ",Ticache_type_t       );
  ALLOC0_SC_SIGNAL( in_ICACHE_RSP_VAL                     ," in_ICACHE_RSP_VAL                     ",Tcontrol_t           );
  ALLOC0_SC_SIGNAL(out_ICACHE_RSP_ACK                     ,"out_ICACHE_RSP_ACK                     ",Tcontrol_t           );
//ALLOC0_SC_SIGNAL( in_ICACHE_RSP_THREAD_ID               ," in_ICACHE_RSP_THREAD_ID               ",Tcontext_t           );
  ALLOC0_SC_SIGNAL( in_ICACHE_RSP_PACKET_ID               ," in_ICACHE_RSP_PACKET_ID               ",Tpacket_t            );
  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_INSTRUCTION             ," in_ICACHE_RSP_INSTRUCTION             ",Ticache_instruction_t,_param->_nb_instruction);
  ALLOC0_SC_SIGNAL( in_ICACHE_RSP_ERROR                   ," in_ICACHE_RSP_ERROR                   ",Ticache_error_t      );
  ALLOC0_SC_SIGNAL(out_PREDICT_VAL                        ,"out_PREDICT_VAL                        ",Tcontrol_t           );
  ALLOC0_SC_SIGNAL( in_PREDICT_ACK                        ," in_PREDICT_ACK                        ",Tcontrol_t           );
  ALLOC0_SC_SIGNAL(out_PREDICT_PC_PREVIOUS                ,"out_PREDICT_PC_PREVIOUS                ",Tgeneral_address_t   );
  ALLOC0_SC_SIGNAL(out_PREDICT_PC_CURRENT                 ,"out_PREDICT_PC_CURRENT                 ",Tgeneral_address_t   );
  ALLOC0_SC_SIGNAL(out_PREDICT_PC_CURRENT_IS_DS_TAKE      ,"out_PREDICT_PC_CURRENT_IS_DS_TAKE      ",Tcontrol_t           );
  ALLOC0_SC_SIGNAL( in_PREDICT_PC_NEXT                    ," in_PREDICT_PC_NEXT                    ",Tgeneral_address_t   );
  ALLOC0_SC_SIGNAL( in_PREDICT_PC_NEXT_IS_DS_TAKE         ," in_PREDICT_PC_NEXT_IS_DS_TAKE         ",Tcontrol_t           );
  ALLOC1_SC_SIGNAL( in_PREDICT_INSTRUCTION_ENABLE         ," in_PREDICT_INSTRUCTION_ENABLE         ",Tcontrol_t           ,_param->_nb_instruction);
  ALLOC0_SC_SIGNAL( in_PREDICT_INST_IFETCH_PTR            ," in_PREDICT_INST_IFETCH_PTR            ",Tinst_ifetch_ptr_t   );
  ALLOC0_SC_SIGNAL( in_PREDICT_BRANCH_STATE               ," in_PREDICT_BRANCH_STATE               ",Tbranch_state_t      );
  ALLOC0_SC_SIGNAL( in_PREDICT_BRANCH_UPDATE_PREDICTION_ID," in_PREDICT_BRANCH_UPDATE_PREDICTION_ID",Tprediction_ptr_t    );
  ALLOC1_SC_SIGNAL(out_DECOD_VAL                          ,"out_DECOD_VAL                          ",Tcontrol_t           ,_param->_nb_instruction);
  ALLOC1_SC_SIGNAL( in_DECOD_ACK                          ," in_DECOD_ACK                          ",Tcontrol_t           ,_param->_nb_instruction);
  ALLOC1_SC_SIGNAL(out_DECOD_INSTRUCTION                  ,"out_DECOD_INSTRUCTION                  ",Tinstruction_t       ,_param->_nb_instruction);
//ALLOC0_SC_SIGNAL(out_DECOD_CONTEXT_ID                   ,"out_DECOD_CONTEXT_ID                   ",Tcontext_t           );
  ALLOC0_SC_SIGNAL(out_DECOD_ADDRESS                      ,"out_DECOD_ADDRESS                      ",Tgeneral_address_t   );
  ALLOC0_SC_SIGNAL(out_DECOD_INST_IFETCH_PTR              ,"out_DECOD_INST_IFETCH_PTR              ",Tinst_ifetch_ptr_t   );
  ALLOC0_SC_SIGNAL(out_DECOD_BRANCH_STATE                 ,"out_DECOD_BRANCH_STATE                 ",Tbranch_state_t      );
  ALLOC0_SC_SIGNAL(out_DECOD_BRANCH_UPDATE_PREDICTION_ID  ,"out_DECOD_BRANCH_UPDATE_PREDICTION_ID  ",Tprediction_ptr_t    );
  ALLOC0_SC_SIGNAL(out_DECOD_EXCEPTION                    ,"out_DECOD_EXCEPTION                    ",Texception_t         );
  ALLOC0_SC_SIGNAL( in_EVENT_VAL                          ," in_EVENT_VAL                          ",Tcontrol_t           );
  ALLOC0_SC_SIGNAL(out_EVENT_ACK                          ,"out_EVENT_ACK                          ",Tcontrol_t           );
  ALLOC0_SC_SIGNAL( in_EVENT_ADDRESS                      ," in_EVENT_ADDRESS                      ",Tgeneral_address_t   );
  ALLOC0_SC_SIGNAL( in_EVENT_ADDRESS_NEXT                 ," in_EVENT_ADDRESS_NEXT                 ",Tgeneral_address_t   );
  ALLOC0_SC_SIGNAL( in_EVENT_ADDRESS_NEXT_VAL             ," in_EVENT_ADDRESS_NEXT_VAL             ",Tcontrol_t           );
  ALLOC0_SC_SIGNAL( in_EVENT_IS_DS_TAKE                   ," in_EVENT_IS_DS_TAKE                   ",Tcontrol_t           );
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Ifetch_unit.\n"),name.c_str());

  (*(_Ifetch_unit->in_CLOCK))        (*(in_CLOCK));
  (*(_Ifetch_unit->in_NRESET))       (*(in_NRESET));

  INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_ICACHE_REQ_VAL                     );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_ICACHE_REQ_ACK                     );
//INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_ICACHE_REQ_THREAD_ID               );
  if (_param->_have_port_ifetch_queue_ptr)
  INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_ICACHE_REQ_PACKET_ID               );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_ICACHE_REQ_ADDRESS                 );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_ICACHE_REQ_TYPE                    );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_ICACHE_RSP_VAL                     );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_ICACHE_RSP_ACK                     );
//INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_ICACHE_RSP_THREAD_ID               );
  if (_param->_have_port_ifetch_queue_ptr)
  INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_ICACHE_RSP_PACKET_ID               );
  INSTANCE1_SC_SIGNAL(_Ifetch_unit, in_ICACHE_RSP_INSTRUCTION             ,_param->_nb_instruction);
  INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_ICACHE_RSP_ERROR                   );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_PREDICT_VAL                        );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_PREDICT_ACK                        );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_PREDICT_PC_PREVIOUS                );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_PREDICT_PC_CURRENT                 );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_PREDICT_PC_CURRENT_IS_DS_TAKE      );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_PREDICT_PC_NEXT                    );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_PREDICT_PC_NEXT_IS_DS_TAKE         );
  INSTANCE1_SC_SIGNAL(_Ifetch_unit, in_PREDICT_INSTRUCTION_ENABLE         ,_param->_nb_instruction);
  if (_param->_have_port_inst_ifetch_ptr)
  INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_PREDICT_INST_IFETCH_PTR            );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_PREDICT_BRANCH_STATE               );
  if (_param->_have_port_depth)
  INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_PREDICT_BRANCH_UPDATE_PREDICTION_ID);
  INSTANCE1_SC_SIGNAL(_Ifetch_unit,out_DECOD_VAL                          ,_param->_nb_instruction);
  INSTANCE1_SC_SIGNAL(_Ifetch_unit, in_DECOD_ACK                          ,_param->_nb_instruction);
  INSTANCE1_SC_SIGNAL(_Ifetch_unit,out_DECOD_INSTRUCTION                  ,_param->_nb_instruction);
//INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_DECOD_CONTEXT_ID                   );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_DECOD_ADDRESS                      );
  if (_param->_have_port_inst_ifetch_ptr)
  INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_DECOD_INST_IFETCH_PTR              );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_DECOD_BRANCH_STATE                 );
  if (_param->_have_port_depth)
  INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_DECOD_BRANCH_UPDATE_PREDICTION_ID  );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_DECOD_EXCEPTION                    );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_EVENT_VAL                          );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit,out_EVENT_ACK                          );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_EVENT_ADDRESS                      );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_EVENT_ADDRESS_NEXT                 );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_EVENT_ADDRESS_NEXT_VAL             );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit, in_EVENT_IS_DS_TAKE                   );

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const  int32_t percent_transaction_icache_req = 75;
  const  int32_t percent_transaction_icache_rsp = 75;
  const  int32_t percent_transaction_predict    = 75;
  const  int32_t percent_transaction_event      =  5;
  const  int32_t percent_hit                    = 90;
  const uint32_t delay_miss_min                 =  5;
  const uint32_t delay_miss_max                 = 10;

  SC_START(0);
  LABEL("Initialisation");

  uint32_t        jump          = 7 ;// packet
  uint32_t        nb_packet_in  = 1;
  uint32_t        nb_packet_out = 1;

  Tcontrol_t      c_val   = false;
  Tcontrol_t      n_val   = false;
  Tcontrol_t      nn_val  = false;

  Tgeneral_data_t c_addr  = 0x100>>2;
  Tgeneral_data_t n_addr  = 0x100>>2;
  Tgeneral_data_t nn_addr = 0x100>>2;

  Tcontrol_t      c_enable [_param->_nb_instruction];
  Tcontrol_t      n_enable [_param->_nb_instruction];

  Tcontrol_t      c_is_ds_take   = 0;
  Tcontrol_t      n_is_ds_take   = 0;		
  Tcontrol_t      nn_is_ds_take  = 0;

  bool            slot_use [_param->_size_queue];

  environment::queue::Parameters * param_cache = new environment::queue::Parameters(_param->_size_queue);
  Sort_Queue<cache_req_t*>       * cache       = new Sort_Queue<cache_req_t*>      ("cache",param_cache);

  cache->reset();

  for (uint32_t i=0; i<_param->_size_queue; i++)
    slot_use [i] = false;

  c_enable [0] = 1;
  for (uint32_t i=1; i<_param->_nb_instruction; i++)
    c_enable [i] = 0;

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Test no out val/ack");
  
  TEST(Tcontrol_t,out_ICACHE_REQ_VAL->read(), 0);
  TEST(Tcontrol_t,out_ICACHE_RSP_ACK->read(), 1);
  TEST(Tcontrol_t,out_PREDICT_VAL   ->read(), 1);
  TEST(Tcontrol_t,out_EVENT_ACK     ->read(), 1);

  for (uint32_t i=0; i<_param->_nb_instruction; i++)
    TEST(Tcontrol_t,out_DECOD_VAL [i]->read(), 0);

//   LABEL("Send Reset");
//   do 
//     {
//       in_EVENT_VAL    ->write(1);
//       in_EVENT_ADDRESS->write(n_addr);
//       SC_START(1);  
//     } while (out_EVENT_ACK->read() == false);
//   in_EVENT_VAL    ->write(0);

  n_val = 1;

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

//       // PREDICT
//       {
// 	in_PREDICT_ACK  ->write((rand()%100)<percent_transaction_predict);
	
// 	SC_START(0);

// 	Taddress_t addr  = (out_PREDICT_PC_CURRENT_IS_DS_TAKE->read())?out_PREDICT_PC_PREVIOUS->read():out_PREDICT_PC_CURRENT->read();

// 	uint32_t   begin = addr%_param->_nb_instruction;
// 	uint32_t   end   = ((begin<<1)>_param->_nb_instruction)?(_param->_nb_instruction-1):(begin<<1);
// 	Tcontrol_t take  = (nb_packet_in%jump)==0;
	
// 	if (take)
// 	  addr += 0x100;
// 	else
// 	  addr += end-begin+1;

// 	for (uint32_t i=0; i<_param->_nb_instruction; i++)
// 	in_PREDICT_INSTRUCTION_ENABLE     [i] ->write((i>=begin) and (i<=end));
// 	in_PREDICT_PC_NEXT                    ->write(addr);
// 	in_PREDICT_PC_NEXT_IS_DS_TAKE         ->write(take);
// 	in_PREDICT_INST_IFETCH_PTR            ->write(0);
// 	in_PREDICT_BRANCH_STATE               ->write(0);
// 	in_PREDICT_BRANCH_UPDATE_PREDICTION_ID->write(0);
//       }

//       // DECOD
//       {
// 	uint32_t nb_decod = (rand()%_param->_nb_instruction);

// 	for (uint32_t i=0; i<_param->_nb_instruction; i++)
// 	  in_DECOD_ACK [i]->write(i<=nb_decod);
//       }

//       // EVENT
//       in_EVENT_VAL             ->write((rand()%100)<percent_transaction_event  );
//       in_EVENT_ADDRESS         ->write(0x77);
//       in_EVENT_ADDRESS_NEXT    ->write(0x171);
//       Tcontrol_t is_ds_take = rand();
//       in_EVENT_ADDRESS_NEXT_VAL->write(is_ds_take);
//       in_EVENT_IS_DS_TAKE      ->write(is_ds_take);

//       // ICACHE_REQ
//       in_ICACHE_REQ_ACK->write((rand()%100)<percent_transaction_icache_req);

//       // ICACHE_RSP
//       {
// 	Tcontrol_t val = false;
// 	if (not cache->empty())
// 	  {
// 	    slot_t<cache_req_t *> cache_rsp = cache->read();

// 	    val = (cache_rsp._delay == 0);
	    
// 	    Tpacket_t  packet  = cache_rsp._data->packet ;
// 	    Taddress_t address = cache_rsp._data->address;
	    
// 	    in_ICACHE_RSP_PACKET_ID      ->write(packet);
// 	    for (uint32_t i=0; i<_param->_nb_instruction; i++)
// 	    in_ICACHE_RSP_INSTRUCTION [i]->write(address+i);
// 	    in_ICACHE_RSP_ERROR          ->write(0);
// 	  }

// 	in_ICACHE_RSP_VAL->write(val);
//       }

//       //-------------------------------------------------
//       SC_START(0);
//       //-------------------------------------------------

//       if (out_ICACHE_REQ_VAL->read() and in_ICACHE_REQ_ACK->read())
// 	{
// 	  LABEL("ICACHE_REQ : Transaction accepted");

// 	  Tpacket_t  packet  = (_param->_have_port_ifetch_queue_ptr)?out_ICACHE_REQ_PACKET_ID->read():0;
// 	  Taddress_t address = out_ICACHE_REQ_ADDRESS->read();

// 	  TEST(bool      ,slot_use[packet], false);
// 	  TEST(Taddress_t,address         ,c_addr);

// 	  slot_use[packet] = true;

// 	  uint32_t delay;
// 	  if ((rand()%100)<percent_hit)
// 	    delay = 1;
// 	  else
// 	    delay = delay_miss_min + (rand()%(delay_miss_max-delay_miss_min+1));

// 	  cache_req_t * cache_req = new cache_req_t(packet,address);
// 	  cache->push(delay,cache_req);

// 	  c_val = 0;
// 	  nb_packet_in ++;
// 	}

//       {
// 	bool find=false;

// 	Taddress_t addr=out_DECOD_ADDRESS->read();
// 	for (uint32_t i=0; i<_param->_nb_instruction; i++)
// 	  if (out_DECOD_VAL[i]->read() and in_DECOD_ACK [i]->read())
// 	    {
// 	      Tinstruction_t inst = out_DECOD_INSTRUCTION[i]->read();
// 	      LABEL("DECOD [%d]  : Transaction accepted",i);
// 	      LABEL("  address     : 0x%x",addr);
// 	      LABEL("  instruction : 0x%x",inst);

// 	      find = true;
// 	      TEST(Tinstruction_t,inst,addr+i);
// 	    }

// 	if (find)
// 	  {
// 	    if (_param->_have_port_inst_ifetch_ptr)
// 	    TEST(Tinst_ifetch_ptr_t, out_DECOD_INST_IFETCH_PTR            ->read(), 0);
// 	    TEST(Tbranch_state_t   , out_DECOD_BRANCH_STATE               ->read(), 0);
// 	    if (_param->_have_port_depth)
// 	    TEST(Tprediction_ptr_t , out_DECOD_BRANCH_UPDATE_PREDICTION_ID->read(), 0);
// 	    TEST(Texception_t      , out_DECOD_EXCEPTION                  ->read(), 0);
// 	  }
//       }
      
//       if (in_ICACHE_RSP_VAL->read() and out_ICACHE_RSP_ACK->read())
// 	{
// 	  LABEL("ICACHE_RSP : Transaction accepted");

// 	  slot_use[cache->read()._data->packet] = false;

// 	  cache->pop();
// 	}

//       if (out_PREDICT_VAL->read() and in_PREDICT_ACK->read())
// 	{
// 	  LABEL("PREDICT    : Transaction accepted");

// 	  if (c_val)
// 	  TEST(Tgeneral_address_t,out_PREDICT_PC_PREVIOUS          ->read(),c_addr      );
// 	  TEST(Tgeneral_address_t,out_PREDICT_PC_CURRENT           ->read(),n_addr      );
// 	  TEST(Tcontrol_t        ,out_PREDICT_PC_CURRENT_IS_DS_TAKE->read(),n_is_ds_take);

// 	  nn_val        = true;
// 	  nn_addr       = in_PREDICT_PC_NEXT           ->read();
// 	  nn_is_ds_take = in_PREDICT_PC_NEXT_IS_DS_TAKE->read();
	
// 	  for (uint32_t i=0; i<_param->_nb_instruction; i++)
// 	  n_enable [i]  = in_PREDICT_INSTRUCTION_ENABLE [i]->read();
// 	}

//       if (not c_val)
// 	{
// 	  if (n_val and nn_val)
// 	    {
// 	      c_val        = 1;
// 	      c_addr       = n_addr;
// 	      c_is_ds_take = n_is_ds_take;

// 	      for (uint32_t i=0; i<_param->_nb_instruction; i++)
// 		c_enable [i] = n_enable [i];
	      
// 	      n_val        = 1;
// 	      n_addr       = nn_addr;
// 	      n_is_ds_take = nn_is_ds_take;
	      
// 	      nn_val       = 0;
// 	    }
// 	}

//       if (in_EVENT_VAL->read() and out_EVENT_ACK->read())
// 	{
// 	  LABEL("EVENT      : Transaction accepted");

// 	  c_val           = false;
// 	  n_val           = true;

// 	  n_addr          = in_EVENT_ADDRESS->read();
// 	  n_is_ds_take    = in_EVENT_IS_DS_TAKE->read();
// 	  nn_val          = in_EVENT_ADDRESS_NEXT_VAL->read();
// 	  nn_addr         = in_EVENT_ADDRESS_NEXT    ->read();
//           nn_is_ds_take   = 0;

// 	  n_enable [0] = 1;
// 	  for (uint32_t i=1; i<_param->_nb_instruction; i++)
// 	    n_enable [i] = 0;
// 	}

      
//       {
// 	string str_c_enable = "";
// 	string str_n_enable = "";

// 	for (uint32_t i=0; i<_param->_nb_instruction; i++)
// 	  {
// 	    str_c_enable += " " + toString(c_enable [i]);
// 	    str_n_enable += " " + toString(n_enable [i]);
// 	  }

// 	LABEL("-----------------------------------");
// 	LABEL("  * nb_packet_in  : %d",nb_packet_in);
// 	LABEL("  * nb_packet_out : %d",nb_packet_out);
// 	LABEL("  * pc   : %d %d %.8x %s",c_val  ,c_is_ds_take , c_addr ,str_c_enable.c_str());
// 	if (nn_val)
// 	  {
// 	LABEL("  * pc+4 : %d %d %.8x %s",n_val  ,n_is_ds_take , n_addr ,str_n_enable.c_str());
// 	  }
// 	else
// 	  {
// 	LABEL("  * pc+4 : %d %d %.8x"   ,n_val  ,n_is_ds_take , n_addr );
// 	  }
// 	LABEL("  * pc+8 : %d %d %.8x"   ,nn_val ,nn_is_ds_take, nn_addr);
// 	LABEL("-----------------------------------");
//       }

//       SC_START(1);
//       cache->transition();
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete    out_ICACHE_REQ_VAL                      ;
  delete     in_ICACHE_REQ_ACK                      ;
//delete    out_ICACHE_REQ_THREAD_ID                ;
  delete    out_ICACHE_REQ_PACKET_ID                ;
  delete    out_ICACHE_REQ_ADDRESS                  ;
  delete    out_ICACHE_REQ_TYPE                     ;

  delete     in_ICACHE_RSP_VAL                      ;
  delete    out_ICACHE_RSP_ACK                      ;
//delete     in_ICACHE_RSP_THREAD_ID                ;
  delete     in_ICACHE_RSP_PACKET_ID                ;
  delete []  in_ICACHE_RSP_INSTRUCTION              ;
  delete     in_ICACHE_RSP_ERROR                    ;

  delete    out_PREDICT_VAL                         ;
  delete     in_PREDICT_ACK                         ;
  delete    out_PREDICT_PC_PREVIOUS                 ;
  delete    out_PREDICT_PC_CURRENT                  ;
  delete    out_PREDICT_PC_CURRENT_IS_DS_TAKE       ;
  delete     in_PREDICT_PC_NEXT                     ;
  delete     in_PREDICT_PC_NEXT_IS_DS_TAKE          ;
  delete []  in_PREDICT_INSTRUCTION_ENABLE          ;
  delete     in_PREDICT_INST_IFETCH_PTR             ;
  delete     in_PREDICT_BRANCH_STATE                ;
  delete     in_PREDICT_BRANCH_UPDATE_PREDICTION_ID ;

  delete [] out_DECOD_VAL                           ;
  delete []  in_DECOD_ACK                           ;
  delete [] out_DECOD_INSTRUCTION                   ;
//delete    out_DECOD_CONTEXT_ID                    ;
  delete    out_DECOD_ADDRESS                       ;
  delete    out_DECOD_INST_IFETCH_PTR               ;
  delete    out_DECOD_BRANCH_STATE                  ;
  delete    out_DECOD_BRANCH_UPDATE_PREDICTION_ID   ;
  delete    out_DECOD_EXCEPTION                     ;

  delete     in_EVENT_VAL                           ;
  delete    out_EVENT_ACK                           ;
  delete     in_EVENT_ADDRESS                       ;
  delete     in_EVENT_ADDRESS_NEXT                  ;
  delete     in_EVENT_ADDRESS_NEXT_VAL              ;
  delete     in_EVENT_IS_DS_TAKE                    ;

  delete    param_cache;
  delete    cache;
#endif

  delete _Ifetch_unit;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
