/*
 * $Id: Two_Level_Branch_Predictor_deallocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/include/Two_Level_Branch_Predictor.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {
namespace two_level_branch_predictor {


#undef  FUNCTION
#define FUNCTION "Two_Level_Branch_Predictor::deallocation"
  void Two_Level_Branch_Predictor::deallocation (void)
  {
    log_begin(Two_Level_Branch_Predictor,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE1_SIGNAL( in_PREDICT_VAL          ,_param->_nb_inst_predict,1                    );
        DELETE1_SIGNAL(out_PREDICT_ACK          ,_param->_nb_inst_predict,1                    );
        DELETE1_SIGNAL( in_PREDICT_ADDRESS      ,_param->_nb_inst_predict,_param->_size_address);
        DELETE1_SIGNAL(out_PREDICT_DIRECTION    ,_param->_nb_inst_predict,1                    );
        DELETE1_SIGNAL(out_PREDICT_HISTORY      ,_param->_nb_inst_predict,_param->_size_history);
        if (_param->_update_on_prediction)                               
          {                                                              
        DELETE1_SIGNAL( in_PREDICT_DIRECTION_VAL,_param->_nb_inst_predict,1                    );
        DELETE1_SIGNAL( in_PREDICT_DIRECTION    ,_param->_nb_inst_predict,1                    );
          }
        
        DELETE1_SIGNAL( in_UPDATE_VAL           ,_param->_nb_inst_update,1                    );
        DELETE1_SIGNAL(out_UPDATE_ACK           ,_param->_nb_inst_update,1                    );
        DELETE1_SIGNAL( in_UPDATE_ADDRESS       ,_param->_nb_inst_update,_param->_size_address);
        DELETE1_SIGNAL( in_UPDATE_HISTORY       ,_param->_nb_inst_update,_param->_size_history);
        DELETE1_SIGNAL( in_UPDATE_HISTORY_VAL   ,_param->_nb_inst_update,1                    );
        DELETE1_SIGNAL( in_UPDATE_DIRECTION     ,_param->_nb_inst_update,1                    );
        if (_param->_update_on_prediction)                              
        DELETE1_SIGNAL( in_UPDATE_MISS          ,_param->_nb_inst_update,1                    );
        
        if (_param->_have_bht)
        DELETE1(reg_BHT                         ,_param->_bht_nb_shifter);
        if (_param->_have_pht)
        DELETE2(reg_PHT                         ,_param->_pht_nb_bank,_param->_pht_size_bank);
        
        DELETE1(internal_PREDICT_ACK            ,_param->_nb_inst_predict);
        if (_param->_update_on_prediction)      
          {                                     
        if (_param->_have_bht)
        DELETE1(internal_PREDICT_BHT_NUM_REG    ,_param->_nb_inst_predict);
        if (_param->_have_pht)
          {
        DELETE1(internal_PREDICT_PHT_NUM_BANK   ,_param->_nb_inst_predict);
        DELETE1(internal_PREDICT_PHT_NUM_REG    ,_param->_nb_inst_predict);
          }
          }                                     
        DELETE1(internal_UPDATE_ACK             ,_param->_nb_inst_update );
      }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    log_end(Two_Level_Branch_Predictor,FUNCTION);
  };

}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
