/*
 * $Id: main.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/SelfTest/include/test.h"
#include "Behavioural/Custom/include/Custom_example.h"

#define NB_PARAMS 13+7*3

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_context                                                 (uint32_t             )\n"));
  err (_(" * nb_decod_unit                                              (uint32_t             )\n"));
  err (_(" * size_general_data                                          (uint32_t             )\n"));
  err (_(" * size_ifetch_queue             [nb_context]                 (uint32_t             )\n"));
  err (_(" * nb_inst_fetch                 [nb_context]                 (uint32_t             )\n"));
  err (_(" * link_context_to_decod_unit    [nb_context]                 (uint32_t             )\n"));
  err (_(" * size_decod_queue              [nb_decod_unit]              (uint32_t             )\n"));
  err (_(" * decod_queue_scheme            [nb_decod_unit]              (Tdecod_queue_scheme_t)\n"));
  err (_(" * nb_inst_decod                 [nb_decod_unit]              (uint32_t             )\n"));
  err (_(" * nb_context_select             [nb_decod_unit]              (uint32_t             )\n"));
  err (_(" * context_select_priority       [nb_decod_unit]              (Tpriority_t          )\n"));
  err (_(" * context_select_load_balancing [nb_decod_unit]              (Tload_balancing_t    )\n"));
  err (_(" * nb_inst_branch_predict                                     (uint32_t             )\n"));
  err (_(" * nb_inst_branch_decod                                       (uint32_t             )\n"));
  err (_(" * nb_inst_branch_update                                      (uint32_t             )\n"));
  err (_(" * nb_inst_branch_complete                                    (uint32_t             )\n"));
  err (_(" * btb_size_queue                                             (uint32_t             )\n"));
  err (_(" * btb_associativity                                          (uint32_t             )\n"));
  err (_(" * btb_size_counter                                           (uint32_t             )\n"));
  err (_(" * btb_victim_scheme                                          (Tvictim_t            )\n"));
  err (_(" * dir_predictor_scheme                                       (Tpredictor_t         )\n"));
  err (_(" * dir_have_bht                  [3]                          (bool                 )\n"));
  err (_(" * dir_bht_size_shifter          [3]                          (uint32_t             )\n"));
  err (_(" * dir_bht_nb_shifter            [3]                          (uint32_t             )\n"));
  err (_(" * dir_have_pht                  [3]                          (bool                 )\n"));
  err (_(" * dir_pht_size_counter          [3]                          (uint32_t             )\n"));
  err (_(" * dir_pht_nb_counter            [3]                          (uint32_t             )\n"));
  err (_(" * dir_pht_size_address_share    [3]                          (uint32_t             )\n"));
  err (_(" * ras_size_queue                [nb_context]                 (uint32_t             )\n"));
  err (_(" * upt_size_queue                [nb_context]                 (uint32_t             )\n"));
  err (_(" * ufpt_size_queue               [nb_context]                 (uint32_t             )\n"));
  err (_(" * size_inst_commit                                           (uint32_t             )\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  for (int32_t i=0; i<argc; ++i)
    msg("%s ",argv[i]);
  msg("\n");

  if (argc <= static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);
  
  uint32_t x = 1;

  string name = argv[x++];
  
  uint32_t             _nb_context                        = fromString<uint32_t         >(argv[x++]);
  uint32_t             _nb_decod_unit                     = fromString<uint32_t         >(argv[x++]);

  if (argc != static_cast<int>(2+NB_PARAMS+6*_nb_context+6*_nb_decod_unit))
    {
      msg("argc                : %d\n",argc);
      msg("all                 : %d\n",(2+NB_PARAMS+6*_nb_context+5*_nb_decod_unit));
      msg("_nb_context         : %d\n",_nb_context);
      msg("_nb_decod_unit      : %d\n",_nb_decod_unit);
      usage (argc, argv);
    }

  uint32_t             _size_general_data                 = fromString<uint32_t         >(argv[x++]);
  uint32_t           * _size_ifetch_queue                 = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; ++i)
    _size_ifetch_queue [i] = fromString<uint32_t>(argv[x++]);

  uint32_t           * _nb_inst_fetch                     = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; ++i)
    _nb_inst_fetch [i] = fromString<uint32_t>(argv[x++]);

  bool              ** _instruction_implemeted            = new bool * [_nb_context];
  for (uint32_t i=0; i<_nb_context; ++i)
    {
      _instruction_implemeted [i] = new bool [NB_INSTRUCTION];
      for (uint32_t j=0; j<NB_INSTRUCTION; ++j)
        _instruction_implemeted [i][j] = true; //fromString<bool>(argv[x++]);
    }

  uint32_t           * _link_context_to_decod_unit        = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; ++i)
    _link_context_to_decod_unit [i] = fromString<uint32_t>(argv[x++]);

  uint32_t           * _size_decod_queue                  = new uint32_t [_nb_decod_unit];
  for (uint32_t i=0; i<_nb_decod_unit; ++i)
    _size_decod_queue [i] = fromString<uint32_t>(argv[x++]);

  decod_unit::decod_queue::Tdecod_queue_scheme_t * _decod_queue_scheme = new decod_unit::decod_queue::Tdecod_queue_scheme_t [_nb_decod_unit];
  for (uint32_t i=0; i<_nb_decod_unit; ++i)
    _decod_queue_scheme [i] = fromString<decod_unit::decod_queue::Tdecod_queue_scheme_t>(argv[x++]);

  uint32_t           * _nb_inst_decod                     = new uint32_t [_nb_decod_unit];
  for (uint32_t i=0; i<_nb_decod_unit; ++i)
    _nb_inst_decod [i] = fromString<uint32_t>(argv[x++]);

  uint32_t           * _nb_context_select                 = new uint32_t [_nb_decod_unit];
  for (uint32_t i=0; i<_nb_decod_unit; ++i)
    _nb_context_select [i] = fromString<uint32_t>(argv[x++]);

  Tpriority_t        * _context_select_priority           = new Tpriority_t [_nb_decod_unit];
  for (uint32_t i=0; i<_nb_decod_unit; ++i)
    _context_select_priority [i] = fromString<Tpriority_t>(argv[x++]);

  Tload_balancing_t  * _context_select_load_balancing     = new Tload_balancing_t [_nb_decod_unit];
  for (uint32_t i=0; i<_nb_decod_unit; ++i)
    _context_select_load_balancing [i] = fromString<Tload_balancing_t>(argv[x++]);

  uint32_t             _nb_inst_branch_predict            = fromString<uint32_t         >(argv[x++]);
  uint32_t             _nb_inst_branch_decod              = fromString<uint32_t         >(argv[x++]);
  uint32_t             _nb_inst_branch_update             = fromString<uint32_t         >(argv[x++]);
  uint32_t             _nb_inst_branch_complete           = fromString<uint32_t         >(argv[x++]);
  uint32_t             _btb_size_queue                    = fromString<uint32_t         >(argv[x++]);
  uint32_t             _btb_associativity                 = fromString<uint32_t         >(argv[x++]);
  uint32_t             _btb_size_counter                  = fromString<uint32_t         >(argv[x++]);
  Tvictim_t            _btb_victim_scheme                 = fromString<Tvictim_t        >(argv[x++]);
  Tpredictor_t         _dir_predictor_scheme              = fromString<Tpredictor_t     >(argv[x++]);
  bool               * _dir_have_bht                      = new bool    [3];
  uint32_t           * _dir_bht_size_shifter              = new uint32_t[3];
  uint32_t           * _dir_bht_nb_shifter                = new uint32_t[3];
  bool               * _dir_have_pht                      = new bool    [3];
  uint32_t           * _dir_pht_size_counter              = new uint32_t[3];
  uint32_t           * _dir_pht_nb_counter                = new uint32_t[3];
  uint32_t           * _dir_pht_size_address_share        = new uint32_t[3];

  for (uint32_t i=0; i<3; i++)
    _dir_have_bht               [i] = fromString<bool    >(argv[x++]);
  for (uint32_t i=0; i<3; i++)
    _dir_bht_size_shifter       [i] = fromString<uint32_t>(argv[x++]);
  for (uint32_t i=0; i<3; i++)
    _dir_bht_nb_shifter         [i] = fromString<uint32_t>(argv[x++]);
  for (uint32_t i=0; i<3; i++)
    _dir_have_pht               [i] = fromString<bool    >(argv[x++]);
  for (uint32_t i=0; i<3; i++)
    _dir_pht_size_counter       [i] = fromString<uint32_t>(argv[x++]);
  for (uint32_t i=0; i<3; i++)
    _dir_pht_nb_counter         [i] = fromString<uint32_t>(argv[x++]);
  for (uint32_t i=0; i<3; i++)
    _dir_pht_size_address_share [i] = fromString<uint32_t>(argv[x++]);

  uint32_t           * _ras_size_queue                    = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; ++i)
    _ras_size_queue [i] = fromString<uint32_t>(argv[x++]);

  uint32_t           * _upt_size_queue                    = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; ++i)
    _upt_size_queue [i] = fromString<uint32_t>(argv[x++]);

  uint32_t           * _ufpt_size_queue                   = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; ++i)
    _ufpt_size_queue [i] = fromString<uint32_t>(argv[x++]);

  uint32_t             _size_inst_commit                  = fromString<uint32_t>(argv[x++]);

  uint32_t             _nb_thread = _nb_context;
  uint32_t           * _translate_num_context_to_num_thread = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; ++i)
    _translate_num_context_to_num_thread [i] = i;

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_front_end::front_end::Parameters * param = new morpheo::behavioural::core::multi_front_end::front_end::Parameters
	(
         _nb_context                          ,
         _nb_decod_unit                       ,
         _size_general_data                   ,
         &(morpheo::behavioural::custom::example_get_custom_information),
         _size_ifetch_queue                   ,
         _nb_inst_fetch                       ,
         _instruction_implemeted              ,
         _link_context_to_decod_unit          ,
         _size_decod_queue                    ,
         _decod_queue_scheme                  ,
         _nb_inst_decod                       ,
         _nb_context_select                   ,
         _context_select_priority             ,
         _context_select_load_balancing       ,
         _nb_inst_branch_predict              ,
         _nb_inst_branch_decod                ,
         _nb_inst_branch_update               ,
         _nb_inst_branch_complete             ,
         _btb_size_queue                      ,
         _btb_associativity                   ,
         _btb_size_counter                    ,
         _btb_victim_scheme                   ,
         _dir_predictor_scheme                ,
         _dir_have_bht                        ,
         _dir_bht_size_shifter                ,
         _dir_bht_nb_shifter                  ,
         _dir_have_pht                        ,
         _dir_pht_size_counter                ,
         _dir_pht_nb_counter                  ,
         _dir_pht_size_address_share          ,
         _ras_size_queue                      ,
         _upt_size_queue                      ,
         _ufpt_size_queue                     ,
         _size_inst_commit                    ,
         _nb_thread                           ,
         _translate_num_context_to_num_thread ,
         true // is_toplevel
         );
      
      msg(_("%s"),param->print(0).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("%s\n"),error.what());
      _return = EXIT_FAILURE;
    }

  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("Front_end : no error");
      else
	TEST_KO("Front_end : a lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
//       msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  delete [] _translate_num_context_to_num_thread ;
  delete [] _dir_have_bht                        ;
  delete [] _dir_bht_size_shifter                ;
  delete [] _dir_bht_nb_shifter                  ;
  delete [] _dir_have_pht                        ;
  delete [] _dir_pht_size_counter                ;
  delete [] _dir_pht_nb_counter                  ;
  delete [] _dir_pht_size_address_share          ;
  delete [] _ufpt_size_queue                   ;
  delete [] _upt_size_queue                    ;
  delete [] _ras_size_queue                    ;
  delete [] _context_select_load_balancing     ;
  delete [] _context_select_priority           ;
  delete [] _nb_context_select                 ;
  delete [] _nb_inst_decod                     ;
  delete [] _decod_queue_scheme                ;
  delete [] _size_decod_queue                  ;
  delete [] _link_context_to_decod_unit        ;
  for (uint32_t i=0; i<_nb_context; ++i)
    delete [] _instruction_implemeted [i];
  delete [] _instruction_implemeted            ;
  delete [] _nb_inst_fetch                     ;
  delete [] _size_ifetch_queue                 ;

  return (_return);
}
