/*
 * $Id: Parameters.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Stat_List_unit/include/Parameters.h"
#include "Common/include/Max.h"
#include "Common/include/BitManipulation.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace stat_list_unit {

#undef  FUNCTION
#define FUNCTION "Stat_List_unit::Parameters"
  Parameters::Parameters (uint32_t   nb_front_end          ,
			  uint32_t * nb_context            ,
			  uint32_t   nb_general_register   ,
			  uint32_t   nb_special_register   ,
			  uint32_t   nb_inst_insert        ,
			  uint32_t   nb_inst_retire        ,
			  uint32_t   nb_reg_free           ,
			  uint32_t   nb_bank               ,
// 			  uint32_t   size_counter          ,
                          bool       is_toplevel)
  {
    log_printf(FUNC,Stat_List_unit,FUNCTION,"Begin");

    _nb_front_end           = nb_front_end       ;
    _nb_context             = nb_context         ;
    _nb_general_register    = nb_general_register;
    _nb_special_register    = nb_special_register;
    _nb_inst_insert         = nb_inst_insert     ;
    _nb_inst_retire         = nb_inst_retire     ;
    _nb_reg_free            = nb_reg_free        ;
    _nb_bank                = nb_bank            ;
//  _size_counter           = size_counter       ;

//  _max_reader             = 1<<size_counter;

    uint32_t nb_thread = 0;

    for (uint32_t i=0; i<nb_front_end; i++)
      nb_thread += nb_context [i];

    _nb_gpr_use_init = (nb_thread*(_nb_general_register_logic-1))+1; // R0 is allocated once time
    _nb_spr_use_init =  nb_thread* _nb_special_register_logic;

    _nb_general_register_by_bank = nb_general_register / nb_bank;
    _nb_special_register_by_bank = nb_special_register / nb_bank;

    _nb_bank_by_port_free = _nb_bank / _nb_reg_free;
    
    _shift_gpr = log2(_nb_general_register_by_bank);
    _shift_spr = log2(_nb_special_register_by_bank);

    _mask_gpr  = gen_mask<Tgeneral_address_t>(log2(_nb_general_register_by_bank));
    _mask_spr  = gen_mask<Tspecial_address_t>(log2(_nb_special_register_by_bank));

    test();
    
    if (is_toplevel)
      {
        _size_general_register  = log2(nb_general_register);
        _size_special_register  = log2(nb_special_register);
        
        copy ();
      }

    log_printf(FUNC,Stat_List_unit,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Stat_List_unit::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Stat_List_unit,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Stat_List_unit,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Stat_List_unit::~Parameters"
  Parameters::~Parameters (void) 
  {
    log_printf(FUNC,Stat_List_unit,FUNCTION,"Begin");
    log_printf(FUNC,Stat_List_unit,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Stat_List_unit::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Stat_List_unit,FUNCTION,"Begin");
    log_printf(FUNC,Stat_List_unit,FUNCTION,"End");
  };


}; // end namespace stat_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
