/*
 * $Id: Multiplier.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Multiplier/include/Multiplier.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace multiplier {


#undef  FUNCTION
#define FUNCTION "Multiplier::Multiplier"
  Multiplier::Multiplier 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::generic::multiplier::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Multiplier,FUNCTION);

    usage_environment(_usage);

    log_printf(INFO,Multiplier,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Multiplier,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Multiplier,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Multiplier,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

// 	log_printf(INFO,Multiplier,FUNCTION,_("<%s> : Method - genMoore"),_name.c_str());

// 	SC_METHOD (genMoore);
// 	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // need internal register
	
// # ifdef SYSTEMCASS_SPECIFIC
// 	// List dependency information
// # endif    
	
#endif
      }
    log_end(Multiplier,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Multiplier::~Multiplier"
  Multiplier::~Multiplier (void)
  {
    log_begin(Multiplier,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Multiplier,FUNCTION,_("<%s> : Deallocation"),_name.c_str());
    deallocation ();

    log_end(Multiplier,FUNCTION);
  };

}; // end namespace multiplier
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
