#ifdef SYSTEMC
/*
 * $Id: Select_Priority_Fixed_genMealy_entity.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Select/Select_Priority_Fixed/include/Select_Priority_Fixed.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace select {
namespace select_priority_fixed {


  void Select_Priority_Fixed::genMealy_entity (void)
  {
    log_printf(FUNC,Select_Priority_Fixed,"genMealy_entity","Begin");

    // init 
      
    Tcontrol_t ack [_param->_nb_entity];
    bool       find  = false;
    Tentity_t  entity;

    if (_param->_encoding_one_hot)
    for (uint32_t i=0; i<_param->_nb_entity; i++)
      ack [i] = 0;

    log_printf(TRACE,Select_Priority_Fixed,"genMealy_entity","Scearch...");
    for (entity=0; entity<_param->_nb_entity; entity++)
      {
	if (PORT_READ(in_VAL [entity]) == 1)
	  {
	    log_printf(TRACE,Select_Priority_Fixed,"genMealy_entity","Find! entity %d",entity);
	    if (_param->_encoding_one_hot)
	      ack [entity] = 1;
	    find = true;
	    break;
	  }
      }
      
    // Write port
    if (_param->_encoding_one_hot)
      for (uint32_t i=0; i<_param->_nb_entity; i++)
	PORT_WRITE(out_ACK [i], ack [i]);

    if (_param->_encoding_compact)
      {
	PORT_WRITE(out_ENTITY    , (find==true)?entity:0);  
	PORT_WRITE(out_ENTITY_ACK,  find                );
      }
    log_printf(FUNC,Select_Priority_Fixed,"genMealy_entity","End");
  };

}; // end namespace select_priority_fixed
}; // end namespace select
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
