/*
 * $Id: Interface_fifo.cpp 82 2008-05-01 16:48:45Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface_fifo.h"

namespace morpheo              {
namespace behavioural          {

  Interface_fifo::Interface_fifo  (std::string         name        
#ifdef POSITION
				   ,direction_t    direction   
				   ,localisation_t localisation
#endif
				   ,Tusage_t       usage
				   ):
    Interface (name         
#ifdef POSITION
	       ,direction   
	       ,localisation
#endif
	       ,usage
	       )
  {
    log_printf(FUNC,Behavioural,"Interface_fifo","Begin");

    _list_signal_val = new (std::list<Signal*>);
    _list_signal_ack = new (std::list<Signal*>);

#ifdef VHDL_TESTBENCH
    _test_exhaustive = true;
    _list_cycle      = new std::list<uint32_t>;
#endif

    log_printf(FUNC,Behavioural,"Interface_fifo","End");
  };

  Interface_fifo::Interface_fifo  (const Interface_fifo & interface_fifo) :
    Interface (interface_fifo._name         
#ifdef POSITION
	       ,interface_fifo._direction   
	       ,interface_fifo._localisation
#endif
	       ,interface_fifo._usage
	       )
  {
    log_printf(FUNC,Behavioural,"Interface_fifo (copy)","Begin");

    _list_signal_val = interface_fifo._list_signal_val;
    _list_signal_ack = interface_fifo._list_signal_ack;

#ifdef VHDL_TESTBENCH
    _test_exhaustive = interface_fifo._test_exhaustive;
    _list_cycle      = interface_fifo._list_cycle;
#endif

    log_printf(FUNC,Behavioural,"Interface_fifo (copy)","End");
  };
  
  Interface_fifo::~Interface_fifo ()
  {
    log_printf(FUNC,Behavioural,"~Interface_fifo","Begin");

    delete _list_signal_val;
    delete _list_signal_ack;

#ifdef VHDL_TESTBENCH
    delete _list_cycle;
#endif

    log_printf(FUNC,Behavioural,"~Interface_fifo","End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
