#ifdef VHDL

/*
 * $Id: Vhdl_get_component.cpp 94 2008-12-15 11:04:03Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include "Common/include/Tabulation.h"

#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::get_component"
  std::string Vhdl::get_component(uint32_t depth,
			     std::string   name)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::string        tab = morpheo::tab(depth);
    std::ostringstream text;

    text <<                                      std::endl
	 << tab << "component " << name       << std::endl;
    if (_list_port.empty() == false)
      text << tab << "\tport ("                 << std::endl
	   << tab << get_port(depth+1)          << std::endl
	   << tab << "\t     );"                << std::endl;
    text << tab << "end component;"           << std::endl;
    
    log_printf(FUNC,Behavioural,FUNCTION,"End");
    return text.str();
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
