/*
 * Test_037
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.ror
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:
        /*
             A (r1)     B (r2)     - D (r3 wait)
                                           (r4)     
         01) 0xdeadbeef 0x00000000 - 0xdeadbeef
         02) 0xdeadbeef 0x00000001 - 0xef56df77
         03) 0xdeadbeef 0x00000002 - 0xf7ab6fbb
         04) 0xdeadbeef 0x00000003 - 0xfbd5b7dd
         05) 0xdeadbeef 0x00000004 - 0xfdeadbee
         06) 0xdeadbeef 0x00000005 - 0x7ef56df7
         07) 0xdeadbeef 0x00000006 - 0xbf7ab6fb
         08) 0xdeadbeef 0x00000007 - 0xdfbd5b7d
         09) 0xdeadbeef 0x00000008 - 0xefdeadbe
         10) 0xdeadbeef 0x00000009 - 0x77ef56df
         11) 0xdeadbeef 0x0000000a - 0xbbf7ab6f
         12) 0xdeadbeef 0x0000000b - 0xddfbd5b7
         13) 0xdeadbeef 0x0000000c - 0xeefdeadb
         14) 0xdeadbeef 0x0000000d - 0xf77ef56d
         15) 0xdeadbeef 0x0000000e - 0xfbbf7ab6
         16) 0xdeadbeef 0x0000000f - 0x7ddfbd5b
         17) 0xdeadbeef 0x00000010 - 0xbeefdead
         18) 0xdeadbeef 0x00000011 - 0xdf77ef56
         19) 0xdeadbeef 0x00000012 - 0x6fbbf7ab
         20) 0xdeadbeef 0x00000013 - 0xb7ddfbd5
         21) 0xdeadbeef 0x00000014 - 0xdbeefdea
         22) 0xdeadbeef 0x00000015 - 0x6df77ef5
         23) 0xdeadbeef 0x00000016 - 0xb6fbbf7a
         24) 0xdeadbeef 0x00000017 - 0x5b7ddfbd
         25) 0xdeadbeef 0x00000018 - 0xadbeefde
         26) 0xdeadbeef 0x00000019 - 0x56df77ef
         27) 0xdeadbeef 0x0000001a - 0xab6fbbf7
         28) 0xdeadbeef 0x0000001b - 0xd5b7ddfb
         29) 0xdeadbeef 0x0000001c - 0xeadbeefd
         30) 0xdeadbeef 0x0000001d - 0xf56df77e
         31) 0xdeadbeef 0x0000001e - 0x7ab6fbbf
         32) 0xdeadbeef 0x0000001f - 0xbd5b7ddf
         33) 0xdeadbeef 0x00000020 - 0xdeadbeef
         34) 0xdeadbeef 0x00000021 - 0xef56df77
         35) 0xdeadbeef 0x00000022 - 0xf7ab6fbb
         */

        /***********/
        /* Test 1  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000000) /* RA */
	l.ori   r2, r2, lo(0x00000000)
	l.movhi r3,     hi(0xdeadbeef) /* RD wait */
	l.ori   r3, r3, lo(0xdeadbeef)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 2  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000001) /* RA */
	l.ori   r2, r2, lo(0x00000001)
	l.movhi r3,     hi(0xef56df77) /* RD wait */
	l.ori   r3, r3, lo(0xef56df77)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 3  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000002) /* RA */
	l.ori   r2, r2, lo(0x00000002)
	l.movhi r3,     hi(0xf7ab6fbb) /* RD wait */
	l.ori   r3, r3, lo(0xf7ab6fbb)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 4  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000003) /* RA */
	l.ori   r2, r2, lo(0x00000003)
	l.movhi r3,     hi(0xfbd5b7dd) /* RD wait */
	l.ori   r3, r3, lo(0xfbd5b7dd)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 5  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000004) /* RA */
	l.ori   r2, r2, lo(0x00000004)
	l.movhi r3,     hi(0xfdeadbee) /* RD wait */
	l.ori   r3, r3, lo(0xfdeadbee)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 6  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000005) /* RA */
	l.ori   r2, r2, lo(0x00000005)
	l.movhi r3,     hi(0x7ef56df7) /* RD wait */
	l.ori   r3, r3, lo(0x7ef56df7)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 7  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000006) /* RA */
	l.ori   r2, r2, lo(0x00000006)
	l.movhi r3,     hi(0xbf7ab6fb) /* RD wait */
	l.ori   r3, r3, lo(0xbf7ab6fb)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 8  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000007) /* RA */
	l.ori   r2, r2, lo(0x00000007)
	l.movhi r3,     hi(0xdfbd5b7d) /* RD wait */
	l.ori   r3, r3, lo(0xdfbd5b7d)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 9  */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000008) /* RA */
	l.ori   r2, r2, lo(0x00000008)
	l.movhi r3,     hi(0xefdeadbe) /* RD wait */
	l.ori   r3, r3, lo(0xefdeadbe)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 10 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000009) /* RA */
	l.ori   r2, r2, lo(0x00000009)
	l.movhi r3,     hi(0x77ef56df) /* RD wait */
	l.ori   r3, r3, lo(0x77ef56df)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 11 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x0000000a) /* RA */
	l.ori   r2, r2, lo(0x0000000a)
	l.movhi r3,     hi(0xbbf7ab6f) /* RD wait */
	l.ori   r3, r3, lo(0xbbf7ab6f)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 12 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x0000000b) /* RA */
	l.ori   r2, r2, lo(0x0000000b)
	l.movhi r3,     hi(0xddfbd5b7) /* RD wait */
	l.ori   r3, r3, lo(0xddfbd5b7)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 13 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x0000000c) /* RA */
	l.ori   r2, r2, lo(0x0000000c)
	l.movhi r3,     hi(0xeefdeadb) /* RD wait */
	l.ori   r3, r3, lo(0xeefdeadb)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 14 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x0000000d) /* RA */
	l.ori   r2, r2, lo(0x0000000d)
	l.movhi r3,     hi(0xf77ef56d) /* RD wait */
	l.ori   r3, r3, lo(0xf77ef56d)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 15 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x0000000e) /* RA */
	l.ori   r2, r2, lo(0x0000000e)
	l.movhi r3,     hi(0xfbbf7ab6) /* RD wait */
	l.ori   r3, r3, lo(0xfbbf7ab6)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 16 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x0000000f) /* RA */
	l.ori   r2, r2, lo(0x0000000f)
	l.movhi r3,     hi(0x7ddfbd5b) /* RD wait */
	l.ori   r3, r3, lo(0x7ddfbd5b)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 17 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000010) /* RA */
	l.ori   r2, r2, lo(0x00000010)
	l.movhi r3,     hi(0xbeefdead) /* RD wait */
	l.ori   r3, r3, lo(0xbeefdead)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 18 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000011) /* RA */
	l.ori   r2, r2, lo(0x00000011)
	l.movhi r3,     hi(0xdf77ef56) /* RD wait */
	l.ori   r3, r3, lo(0xdf77ef56)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 19 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000012) /* RA */
	l.ori   r2, r2, lo(0x00000012)
	l.movhi r3,     hi(0x6fbbf7ab) /* RD wait */
	l.ori   r3, r3, lo(0x6fbbf7ab)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 20 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000013) /* RA */
	l.ori   r2, r2, lo(0x00000013)
	l.movhi r3,     hi(0xb7ddfbd5) /* RD wait */
	l.ori   r3, r3, lo(0xb7ddfbd5)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 21 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000014) /* RA */
	l.ori   r2, r2, lo(0x00000014)
	l.movhi r3,     hi(0xdbeefdea) /* RD wait */
	l.ori   r3, r3, lo(0xdbeefdea)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 22 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000015) /* RA */
	l.ori   r2, r2, lo(0x00000015)
	l.movhi r3,     hi(0x6df77ef5) /* RD wait */
	l.ori   r3, r3, lo(0x6df77ef5)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 23 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000016) /* RA */
	l.ori   r2, r2, lo(0x00000016)
	l.movhi r3,     hi(0xb6fbbf7a) /* RD wait */
	l.ori   r3, r3, lo(0xb6fbbf7a)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 24 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000017) /* RA */
	l.ori   r2, r2, lo(0x00000017)
	l.movhi r3,     hi(0x5b7ddfbd) /* RD wait */
	l.ori   r3, r3, lo(0x5b7ddfbd)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 25 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000018) /* RA */
	l.ori   r2, r2, lo(0x00000018)
	l.movhi r3,     hi(0xadbeefde) /* RD wait */
	l.ori   r3, r3, lo(0xadbeefde)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 26 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000019) /* RA */
	l.ori   r2, r2, lo(0x00000019)
	l.movhi r3,     hi(0x56df77ef) /* RD wait */
	l.ori   r3, r3, lo(0x56df77ef)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 27 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x0000001a) /* RA */
	l.ori   r2, r2, lo(0x0000001a)
	l.movhi r3,     hi(0xab6fbbf7) /* RD wait */
	l.ori   r3, r3, lo(0xab6fbbf7)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 28 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x0000001b) /* RA */
	l.ori   r2, r2, lo(0x0000001b)
	l.movhi r3,     hi(0xd5b7ddfb) /* RD wait */
	l.ori   r3, r3, lo(0xd5b7ddfb)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 29 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x0000001c) /* RA */
	l.ori   r2, r2, lo(0x0000001c)
	l.movhi r3,     hi(0xeadbeefd) /* RD wait */
	l.ori   r3, r3, lo(0xeadbeefd)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 30 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x0000001d) /* RA */
	l.ori   r2, r2, lo(0x0000001d)
	l.movhi r3,     hi(0xf56df77e) /* RD wait */
	l.ori   r3, r3, lo(0xf56df77e)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 31 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x0000001e) /* RA */
	l.ori   r2, r2, lo(0x0000001e)
	l.movhi r3,     hi(0x7ab6fbbf) /* RD wait */
	l.ori   r3, r3, lo(0x7ab6fbbf)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 32 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x0000001f) /* RA */
	l.ori   r2, r2, lo(0x0000001f)
	l.movhi r3,     hi(0xbd5b7ddf) /* RD wait */
	l.ori   r3, r3, lo(0xbd5b7ddf)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 33 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000020) /* RA */
	l.ori   r2, r2, lo(0x00000020)
	l.movhi r3,     hi(0xdeadbeef) /* RD wait */
	l.ori   r3, r3, lo(0xdeadbeef)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 34 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000021) /* RA */
	l.ori   r2, r2, lo(0x00000021)
	l.movhi r3,     hi(0xef56df77) /* RD wait */
	l.ori   r3, r3, lo(0xef56df77)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop

        /***********/
        /* Test 35 */
        /***********/
	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x00000022) /* RA */
	l.ori   r2, r2, lo(0x00000022)
	l.movhi r3,     hi(0xf7ab6fbb) /* RD wait */
	l.ori   r3, r3, lo(0xf7ab6fbb)
        
        l.ror   r4, r1, r2

        /* Test result */
        l.sfeq  r3, r4
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* End */
        /**********/

        l.j     _end_ok
        l.nop
