/*
 * $Id: test.cpp 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"
#include <set>

void test (string name,
	   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Issue_queue * _Issue_queue = new Issue_queue 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC2_SC_SIGNAL( in_ISSUE_IN_VAL                   ," in_ISSUE_IN_VAL                   ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL(out_ISSUE_IN_ACK                   ,"out_ISSUE_IN_ACK                   ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_CONTEXT_ID            ," in_ISSUE_IN_CONTEXT_ID            ",Tcontext_t        ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_FRONT_END_ID          ," in_ISSUE_IN_FRONT_END_ID          ",Tcontext_t        ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_PACKET_ID             ," in_ISSUE_IN_PACKET_ID             ",Tpacket_t         ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_OPERATION             ," in_ISSUE_IN_OPERATION             ",Toperation_t      ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_TYPE                  ," in_ISSUE_IN_TYPE                  ",Ttype_t           ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_STORE_QUEUE_PTR_WRITE ," in_ISSUE_IN_STORE_QUEUE_PTR_WRITE ",Tlsq_ptr_t        ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_LOAD_QUEUE_PTR_WRITE  ," in_ISSUE_IN_LOAD_QUEUE_PTR_WRITE  ",Tlsq_ptr_t        ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_HAS_IMMEDIAT          ," in_ISSUE_IN_HAS_IMMEDIAT          ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_IMMEDIAT              ," in_ISSUE_IN_IMMEDIAT              ",Tgeneral_data_t   ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_READ_RA               ," in_ISSUE_IN_READ_RA               ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_NUM_REG_RA            ," in_ISSUE_IN_NUM_REG_RA            ",Tgeneral_address_t,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_READ_RB               ," in_ISSUE_IN_READ_RB               ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_NUM_REG_RB            ," in_ISSUE_IN_NUM_REG_RB            ",Tgeneral_address_t,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_READ_RC               ," in_ISSUE_IN_READ_RC               ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_NUM_REG_RC            ," in_ISSUE_IN_NUM_REG_RC            ",Tspecial_address_t,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_WRITE_RD              ," in_ISSUE_IN_WRITE_RD              ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_NUM_REG_RD            ," in_ISSUE_IN_NUM_REG_RD            ",Tgeneral_address_t,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_WRITE_RE              ," in_ISSUE_IN_WRITE_RE              ",Tcontrol_t        ,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC2_SC_SIGNAL( in_ISSUE_IN_NUM_REG_RE            ," in_ISSUE_IN_NUM_REG_RE            ",Tspecial_address_t,_param->_nb_rename_unit,_param->_nb_inst_rename[it1]);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_VAL                  ," in_REEXECUTE_VAL                  ",Tcontrol_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_REEXECUTE_ACK                  ,"out_REEXECUTE_ACK                  ",Tcontrol_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_CONTEXT_ID           ," in_REEXECUTE_CONTEXT_ID           ",Tcontext_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_FRONT_END_ID         ," in_REEXECUTE_FRONT_END_ID         ",Tcontext_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_PACKET_ID            ," in_REEXECUTE_PACKET_ID            ",Tpacket_t         ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_OPERATION            ," in_REEXECUTE_OPERATION            ",Toperation_t      ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_TYPE                 ," in_REEXECUTE_TYPE                 ",Ttype_t           ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_STORE_QUEUE_PTR_WRITE," in_REEXECUTE_STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_LOAD_QUEUE_PTR_WRITE ," in_REEXECUTE_LOAD_QUEUE_PTR_WRITE ",Tlsq_ptr_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_HAS_IMMEDIAT         ," in_REEXECUTE_HAS_IMMEDIAT         ",Tcontrol_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_IMMEDIAT             ," in_REEXECUTE_IMMEDIAT             ",Tgeneral_data_t   ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_READ_RA              ," in_REEXECUTE_READ_RA              ",Tcontrol_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_NUM_REG_RA           ," in_REEXECUTE_NUM_REG_RA           ",Tgeneral_address_t,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_READ_RB              ," in_REEXECUTE_READ_RB              ",Tcontrol_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_NUM_REG_RB           ," in_REEXECUTE_NUM_REG_RB           ",Tgeneral_address_t,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_READ_RC              ," in_REEXECUTE_READ_RC              ",Tcontrol_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_NUM_REG_RC           ," in_REEXECUTE_NUM_REG_RC           ",Tspecial_address_t,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_WRITE_RD             ," in_REEXECUTE_WRITE_RD             ",Tcontrol_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_NUM_REG_RD           ," in_REEXECUTE_NUM_REG_RD           ",Tgeneral_address_t,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_WRITE_RE             ," in_REEXECUTE_WRITE_RE             ",Tcontrol_t        ,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL( in_REEXECUTE_NUM_REG_RE           ," in_REEXECUTE_NUM_REG_RE           ",Tspecial_address_t,_param->_nb_inst_reexecute);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_VAL                  ,"out_ISSUE_OUT_VAL                  ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL( in_ISSUE_OUT_ACK                  ," in_ISSUE_OUT_ACK                  ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_CONTEXT_ID           ,"out_ISSUE_OUT_CONTEXT_ID           ",Tcontext_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_FRONT_END_ID         ,"out_ISSUE_OUT_FRONT_END_ID         ",Tcontext_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_PACKET_ID            ,"out_ISSUE_OUT_PACKET_ID            ",Tpacket_t         ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_OPERATION            ,"out_ISSUE_OUT_OPERATION            ",Toperation_t      ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_TYPE                 ,"out_ISSUE_OUT_TYPE                 ",Ttype_t           ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_STORE_QUEUE_PTR_WRITE,"out_ISSUE_OUT_STORE_QUEUE_PTR_WRITE",Tlsq_ptr_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_LOAD_QUEUE_PTR_WRITE ,"out_ISSUE_OUT_LOAD_QUEUE_PTR_WRITE ",Tlsq_ptr_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_HAS_IMMEDIAT         ,"out_ISSUE_OUT_HAS_IMMEDIAT         ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_IMMEDIAT             ,"out_ISSUE_OUT_IMMEDIAT             ",Tgeneral_data_t   ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_READ_RA              ,"out_ISSUE_OUT_READ_RA              ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_NUM_REG_RA           ,"out_ISSUE_OUT_NUM_REG_RA           ",Tgeneral_address_t,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_READ_RB              ,"out_ISSUE_OUT_READ_RB              ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_NUM_REG_RB           ,"out_ISSUE_OUT_NUM_REG_RB           ",Tgeneral_address_t,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_READ_RC              ,"out_ISSUE_OUT_READ_RC              ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_NUM_REG_RC           ,"out_ISSUE_OUT_NUM_REG_RC           ",Tspecial_address_t,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_WRITE_RD             ,"out_ISSUE_OUT_WRITE_RD             ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_NUM_REG_RD           ,"out_ISSUE_OUT_NUM_REG_RD           ",Tgeneral_address_t,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_WRITE_RE             ,"out_ISSUE_OUT_WRITE_RE             ",Tcontrol_t        ,_param->_nb_inst_issue);
  ALLOC1_SC_SIGNAL(out_ISSUE_OUT_NUM_REG_RE           ,"out_ISSUE_OUT_NUM_REG_RE           ",Tspecial_address_t,_param->_nb_inst_issue);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Issue_queue.\n"),name.c_str());

  (*(_Issue_queue->in_CLOCK))        (*(in_CLOCK));
  (*(_Issue_queue->in_NRESET))       (*(in_NRESET));

  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_VAL                   ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue,out_ISSUE_IN_ACK                   ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  if (_param->_have_port_context_id)
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_CONTEXT_ID            ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  if (_param->_have_port_front_end_id)
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_FRONT_END_ID          ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  if (_param->_have_port_rob_ptr  )
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_PACKET_ID             ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_OPERATION             ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_TYPE                  ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_STORE_QUEUE_PTR_WRITE ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_LOAD_QUEUE_PTR_WRITE  ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_HAS_IMMEDIAT          ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_IMMEDIAT              ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_READ_RA               ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_NUM_REG_RA            ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_READ_RB               ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_NUM_REG_RB            ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_READ_RC               ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_NUM_REG_RC            ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_WRITE_RD              ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_NUM_REG_RD            ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_WRITE_RE              ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  INSTANCE2_SC_SIGNAL(_Issue_queue, in_ISSUE_IN_NUM_REG_RE            ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);

  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_VAL                  ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_REEXECUTE_ACK                  ,_param->_nb_inst_reexecute);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_CONTEXT_ID           ,_param->_nb_inst_reexecute);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_FRONT_END_ID         ,_param->_nb_inst_reexecute);
  if (_param->_have_port_rob_ptr  )
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_PACKET_ID            ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_OPERATION            ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_TYPE                 ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_reexecute);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_HAS_IMMEDIAT         ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_IMMEDIAT             ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_READ_RA              ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_NUM_REG_RA           ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_READ_RB              ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_NUM_REG_RB           ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_READ_RC              ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_NUM_REG_RC           ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_WRITE_RD             ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_NUM_REG_RD           ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_WRITE_RE             ,_param->_nb_inst_reexecute);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_REEXECUTE_NUM_REG_RE           ,_param->_nb_inst_reexecute);

  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_VAL                  ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue, in_ISSUE_OUT_ACK                  ,_param->_nb_inst_issue);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_CONTEXT_ID           ,_param->_nb_inst_issue);
  if (_param->_have_port_front_end_id)
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_FRONT_END_ID         ,_param->_nb_inst_issue);
  if (_param->_have_port_rob_ptr  )
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_PACKET_ID            ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_OPERATION            ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_TYPE                 ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_issue);
  if (_param->_have_port_load_queue_ptr)
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_HAS_IMMEDIAT         ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_IMMEDIAT             ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_READ_RA              ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_NUM_REG_RA           ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_READ_RB              ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_NUM_REG_RB           ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_READ_RC              ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_NUM_REG_RC           ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_WRITE_RD             ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_NUM_REG_RD           ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_WRITE_RE             ,_param->_nb_inst_issue);
  INSTANCE1_SC_SIGNAL(_Issue_queue,out_ISSUE_OUT_NUM_REG_RE           ,_param->_nb_inst_issue);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  // Initialisation
  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);

  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  LABEL("Initialisation");

  const  int32_t percent_transaction_reexecute = 35;
  const  int32_t percent_transaction_issue_in  = 65;
  const  int32_t percent_transaction_issue_out = 87;

  #define NB_TYPE 12

  Ttype_t tab_type [] = {TYPE_ALU    ,
			 TYPE_SHIFT  ,
			 TYPE_MOVE   ,
			 TYPE_TEST   ,
			 TYPE_MUL    ,
			 TYPE_DIV    ,
			 TYPE_EXTEND ,
			 TYPE_FIND   ,
			 TYPE_SPECIAL,
			 TYPE_CUSTOM ,
			 TYPE_BRANCH ,
			 TYPE_MEMORY };

  set<Tgeneral_data_t> issue_queue;

  Tgeneral_data_t reexecute_immediat = 0xbeef;
  Tgeneral_data_t reexecute_tab_immediat [_param->_nb_inst_reexecute];
  for (uint32_t i=0; i<_param->_nb_inst_reexecute; i++)
    reexecute_tab_immediat [i] = reexecute_immediat++;

  Tgeneral_data_t   issue_in_immediat = 0x1981;
  Tgeneral_data_t   issue_in_tab_immediat  [_param->_nb_rename_unit][_param->_max_nb_inst_rename];
  for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
    for (uint32_t j=0; j<_param->_nb_inst_rename[i]; j++)
      issue_in_tab_immediat [i][j] = issue_in_immediat ++;

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      for (uint32_t i=0; i<_param->_nb_inst_reexecute; i++)
	{
	  in_REEXECUTE_VAL      [i]->write((rand()%100)<percent_transaction_reexecute);
	  Tgeneral_data_t imm = reexecute_tab_immediat [i];
	  in_REEXECUTE_IMMEDIAT [i]->write((imm<<1)|1);
	  in_REEXECUTE_TYPE     [i]->write(tab_type[imm%NB_TYPE]);
	}

      for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
	for (uint32_t j=0; j<_param->_nb_inst_rename[i]; j++)
	  {
	    in_ISSUE_IN_VAL      [i][j]->write((rand()%100)<percent_transaction_issue_in);
	    Tgeneral_data_t imm = issue_in_tab_immediat [i][j];
	    in_ISSUE_IN_IMMEDIAT [i][j]->write((imm<<1)|1);
	    in_ISSUE_IN_TYPE     [i][j]->write(tab_type[imm%NB_TYPE]);
	  }

      for (uint32_t i=0; i<_param->_nb_inst_issue; i++)
	{
	  in_ISSUE_OUT_ACK      [i]->write((rand()%100)<percent_transaction_issue_out);
	}

      SC_START(0);

      for (uint32_t i=0; i<_param->_nb_inst_issue; i++)
	if (out_ISSUE_OUT_VAL [i]->read() and in_ISSUE_OUT_ACK [i]->read())
	  {
	    LABEL("ISSUE_OUT [%d] - Transaction Accepted.",i);

	    Tgeneral_data_t imm = out_ISSUE_OUT_IMMEDIAT[i]->read();

	    bool find = issue_queue.find(imm) != issue_queue.end();
	    TEST(Tgeneral_data_t,imm, *issue_queue.find(imm));
	    TEST(bool, find, true);
	    issue_queue.erase(imm);

	    if (imm&1)
	      {
		LABEL(" * REEXECUTE");
	      }
	    else
	      {
		LABEL(" * ISSUE_IN");
	      }
	    
	    imm = imm>>1;
	    Ttype_t type = out_ISSUE_OUT_TYPE[i]->read();
	    TEST(Ttype_t,type, tab_type[imm%NB_TYPE]);
	    TEST(bool   ,_param->_table_issue_type[i][type],true);
	  }

      for (uint32_t i=0; i<_param->_nb_inst_reexecute; i++)
	if (in_REEXECUTE_VAL [i]->read() and out_REEXECUTE_ACK [i]->read())
	  {
	    LABEL("REEXECUTE [%d] - Transaction Accepted.",i);
	    reexecute_tab_immediat [i] = reexecute_immediat;
	    reexecute_immediat ++;

	    issue_queue.insert(in_REEXECUTE_IMMEDIAT [i]->read());
	  }

      for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
	for (uint32_t j=0; j<_param->_nb_inst_rename[i]; j++)
	if (in_ISSUE_IN_VAL [i][j]->read() and out_ISSUE_IN_ACK [i][j]->read())
	  {
	    LABEL("ISSUE_IN  [%d][%d] - Transaction Accepted.",i,j);
	    issue_in_tab_immediat [i][j] = issue_in_immediat;
	    issue_in_immediat ++;

	    issue_queue.insert(in_ISSUE_IN_IMMEDIAT [i][j]->read());
	  }

      bool test_size = issue_queue.size() <= (_param->_size_queue+_param->_size_reexecute_queue);
      TEST(bool,test_size,true);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE2_SC_SIGNAL( in_ISSUE_IN_VAL                   ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL(out_ISSUE_IN_ACK                   ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_CONTEXT_ID            ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_FRONT_END_ID          ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_PACKET_ID             ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_OPERATION             ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_TYPE                  ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_STORE_QUEUE_PTR_WRITE ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_LOAD_QUEUE_PTR_WRITE  ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_HAS_IMMEDIAT          ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_IMMEDIAT              ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_READ_RA               ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_NUM_REG_RA            ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_READ_RB               ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_NUM_REG_RB            ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_READ_RC               ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_NUM_REG_RC            ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_WRITE_RD              ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_NUM_REG_RD            ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_WRITE_RE              ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);
  DELETE2_SC_SIGNAL( in_ISSUE_IN_NUM_REG_RE            ,_param->_nb_rename_unit, _param->_nb_inst_rename[it1]);

  DELETE1_SC_SIGNAL( in_REEXECUTE_VAL                  ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL(out_REEXECUTE_ACK                  ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_CONTEXT_ID           ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_FRONT_END_ID         ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_PACKET_ID            ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_OPERATION            ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_TYPE                 ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_HAS_IMMEDIAT         ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_IMMEDIAT             ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_READ_RA              ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_NUM_REG_RA           ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_READ_RB              ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_NUM_REG_RB           ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_READ_RC              ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_NUM_REG_RC           ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_WRITE_RD             ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_NUM_REG_RD           ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_WRITE_RE             ,_param->_nb_inst_reexecute);
  DELETE1_SC_SIGNAL( in_REEXECUTE_NUM_REG_RE           ,_param->_nb_inst_reexecute);

  DELETE1_SC_SIGNAL(out_ISSUE_OUT_VAL                  ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL( in_ISSUE_OUT_ACK                  ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_CONTEXT_ID           ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_FRONT_END_ID         ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_PACKET_ID            ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_OPERATION            ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_TYPE                 ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_STORE_QUEUE_PTR_WRITE,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_LOAD_QUEUE_PTR_WRITE ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_HAS_IMMEDIAT         ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_IMMEDIAT             ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_READ_RA              ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_NUM_REG_RA           ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_READ_RB              ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_NUM_REG_RB           ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_READ_RC              ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_NUM_REG_RC           ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_WRITE_RD             ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_NUM_REG_RD           ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_WRITE_RE             ,_param->_nb_inst_issue);
  DELETE1_SC_SIGNAL(out_ISSUE_OUT_NUM_REG_RE           ,_param->_nb_inst_issue);
    }
#endif

  delete _Issue_queue;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
