/*
 * $Id: test.cpp 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/SelfTest/include/test.h"
#include "Behavioural/include/Allocation.h"
#include "Behavioural/include/Simulation.h"

void test (string name,
	   morpheo::behavioural::core::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  simulation_init(0,0);

  debug_idle_cycle = CYCLE_MAX;

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Core * _Core = new Core 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_VAL         ,"out_ICACHE_REQ_VAL        ",Tcontrol_t           ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL( in_ICACHE_REQ_ACK         ," in_ICACHE_REQ_ACK        ",Tcontrol_t           ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_THREAD_ID   ,"out_ICACHE_REQ_THREAD_ID  ",Tcontext_t           ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_PACKET_ID   ,"out_ICACHE_REQ_PACKET_ID  ",Tpacket_t            ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_ADDRESS     ,"out_ICACHE_REQ_ADDRESS    ",Ticache_address_t    ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL(out_ICACHE_REQ_TYPE        ,"out_ICACHE_REQ_TYPE       ",Ticache_type_t       ,_param->_nb_icache_port);

  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_VAL         ," in_ICACHE_RSP_VAL        ",Tcontrol_t           ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL(out_ICACHE_RSP_ACK         ,"out_ICACHE_RSP_ACK        ",Tcontrol_t           ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_THREAD_ID   ," in_ICACHE_RSP_THREAD_ID  ",Tcontext_t           ,_param->_nb_icache_port);
  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_PACKET_ID   ," in_ICACHE_RSP_PACKET_ID  ",Tpacket_t            ,_param->_nb_icache_port);
  ALLOC2_SC_SIGNAL( in_ICACHE_RSP_INSTRUCTION ," in_ICACHE_RSP_INSTRUCTION",Ticache_instruction_t,_param->_nb_icache_port,_param->_icache_nb_instruction[it1]);
  ALLOC1_SC_SIGNAL( in_ICACHE_RSP_ERROR       ," in_ICACHE_RSP_ERROR      ",Ticache_error_t      ,_param->_nb_icache_port);

  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_VAL         ,"out_DCACHE_REQ_VAL        ",Tcontrol_t           ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL( in_DCACHE_REQ_ACK         ," in_DCACHE_REQ_ACK        ",Tcontrol_t           ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_THREAD_ID   ,"out_DCACHE_REQ_THREAD_ID  ",Tcontext_t           ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_PACKET_ID   ,"out_DCACHE_REQ_PACKET_ID  ",Tpacket_t            ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_ADDRESS     ,"out_DCACHE_REQ_ADDRESS    ",Tdcache_address_t    ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_WDATA       ,"out_DCACHE_REQ_WDATA      ",Tdcache_data_t       ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_REQ_TYPE        ,"out_DCACHE_REQ_TYPE       ",Tdcache_type_t       ,_param->_nb_dcache_port);
                                                                                                 
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_VAL         ," in_DCACHE_RSP_VAL        ",Tcontrol_t           ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL(out_DCACHE_RSP_ACK         ,"out_DCACHE_RSP_ACK        ",Tcontrol_t           ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_THREAD_ID   ," in_DCACHE_RSP_THREAD_ID  ",Tcontext_t           ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_PACKET_ID   ," in_DCACHE_RSP_PACKET_ID  ",Tpacket_t            ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_RDATA       ," in_DCACHE_RSP_RDATA      ",Tdcache_data_t       ,_param->_nb_dcache_port);
  ALLOC1_SC_SIGNAL( in_DCACHE_RSP_ERROR       ," in_DCACHE_RSP_ERROR      ",Tdcache_error_t      ,_param->_nb_dcache_port);
                                                                                                 
  ALLOC1_SC_SIGNAL( in_INTERRUPT_ENABLE       ," in_INTERRUPT_ENABLE      ",Tcontrol_t           ,_param->_nb_thread);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Core.\n"),name.c_str());

  (*(_Core->in_CLOCK))        (*(in_CLOCK));
  (*(_Core->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Core,out_ICACHE_REQ_VAL         ,_param->_nb_icache_port);
  INSTANCE1_SC_SIGNAL(_Core, in_ICACHE_REQ_ACK         ,_param->_nb_icache_port);
  if (_param->_have_port_icache_thread_id)
  INSTANCE1_SC_SIGNAL(_Core,out_ICACHE_REQ_THREAD_ID   ,_param->_nb_icache_port);
  if (_param->_have_port_icache_packet_id)
  INSTANCE1_SC_SIGNAL(_Core,out_ICACHE_REQ_PACKET_ID   ,_param->_nb_icache_port);
  INSTANCE1_SC_SIGNAL(_Core,out_ICACHE_REQ_ADDRESS     ,_param->_nb_icache_port);
  INSTANCE1_SC_SIGNAL(_Core,out_ICACHE_REQ_TYPE        ,_param->_nb_icache_port);

  INSTANCE1_SC_SIGNAL(_Core, in_ICACHE_RSP_VAL         ,_param->_nb_icache_port);
  INSTANCE1_SC_SIGNAL(_Core,out_ICACHE_RSP_ACK         ,_param->_nb_icache_port);
  if (_param->_have_port_icache_thread_id)
  INSTANCE1_SC_SIGNAL(_Core, in_ICACHE_RSP_THREAD_ID   ,_param->_nb_icache_port);
  if (_param->_have_port_icache_packet_id)
  INSTANCE1_SC_SIGNAL(_Core, in_ICACHE_RSP_PACKET_ID   ,_param->_nb_icache_port);
  INSTANCE2_SC_SIGNAL(_Core, in_ICACHE_RSP_INSTRUCTION ,_param->_nb_icache_port,_param->_icache_nb_instruction[it1]);
  INSTANCE1_SC_SIGNAL(_Core, in_ICACHE_RSP_ERROR       ,_param->_nb_icache_port);

  INSTANCE1_SC_SIGNAL(_Core,out_DCACHE_REQ_VAL         ,_param->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Core, in_DCACHE_REQ_ACK         ,_param->_nb_dcache_port);
  if (_param->_have_port_dcache_thread_id)
  INSTANCE1_SC_SIGNAL(_Core,out_DCACHE_REQ_THREAD_ID   ,_param->_nb_dcache_port);
  if (_param->_have_port_dcache_packet_id)
  INSTANCE1_SC_SIGNAL(_Core,out_DCACHE_REQ_PACKET_ID   ,_param->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Core,out_DCACHE_REQ_ADDRESS     ,_param->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Core,out_DCACHE_REQ_WDATA       ,_param->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Core,out_DCACHE_REQ_TYPE        ,_param->_nb_dcache_port);

  INSTANCE1_SC_SIGNAL(_Core, in_DCACHE_RSP_VAL         ,_param->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Core,out_DCACHE_RSP_ACK         ,_param->_nb_dcache_port);
  if (_param->_have_port_dcache_thread_id)
  INSTANCE1_SC_SIGNAL(_Core, in_DCACHE_RSP_THREAD_ID   ,_param->_nb_dcache_port);
  if (_param->_have_port_dcache_packet_id)
  INSTANCE1_SC_SIGNAL(_Core, in_DCACHE_RSP_PACKET_ID   ,_param->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Core, in_DCACHE_RSP_RDATA       ,_param->_nb_dcache_port);
  INSTANCE1_SC_SIGNAL(_Core, in_DCACHE_RSP_ERROR       ,_param->_nb_dcache_port);

  INSTANCE1_SC_SIGNAL(_Core, in_INTERRUPT_ENABLE       ,_param->_nb_thread);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  DELETE1_SC_SIGNAL(out_ICACHE_REQ_VAL         ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL( in_ICACHE_REQ_ACK         ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL(out_ICACHE_REQ_THREAD_ID   ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL(out_ICACHE_REQ_PACKET_ID   ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL(out_ICACHE_REQ_ADDRESS     ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL(out_ICACHE_REQ_TYPE        ,_param->_nb_icache_port);
  
  DELETE1_SC_SIGNAL( in_ICACHE_RSP_VAL         ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL(out_ICACHE_RSP_ACK         ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL( in_ICACHE_RSP_THREAD_ID   ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL( in_ICACHE_RSP_PACKET_ID   ,_param->_nb_icache_port);
  DELETE1_SC_SIGNAL( in_ICACHE_RSP_ERROR       ,_param->_nb_icache_port);
  DELETE2_SC_SIGNAL( in_ICACHE_RSP_INSTRUCTION ,_param->_nb_icache_port,_param->_icache_nb_instruction[it1]);
  
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_VAL         ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL( in_DCACHE_REQ_ACK         ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_THREAD_ID   ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_PACKET_ID   ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_ADDRESS     ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_WDATA       ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_REQ_TYPE        ,_param->_nb_dcache_port);
  
  DELETE1_SC_SIGNAL( in_DCACHE_RSP_VAL         ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL(out_DCACHE_RSP_ACK         ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL( in_DCACHE_RSP_THREAD_ID   ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL( in_DCACHE_RSP_PACKET_ID   ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL( in_DCACHE_RSP_RDATA       ,_param->_nb_dcache_port);
  DELETE1_SC_SIGNAL( in_DCACHE_RSP_ERROR       ,_param->_nb_dcache_port);
  
  DELETE1_SC_SIGNAL( in_INTERRUPT_ENABLE       ,_param->_nb_thread);
    }
#endif

  delete _Core;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
